/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.data.adapter.map;

import io.holunda.camunda.bpm.data.adapter.ReadAdapter;
import io.holunda.camunda.bpm.data.adapter.WrongVariableTypeException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.variable.Variables;

public class MapReadAdapterLockedExternalTask<K, V>
implements ReadAdapter<Map<K, V>> {
    private final LockedExternalTask lockedExternalTask;
    private final String variableName;
    private Class<K> keyClazz;
    private Class<V> valueClazz;

    public MapReadAdapterLockedExternalTask(LockedExternalTask lockedExternalTask, String variableName, Class<K> keyClazz, Class<V> valueClazz) {
        this.lockedExternalTask = lockedExternalTask;
        this.variableName = variableName;
        this.keyClazz = keyClazz;
        this.valueClazz = valueClazz;
    }

    @Override
    public Map<K, V> get() {
        return this.getOptional().get();
    }

    @Override
    public Optional<Map<K, V>> getOptional() {
        return Optional.ofNullable(this.getOrNull(this.getValue()));
    }

    @Override
    public Map<K, V> getLocal() {
        throw new UnsupportedOperationException("Can't get a local variable on an external task");
    }

    @Override
    public Optional<Map<K, V>> getLocalOptional() {
        throw new UnsupportedOperationException("Can't get a local variable on an external task");
    }

    @Override
    public Map<K, V> getOrDefault(Map<K, V> defaultValue) {
        return this.getOptional().orElse(defaultValue);
    }

    @Override
    public Map<K, V> getLocalOrDefault(Map<K, V> defaultValue) {
        throw new UnsupportedOperationException("Can't get a local variable on an external task");
    }

    @Override
    public Map<K, V> getOrNull() {
        return this.getOrNull(this.getValue());
    }

    @Override
    public Map<K, V> getLocalOrNull() {
        throw new UnsupportedOperationException("Can't get a local variable on an external task");
    }

    private Map<K, V> getOrNull(Object value) {
        if (value == null) {
            return null;
        }
        if (Map.class.isAssignableFrom(value.getClass())) {
            Map valueAsMap = (Map)value;
            if (valueAsMap.isEmpty()) {
                return Collections.emptyMap();
            }
            Map.Entry entry = valueAsMap.entrySet().iterator().next();
            if (this.keyClazz.isAssignableFrom(entry.getKey().getClass()) && this.valueClazz.isAssignableFrom(entry.getValue().getClass())) {
                return valueAsMap;
            }
            throw new WrongVariableTypeException("Error reading " + this.variableName + ": Wrong map type detected, expected Map<" + this.keyClazz.getName() + "," + this.valueClazz.getName() + ", but was not found in " + valueAsMap);
        }
        throw new WrongVariableTypeException("Error reading " + this.variableName + ": Couldn't read value of type Map from " + value);
    }

    private Object getValue() {
        return Optional.ofNullable(this.lockedExternalTask.getVariables()).orElse(Variables.createVariables()).get((Object)this.variableName);
    }
}

