/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.data.adapter.list;

import io.holunda.camunda.bpm.data.adapter.AbstractReadWriteAdapter;
import io.holunda.camunda.bpm.data.adapter.ValueWrapperUtil;
import io.holunda.camunda.bpm.data.adapter.WrongVariableTypeException;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.variable.value.TypedValue;

public abstract class AbstractListReadWriteAdapter<T>
extends AbstractReadWriteAdapter<List<T>> {
    protected final Class<T> memberClazz;

    public AbstractListReadWriteAdapter(String variableName, Class<T> memberClazz) {
        super(variableName);
        this.memberClazz = memberClazz;
    }

    protected List<T> getOrNull(Object value) {
        if (value == null) {
            return null;
        }
        if (List.class.isAssignableFrom(value.getClass())) {
            List valueAsList = (List)value;
            if (valueAsList.isEmpty()) {
                return Collections.emptyList();
            }
            if (this.memberClazz.isAssignableFrom(valueAsList.iterator().next().getClass())) {
                return valueAsList;
            }
            throw new WrongVariableTypeException("Error reading " + this.variableName + ": Wrong list type detected, expected " + this.memberClazz.getName() + ", but was not found in " + valueAsList);
        }
        throw new WrongVariableTypeException("Error reading " + this.variableName + ": Couldn't read value of type List from " + value);
    }

    @Override
    public TypedValue getTypedValue(Object value, boolean isTransient) {
        return ValueWrapperUtil.getTypedValue(List.class, value, isTransient);
    }
}

