/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.data.reader;

import io.holunda.camunda.bpm.data.factory.VariableFactory;
import io.holunda.camunda.bpm.data.reader.VariableReader;
import java.util.Objects;
import java.util.Optional;
import org.camunda.bpm.engine.RuntimeService;
import org.jetbrains.annotations.NotNull;

public class RuntimeServiceVariableReader
implements VariableReader {
    private final RuntimeService runtimeService;
    private final String executionId;

    public RuntimeServiceVariableReader(RuntimeService runtimeService, String executionId) {
        this.runtimeService = runtimeService;
        this.executionId = executionId;
    }

    @Override
    @NotNull
    public <T> Optional<T> getOptional(VariableFactory<T> variableFactory) {
        return variableFactory.from(this.runtimeService, this.executionId).getOptional();
    }

    @Override
    @NotNull
    public <T> T get(VariableFactory<T> variableFactory) {
        return variableFactory.from(this.runtimeService, this.executionId).get();
    }

    @Override
    @NotNull
    public <T> T getLocal(VariableFactory<T> variableFactory) {
        return variableFactory.from(this.runtimeService, this.executionId).getLocal();
    }

    @Override
    @NotNull
    public <T> Optional<T> getLocalOptional(VariableFactory<T> variableFactory) {
        return variableFactory.from(this.runtimeService, this.executionId).getLocalOptional();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuntimeServiceVariableReader that = (RuntimeServiceVariableReader)o;
        if (!Objects.equals(this.runtimeService, that.runtimeService)) {
            return false;
        }
        return Objects.equals(this.executionId, that.executionId);
    }

    public int hashCode() {
        int result = this.runtimeService != null ? this.runtimeService.hashCode() : 0;
        result = 31 * result + (this.executionId != null ? this.executionId.hashCode() : 0);
        return result;
    }
}

