/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.data.adapter.basic;

import io.holunda.camunda.bpm.data.adapter.ReadAdapter;
import io.holunda.camunda.bpm.data.adapter.VariableNotFoundException;
import java.util.Optional;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;

public class ReadAdapterLockedExternalTask<T>
implements ReadAdapter<T> {
    private final LockedExternalTask lockedExternalTask;
    private final String variableName;

    public ReadAdapterLockedExternalTask(LockedExternalTask lockedExternalTask, String variableName) {
        this.lockedExternalTask = lockedExternalTask;
        this.variableName = variableName;
    }

    @Override
    public T get() {
        return this.getOptional().orElseThrow(() -> new VariableNotFoundException("Couldn't find required variable '" + this.variableName + "'"));
    }

    @Override
    public Optional<T> getOptional() {
        return Optional.ofNullable(this.lockedExternalTask.getVariables()).map(it -> it.get((Object)this.variableName));
    }

    @Override
    public T getLocal() {
        throw new UnsupportedOperationException("Can't get a local variable on an external task");
    }

    @Override
    public Optional<T> getLocalOptional() {
        throw new UnsupportedOperationException("Can't get a local variable on an external task");
    }

    @Override
    public T getOrDefault(T defaultValue) {
        return this.getOptional().orElse(defaultValue);
    }

    @Override
    public T getLocalOrDefault(T defaultValue) {
        throw new UnsupportedOperationException("Can't get a local variable on an external task");
    }

    @Override
    public T getOrNull() {
        return this.getOptional().orElse(null);
    }

    @Override
    public T getLocalOrNull() {
        throw new UnsupportedOperationException("Can't get a local variable on an external task");
    }
}

