/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.gitective.core.Assert;
import org.gitective.core.filter.commit.CommitFilter;

public abstract class PatternFindCommitFilter
extends CommitFilter {
    protected final String pattern;
    protected final int flags;
    protected final Matcher matcher;

    public PatternFindCommitFilter(String pattern) {
        this(pattern, 0);
    }

    public PatternFindCommitFilter(String pattern, int flags) {
        if (pattern == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Pattern"));
        }
        if (pattern.length() == 0) {
            throw new IllegalArgumentException(Assert.formatNotEmpty("Pattern"));
        }
        this.pattern = pattern;
        this.flags = flags;
        this.matcher = Pattern.compile(pattern, flags).matcher("");
    }

    @Override
    public boolean include(RevWalk walker, RevCommit commit) throws IOException {
        return this.matcher.reset(this.getText(commit)).find() ? true : this.include(false);
    }

    protected abstract CharSequence getText(RevCommit var1);
}

