/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.io.IOException;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.gitective.core.filter.commit.CommitFilter;

public class ParentCountFilter
extends CommitFilter {
    private final int min;
    private final int max;

    public ParentCountFilter() {
        this(2);
    }

    public ParentCountFilter(int min) {
        this(min, Integer.MAX_VALUE);
    }

    public ParentCountFilter(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean include(RevWalk walker, RevCommit commit) throws IOException {
        int parents = commit.getParentCount();
        if (parents < this.min || parents > this.max) {
            return this.include(false);
        }
        return true;
    }

    @Override
    public RevFilter clone() {
        return new ParentCountFilter(this.min, this.max);
    }
}

