/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.util;

import io.hawt.util.Closeables;
import io.hawt.util.IOHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;

public class Zips {
    public static void createZipFile(Logger log, File sourceDir, File outputZipFile) throws IOException {
        FileFilter filter = null;
        Zips.createZipFile(log, sourceDir, outputZipFile, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createZipFile(Logger log, File sourceDir, File outputZipFile, FileFilter filter) throws IOException {
        outputZipFile.getParentFile().mkdirs();
        FileOutputStream os = new FileOutputStream(outputZipFile);
        ZipOutputStream zos = new ZipOutputStream(os);
        try {
            String path = "";
            Zips.zipDirectory(log, sourceDir, zos, path, filter);
        }
        finally {
            Closeables.closeQuietly(zos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDirectory(Logger log, File directory, ZipOutputStream zos, String path, FileFilter filter) throws IOException {
        File[] dirList = directory.listFiles();
        byte[] readBuffer = new byte[8192];
        int bytesIn = 0;
        if (dirList != null) {
            for (File f : dirList) {
                if (f.isDirectory()) {
                    String prefix = path + f.getName() + "/";
                    if (Zips.matches(filter, f)) {
                        zos.putNextEntry(new ZipEntry(prefix));
                        Zips.zipDirectory(log, f, zos, prefix, filter);
                    }
                } else {
                    String entry = path + f.getName();
                    if (Zips.matches(filter, f)) {
                        try (FileInputStream fis = new FileInputStream(f);){
                            ZipEntry anEntry = new ZipEntry(entry);
                            zos.putNextEntry(anEntry);
                            bytesIn = fis.read(readBuffer);
                            while (bytesIn != -1) {
                                zos.write(readBuffer, 0, bytesIn);
                                bytesIn = fis.read(readBuffer);
                            }
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("zipping file " + entry);
                        }
                    }
                }
                zos.closeEntry();
            }
        }
    }

    protected static boolean matches(FileFilter filter, File f) {
        return filter == null || filter.accept(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(InputStream in, File toDir) throws IOException {
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(in));
        try {
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    String entryName = entry.getName();
                    File toFile = new File(toDir, entryName);
                    toFile.getParentFile().mkdirs();
                    FileOutputStream os = new FileOutputStream(toFile);
                    try {
                        try {
                            IOHelper.copy(zis, os);
                        }
                        finally {
                            zis.closeEntry();
                        }
                    }
                    finally {
                        Closeables.closeQuietly(os);
                    }
                }
                entry = zis.getNextEntry();
            }
        }
        finally {
            Closeables.closeQuietly(zis);
        }
    }
}

