/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Ints;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import io.grpc.util.GracefulSwitchLoadBalancer;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;

final class RandomSubsettingLoadBalancer
extends LoadBalancer {
    private final GracefulSwitchLoadBalancer switchLb;
    private final HashFunction hashFunc;

    public RandomSubsettingLoadBalancer(LoadBalancer.Helper helper) {
        this(helper, new Random().nextInt());
    }

    @VisibleForTesting
    RandomSubsettingLoadBalancer(LoadBalancer.Helper helper, int seed) {
        this.switchLb = new GracefulSwitchLoadBalancer((LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper"));
        this.hashFunc = Hashing.murmur3_128((int)seed);
    }

    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        RandomSubsettingLoadBalancerConfig config = (RandomSubsettingLoadBalancerConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        LoadBalancer.ResolvedAddresses subsetAddresses = this.filterEndpoints(resolvedAddresses, config.subsetSize);
        return this.switchLb.acceptResolvedAddresses(subsetAddresses.toBuilder().setLoadBalancingPolicyConfig(config.childConfig).build());
    }

    private LoadBalancer.ResolvedAddresses filterEndpoints(LoadBalancer.ResolvedAddresses resolvedAddresses, int subsetSize) {
        if (subsetSize >= resolvedAddresses.getAddresses().size()) {
            return resolvedAddresses;
        }
        ArrayList<EndpointWithHash> endpointWithHashList = new ArrayList<EndpointWithHash>(resolvedAddresses.getAddresses().size());
        for (EquivalentAddressGroup addressGroup : resolvedAddresses.getAddresses()) {
            HashCode hashCode = this.hashFunc.hashString((CharSequence)((SocketAddress)addressGroup.getAddresses().get(0)).toString(), StandardCharsets.UTF_8);
            endpointWithHashList.add(new EndpointWithHash(addressGroup, hashCode.asLong()));
        }
        Collections.sort(endpointWithHashList, new HashAddressComparator());
        ArrayList<EquivalentAddressGroup> addressGroups = new ArrayList<EquivalentAddressGroup>(subsetSize);
        for (int idx = 0; idx < subsetSize; ++idx) {
            addressGroups.add(((EndpointWithHash)endpointWithHashList.get((int)idx)).addressGroup);
        }
        return resolvedAddresses.toBuilder().setAddresses(addressGroups).build();
    }

    public void handleNameResolutionError(Status error) {
        this.switchLb.handleNameResolutionError(error);
    }

    public void shutdown() {
        this.switchLb.shutdown();
    }

    public static final class RandomSubsettingLoadBalancerConfig {
        public final int subsetSize;
        public final Object childConfig;

        private RandomSubsettingLoadBalancerConfig(int subsetSize, Object childConfig) {
            this.subsetSize = subsetSize;
            this.childConfig = childConfig;
        }

        public static class Builder {
            int subsetSize;
            Object childConfig;

            public Builder setSubsetSize(long subsetSize) {
                Preconditions.checkArgument((subsetSize > 0L ? 1 : 0) != 0, (Object)"Subset size must be greater than 0");
                this.subsetSize = Ints.saturatedCast((long)subsetSize);
                return this;
            }

            public Builder setChildConfig(Object childConfig) {
                this.childConfig = Preconditions.checkNotNull((Object)childConfig, (Object)"childConfig");
                return this;
            }

            public RandomSubsettingLoadBalancerConfig build() {
                Preconditions.checkState(((long)this.subsetSize != 0L ? 1 : 0) != 0, (Object)"Subset size must be set before building the config");
                return new RandomSubsettingLoadBalancerConfig(this.subsetSize, Preconditions.checkNotNull((Object)this.childConfig, (Object)"childConfig"));
            }
        }
    }

    private static final class HashAddressComparator
    implements Comparator<EndpointWithHash> {
        private HashAddressComparator() {
        }

        @Override
        public int compare(EndpointWithHash lhs, EndpointWithHash rhs) {
            return Long.compare(lhs.hashCode, rhs.hashCode);
        }
    }

    private static final class EndpointWithHash {
        public final EquivalentAddressGroup addressGroup;
        public final long hashCode;

        public EndpointWithHash(EquivalentAddressGroup addressGroup, long hashCode) {
            this.addressGroup = addressGroup;
            this.hashCode = hashCode;
        }
    }
}

