/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.util;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.ExperimentalApi;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerRegistry;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.util.ForwardingLoadBalancer;
import io.grpc.util.ForwardingLoadBalancerHelper;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/5999")
@NotThreadSafe
public final class GracefulSwitchLoadBalancer
extends ForwardingLoadBalancer {
    private final LoadBalancer defaultBalancer;
    private final LoadBalancer.Helper helper;
    @Nullable
    private LoadBalancer.Factory currentBalancerFactory;
    private LoadBalancer currentLb;
    @Nullable
    private LoadBalancer.Factory pendingBalancerFactory;
    private LoadBalancer pendingLb;
    private ConnectivityState pendingState;
    private LoadBalancer.SubchannelPicker pendingPicker;
    private boolean currentLbIsReady;

    public GracefulSwitchLoadBalancer(LoadBalancer.Helper helper) {
        this.currentLb = this.defaultBalancer = new LoadBalancer(){

            public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
                throw new AssertionError((Object)"real LB is called instead");
            }

            public void handleNameResolutionError(Status error) {
                GracefulSwitchLoadBalancer.this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError((Status)error)));
            }

            public void shutdown() {
            }
        };
        this.pendingLb = this.defaultBalancer;
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
    }

    @Override
    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        Config config = (Config)resolvedAddresses.getLoadBalancingPolicyConfig();
        this.switchToInternal(config.childFactory);
        this.delegate().handleResolvedAddresses(resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(config.childConfig).build());
    }

    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        Config config = (Config)resolvedAddresses.getLoadBalancingPolicyConfig();
        this.switchToInternal(config.childFactory);
        return this.delegate().acceptResolvedAddresses(resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(config.childConfig).build());
    }

    private void switchToInternal(LoadBalancer.Factory newBalancerFactory) {
        Preconditions.checkNotNull((Object)newBalancerFactory, (Object)"newBalancerFactory");
        if (newBalancerFactory.equals(this.pendingBalancerFactory)) {
            return;
        }
        this.pendingLb.shutdown();
        this.pendingLb = this.defaultBalancer;
        this.pendingBalancerFactory = null;
        this.pendingState = ConnectivityState.CONNECTING;
        this.pendingPicker = new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withNoResult());
        if (newBalancerFactory.equals(this.currentBalancerFactory)) {
            return;
        }
        class PendingHelper
        extends ForwardingLoadBalancerHelper {
            LoadBalancer lb;

            PendingHelper() {
            }

            @Override
            protected LoadBalancer.Helper delegate() {
                return GracefulSwitchLoadBalancer.this.helper;
            }

            @Override
            public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                if (this.lb == GracefulSwitchLoadBalancer.this.pendingLb) {
                    Preconditions.checkState((boolean)GracefulSwitchLoadBalancer.this.currentLbIsReady, (Object)"there's pending lb while current lb has been out of READY");
                    GracefulSwitchLoadBalancer.this.pendingState = newState;
                    GracefulSwitchLoadBalancer.this.pendingPicker = newPicker;
                    if (newState != ConnectivityState.CONNECTING) {
                        GracefulSwitchLoadBalancer.this.swap();
                    }
                } else if (this.lb == GracefulSwitchLoadBalancer.this.currentLb) {
                    GracefulSwitchLoadBalancer.this.currentLbIsReady = newState == ConnectivityState.READY;
                    if (!GracefulSwitchLoadBalancer.this.currentLbIsReady && GracefulSwitchLoadBalancer.this.pendingLb != GracefulSwitchLoadBalancer.this.defaultBalancer) {
                        GracefulSwitchLoadBalancer.this.swap();
                    } else {
                        GracefulSwitchLoadBalancer.this.helper.updateBalancingState(newState, newPicker);
                    }
                }
            }
        }
        PendingHelper pendingHelper = new PendingHelper();
        this.pendingLb = pendingHelper.lb = newBalancerFactory.newLoadBalancer((LoadBalancer.Helper)pendingHelper);
        this.pendingBalancerFactory = newBalancerFactory;
        if (!this.currentLbIsReady) {
            this.swap();
        }
    }

    private void swap() {
        this.helper.updateBalancingState(this.pendingState, this.pendingPicker);
        this.currentLb.shutdown();
        this.currentLb = this.pendingLb;
        this.currentBalancerFactory = this.pendingBalancerFactory;
        this.pendingLb = this.defaultBalancer;
        this.pendingBalancerFactory = null;
    }

    @Override
    protected LoadBalancer delegate() {
        return this.pendingLb == this.defaultBalancer ? this.currentLb : this.pendingLb;
    }

    @Override
    @Deprecated
    public void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
        throw new UnsupportedOperationException("handleSubchannelState() is not supported by " + ((Object)((Object)this)).getClass().getName());
    }

    @Override
    public void shutdown() {
        this.pendingLb.shutdown();
        this.currentLb.shutdown();
    }

    public String delegateType() {
        return this.delegate().getClass().getSimpleName();
    }

    public static NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(List<Map<String, ?>> loadBalancingConfigs) {
        return GracefulSwitchLoadBalancer.parseLoadBalancingPolicyConfig(loadBalancingConfigs, LoadBalancerRegistry.getDefaultRegistry());
    }

    public static NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(List<Map<String, ?>> loadBalancingConfigs, LoadBalancerRegistry lbRegistry) {
        List childConfigCandidates = ServiceConfigUtil.unwrapLoadBalancingConfigList(loadBalancingConfigs);
        if (childConfigCandidates == null || childConfigCandidates.isEmpty()) {
            return NameResolver.ConfigOrError.fromError((Status)Status.UNAVAILABLE.withDescription("No child LB config specified"));
        }
        NameResolver.ConfigOrError selectedConfig = ServiceConfigUtil.selectLbPolicyFromList((List)childConfigCandidates, (LoadBalancerRegistry)lbRegistry);
        if (selectedConfig.getError() != null) {
            Status error = selectedConfig.getError();
            return NameResolver.ConfigOrError.fromError((Status)Status.UNAVAILABLE.withCause(error.getCause()).withDescription(error.getDescription()).augmentDescription("Failed to select child config"));
        }
        ServiceConfigUtil.PolicySelection selection = (ServiceConfigUtil.PolicySelection)selectedConfig.getConfig();
        return NameResolver.ConfigOrError.fromConfig((Object)GracefulSwitchLoadBalancer.createLoadBalancingPolicyConfig((LoadBalancer.Factory)selection.getProvider(), selection.getConfig()));
    }

    public static Object createLoadBalancingPolicyConfig(LoadBalancer.Factory childFactory, @Nullable Object childConfig) {
        return new Config(childFactory, childConfig);
    }

    static final class Config {
        final LoadBalancer.Factory childFactory;
        @Nullable
        final Object childConfig;

        public Config(LoadBalancer.Factory childFactory, @Nullable Object childConfig) {
            this.childFactory = (LoadBalancer.Factory)Preconditions.checkNotNull((Object)childFactory, (Object)"childFactory");
            this.childConfig = childConfig;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config that = (Config)o;
            return Objects.equal((Object)this.childFactory, (Object)that.childFactory) && Objects.equal((Object)this.childConfig, (Object)that.childConfig);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.childFactory, this.childConfig});
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"GracefulSwitchLoadBalancer.Config").add("childFactory", (Object)this.childFactory).add("childConfig", this.childConfig).toString();
        }
    }
}

