/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.DoNotCall;
import io.grpc.ChoiceServerCredentials;
import io.grpc.ExperimentalApi;
import io.grpc.ForwardingServerBuilder;
import io.grpc.InsecureServerCredentials;
import io.grpc.Internal;
import io.grpc.ServerBuilder;
import io.grpc.ServerCredentials;
import io.grpc.ServerStreamTracer;
import io.grpc.TlsServerCredentials;
import io.grpc.internal.FixedObjectPool;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.InternalServer;
import io.grpc.internal.KeepAliveManager;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.ServerImplBuilder;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.internal.SharedResourcePool;
import io.grpc.internal.TransportTracer;
import io.grpc.okhttp.HandshakerSocketFactory;
import io.grpc.okhttp.OkHttpChannelBuilder;
import io.grpc.okhttp.OkHttpServer;
import io.grpc.okhttp.PlaintextHandshakerSocketFactory;
import io.grpc.okhttp.SslSocketFactoryServerCredentials;
import io.grpc.okhttp.TlsServerHandshakerSocketFactory;
import io.grpc.okhttp.internal.Platform;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1785")
public final class OkHttpServerBuilder
extends ForwardingServerBuilder<OkHttpServerBuilder> {
    private static final Logger log = Logger.getLogger(OkHttpServerBuilder.class.getName());
    private static final int DEFAULT_FLOW_CONTROL_WINDOW = 65535;
    static final long MAX_CONNECTION_IDLE_NANOS_DISABLED = Long.MAX_VALUE;
    private static final long MIN_MAX_CONNECTION_IDLE_NANO = TimeUnit.SECONDS.toNanos(1L);
    static final long MAX_CONNECTION_AGE_NANOS_DISABLED = Long.MAX_VALUE;
    static final long MAX_CONNECTION_AGE_GRACE_NANOS_INFINITE = Long.MAX_VALUE;
    private static final long MIN_MAX_CONNECTION_AGE_NANO = TimeUnit.SECONDS.toNanos(1L);
    private static final long AS_LARGE_AS_INFINITE = TimeUnit.DAYS.toNanos(1000L);
    private static final ObjectPool<Executor> DEFAULT_TRANSPORT_EXECUTOR_POOL = OkHttpChannelBuilder.DEFAULT_TRANSPORT_EXECUTOR_POOL;
    final ServerImplBuilder serverImplBuilder = new ServerImplBuilder(this::buildTransportServers);
    final SocketAddress listenAddress;
    final HandshakerSocketFactory handshakerSocketFactory;
    TransportTracer.Factory transportTracerFactory = TransportTracer.getDefaultFactory();
    ObjectPool<Executor> transportExecutorPool = DEFAULT_TRANSPORT_EXECUTOR_POOL;
    ObjectPool<ScheduledExecutorService> scheduledExecutorServicePool = SharedResourcePool.forResource((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE);
    ServerSocketFactory socketFactory = ServerSocketFactory.getDefault();
    long keepAliveTimeNanos = GrpcUtil.DEFAULT_SERVER_KEEPALIVE_TIME_NANOS;
    long keepAliveTimeoutNanos = GrpcUtil.DEFAULT_SERVER_KEEPALIVE_TIMEOUT_NANOS;
    int flowControlWindow = 65535;
    int maxInboundMetadataSize = 8192;
    int maxInboundMessageSize = 0x400000;
    long maxConnectionIdleInNanos = Long.MAX_VALUE;
    boolean permitKeepAliveWithoutCalls;
    long permitKeepAliveTimeInNanos = TimeUnit.MINUTES.toNanos(5L);
    long maxConnectionAgeInNanos = Long.MAX_VALUE;
    long maxConnectionAgeGraceInNanos = Long.MAX_VALUE;
    private static final EnumSet<TlsServerCredentials.Feature> understoodTlsFeatures = EnumSet.of(TlsServerCredentials.Feature.MTLS, TlsServerCredentials.Feature.CUSTOM_MANAGERS);

    @Deprecated
    @DoNotCall(value="Always throws. Use forPort(int, ServerCredentials) instead")
    public static OkHttpServerBuilder forPort(int port) {
        throw new UnsupportedOperationException("Use forPort(int, ServerCredentials) instead");
    }

    public static OkHttpServerBuilder forPort(int port, ServerCredentials creds) {
        return OkHttpServerBuilder.forPort(new InetSocketAddress(port), creds);
    }

    public static OkHttpServerBuilder forPort(SocketAddress address, ServerCredentials creds) {
        HandshakerSocketFactoryResult result = OkHttpServerBuilder.handshakerSocketFactoryFrom(creds);
        if (result.error != null) {
            throw new IllegalArgumentException(result.error);
        }
        return new OkHttpServerBuilder(address, result.factory);
    }

    OkHttpServerBuilder(SocketAddress address, HandshakerSocketFactory handshakerSocketFactory) {
        this.listenAddress = (SocketAddress)Preconditions.checkNotNull((Object)address, (Object)"address");
        this.handshakerSocketFactory = (HandshakerSocketFactory)Preconditions.checkNotNull((Object)handshakerSocketFactory, (Object)"handshakerSocketFactory");
    }

    @Internal
    protected ServerBuilder<?> delegate() {
        return this.serverImplBuilder;
    }

    OkHttpServerBuilder setTransportTracerFactory(TransportTracer.Factory transportTracerFactory) {
        this.transportTracerFactory = transportTracerFactory;
        return this;
    }

    public OkHttpServerBuilder transportExecutor(Executor transportExecutor) {
        this.transportExecutorPool = transportExecutor == null ? DEFAULT_TRANSPORT_EXECUTOR_POOL : new FixedObjectPool((Object)transportExecutor);
        return this;
    }

    public OkHttpServerBuilder socketFactory(ServerSocketFactory socketFactory) {
        this.socketFactory = socketFactory == null ? ServerSocketFactory.getDefault() : socketFactory;
        return this;
    }

    public OkHttpServerBuilder keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        Preconditions.checkArgument((keepAliveTime > 0L ? 1 : 0) != 0, (Object)"keepalive time must be positive");
        this.keepAliveTimeNanos = timeUnit.toNanos(keepAliveTime);
        this.keepAliveTimeNanos = KeepAliveManager.clampKeepAliveTimeInNanos((long)this.keepAliveTimeNanos);
        if (this.keepAliveTimeNanos >= AS_LARGE_AS_INFINITE) {
            this.keepAliveTimeNanos = Long.MAX_VALUE;
        }
        return this;
    }

    public OkHttpServerBuilder maxConnectionIdle(long maxConnectionIdle, TimeUnit timeUnit) {
        Preconditions.checkArgument((maxConnectionIdle > 0L ? 1 : 0) != 0, (String)"max connection idle must be positive: %s", (long)maxConnectionIdle);
        this.maxConnectionIdleInNanos = timeUnit.toNanos(maxConnectionIdle);
        if (this.maxConnectionIdleInNanos >= AS_LARGE_AS_INFINITE) {
            this.maxConnectionIdleInNanos = Long.MAX_VALUE;
        }
        if (this.maxConnectionIdleInNanos < MIN_MAX_CONNECTION_IDLE_NANO) {
            this.maxConnectionIdleInNanos = MIN_MAX_CONNECTION_IDLE_NANO;
        }
        return this;
    }

    public OkHttpServerBuilder maxConnectionAge(long maxConnectionAge, TimeUnit timeUnit) {
        Preconditions.checkArgument((maxConnectionAge > 0L ? 1 : 0) != 0, (String)"max connection age must be positive: %s", (long)maxConnectionAge);
        this.maxConnectionAgeInNanos = timeUnit.toNanos(maxConnectionAge);
        if (this.maxConnectionAgeInNanos >= AS_LARGE_AS_INFINITE) {
            this.maxConnectionAgeInNanos = Long.MAX_VALUE;
        }
        if (this.maxConnectionAgeInNanos < MIN_MAX_CONNECTION_AGE_NANO) {
            this.maxConnectionAgeInNanos = MIN_MAX_CONNECTION_AGE_NANO;
        }
        return this;
    }

    public OkHttpServerBuilder maxConnectionAgeGrace(long maxConnectionAgeGrace, TimeUnit timeUnit) {
        Preconditions.checkArgument((maxConnectionAgeGrace >= 0L ? 1 : 0) != 0, (String)"max connection age grace must be non-negative: %s", (long)maxConnectionAgeGrace);
        this.maxConnectionAgeGraceInNanos = timeUnit.toNanos(maxConnectionAgeGrace);
        if (this.maxConnectionAgeGraceInNanos >= AS_LARGE_AS_INFINITE) {
            this.maxConnectionAgeGraceInNanos = Long.MAX_VALUE;
        }
        return this;
    }

    public OkHttpServerBuilder keepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        Preconditions.checkArgument((keepAliveTimeout > 0L ? 1 : 0) != 0, (Object)"keepalive timeout must be positive");
        this.keepAliveTimeoutNanos = timeUnit.toNanos(keepAliveTimeout);
        this.keepAliveTimeoutNanos = KeepAliveManager.clampKeepAliveTimeoutInNanos((long)this.keepAliveTimeoutNanos);
        return this;
    }

    @CanIgnoreReturnValue
    public OkHttpServerBuilder permitKeepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        Preconditions.checkArgument((keepAliveTime >= 0L ? 1 : 0) != 0, (String)"permit keepalive time must be non-negative: %s", (long)keepAliveTime);
        this.permitKeepAliveTimeInNanos = timeUnit.toNanos(keepAliveTime);
        return this;
    }

    @CanIgnoreReturnValue
    public OkHttpServerBuilder permitKeepAliveWithoutCalls(boolean permit) {
        this.permitKeepAliveWithoutCalls = permit;
        return this;
    }

    public OkHttpServerBuilder flowControlWindow(int flowControlWindow) {
        Preconditions.checkState((flowControlWindow > 0 ? 1 : 0) != 0, (Object)"flowControlWindow must be positive");
        this.flowControlWindow = flowControlWindow;
        return this;
    }

    public OkHttpServerBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorServicePool = new FixedObjectPool((Object)((ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService, (Object)"scheduledExecutorService")));
        return this;
    }

    public OkHttpServerBuilder maxInboundMetadataSize(int bytes) {
        Preconditions.checkArgument((bytes > 0 ? 1 : 0) != 0, (Object)"maxInboundMetadataSize must be > 0");
        this.maxInboundMetadataSize = bytes;
        return this;
    }

    public OkHttpServerBuilder maxInboundMessageSize(int bytes) {
        Preconditions.checkArgument((bytes >= 0 ? 1 : 0) != 0, (Object)"negative max bytes");
        this.maxInboundMessageSize = bytes;
        return this;
    }

    void setStatsEnabled(boolean value) {
        this.serverImplBuilder.setStatsEnabled(value);
    }

    InternalServer buildTransportServers(List<? extends ServerStreamTracer.Factory> streamTracerFactories) {
        return new OkHttpServer(this, streamTracerFactories, this.serverImplBuilder.getChannelz());
    }

    static HandshakerSocketFactoryResult handshakerSocketFactoryFrom(ServerCredentials creds) {
        if (creds instanceof TlsServerCredentials) {
            SSLContext sslContext;
            TlsServerCredentials tlsCreds = (TlsServerCredentials)creds;
            Set incomprehensible = tlsCreds.incomprehensible(understoodTlsFeatures);
            if (!incomprehensible.isEmpty()) {
                return HandshakerSocketFactoryResult.error("TLS features not understood: " + incomprehensible);
            }
            KeyManager[] km = null;
            if (tlsCreds.getKeyManagers() != null) {
                km = tlsCreds.getKeyManagers().toArray(new KeyManager[0]);
            } else if (tlsCreds.getPrivateKey() != null) {
                if (tlsCreds.getPrivateKeyPassword() != null) {
                    return HandshakerSocketFactoryResult.error("byte[]-based private key with password unsupported. Use unencrypted file or KeyManager");
                }
                try {
                    km = OkHttpChannelBuilder.createKeyManager(tlsCreds.getCertificateChain(), tlsCreds.getPrivateKey());
                }
                catch (GeneralSecurityException gse) {
                    log.log(Level.FINE, "Exception loading private key from credential", gse);
                    return HandshakerSocketFactoryResult.error("Unable to load private key: " + gse.getMessage());
                }
            }
            TrustManager[] tm = null;
            if (tlsCreds.getTrustManagers() != null) {
                tm = tlsCreds.getTrustManagers().toArray(new TrustManager[0]);
            } else if (tlsCreds.getRootCertificates() != null) {
                try {
                    tm = OkHttpChannelBuilder.createTrustManager(tlsCreds.getRootCertificates());
                }
                catch (GeneralSecurityException gse) {
                    log.log(Level.FINE, "Exception loading root certificates from credential", gse);
                    return HandshakerSocketFactoryResult.error("Unable to load root certificates: " + gse.getMessage());
                }
            }
            try {
                sslContext = SSLContext.getInstance("TLS", Platform.get().getProvider());
                sslContext.init(km, tm, null);
            }
            catch (GeneralSecurityException gse) {
                throw new RuntimeException("TLS Provider failure", gse);
            }
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            switch (tlsCreds.getClientAuth()) {
                case OPTIONAL: {
                    sslSocketFactory = new ClientCertRequestingSocketFactory(sslSocketFactory, false);
                    break;
                }
                case REQUIRE: {
                    sslSocketFactory = new ClientCertRequestingSocketFactory(sslSocketFactory, true);
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    return HandshakerSocketFactoryResult.error("Unknown TlsServerCredentials.ClientAuth value: " + tlsCreds.getClientAuth());
                }
            }
            return HandshakerSocketFactoryResult.factory(new TlsServerHandshakerSocketFactory(new SslSocketFactoryServerCredentials.ServerCredentials(sslSocketFactory)));
        }
        if (creds instanceof InsecureServerCredentials) {
            return HandshakerSocketFactoryResult.factory(new PlaintextHandshakerSocketFactory());
        }
        if (creds instanceof SslSocketFactoryServerCredentials.ServerCredentials) {
            SslSocketFactoryServerCredentials.ServerCredentials factoryCreds = (SslSocketFactoryServerCredentials.ServerCredentials)creds;
            return HandshakerSocketFactoryResult.factory(new TlsServerHandshakerSocketFactory(factoryCreds));
        }
        if (creds instanceof ChoiceServerCredentials) {
            ChoiceServerCredentials choiceCreds = (ChoiceServerCredentials)creds;
            StringBuilder error = new StringBuilder();
            for (ServerCredentials innerCreds : choiceCreds.getCredentialsList()) {
                HandshakerSocketFactoryResult result = OkHttpServerBuilder.handshakerSocketFactoryFrom(innerCreds);
                if (result.error == null) {
                    return result;
                }
                error.append(", ");
                error.append(result.error);
            }
            return HandshakerSocketFactoryResult.error(error.substring(2));
        }
        return HandshakerSocketFactoryResult.error("Unsupported credential type: " + creds.getClass().getName());
    }

    static final class ClientCertRequestingSocketFactory
    extends SSLSocketFactory {
        private final SSLSocketFactory socketFactory;
        private final boolean required;

        public ClientCertRequestingSocketFactory(SSLSocketFactory socketFactory, boolean required) {
            this.socketFactory = (SSLSocketFactory)Preconditions.checkNotNull((Object)socketFactory, (Object)"socketFactory");
            this.required = required;
        }

        private Socket apply(Socket s) throws IOException {
            if (!(s instanceof SSLSocket)) {
                throw new IOException("SocketFactory " + this.socketFactory + " did not produce an SSLSocket: " + s.getClass());
            }
            SSLSocket sslSocket = (SSLSocket)s;
            if (this.required) {
                sslSocket.setNeedClientAuth(true);
            } else {
                sslSocket.setWantClientAuth(true);
            }
            return sslSocket;
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            return this.apply(this.socketFactory.createSocket(s, host, port, autoClose));
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            return this.apply(this.socketFactory.createSocket(host, port));
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.apply(this.socketFactory.createSocket(host, port, localHost, localPort));
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.apply(this.socketFactory.createSocket(host, port));
        }

        @Override
        public Socket createSocket(InetAddress host, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.apply(this.socketFactory.createSocket(host, port, localAddress, localPort));
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.socketFactory.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.socketFactory.getSupportedCipherSuites();
        }
    }

    static final class HandshakerSocketFactoryResult {
        public final HandshakerSocketFactory factory;
        public final String error;

        private HandshakerSocketFactoryResult(HandshakerSocketFactory factory, String error) {
            this.factory = factory;
            this.error = error;
        }

        public static HandshakerSocketFactoryResult error(String error) {
            return new HandshakerSocketFactoryResult(null, (String)Preconditions.checkNotNull((Object)error, (Object)"error"));
        }

        public static HandshakerSocketFactoryResult factory(HandshakerSocketFactory factory) {
            return new HandshakerSocketFactoryResult((HandshakerSocketFactory)Preconditions.checkNotNull((Object)factory, (Object)"factory"), null);
        }
    }
}

