/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import io.grpc.NameResolver;
import io.grpc.Uri;
import java.net.URI;
import javax.annotation.Nullable;

interface UriWrapper {
    public static UriWrapper wrap(URI uri) {
        return new JavaNetUriWrapper(uri);
    }

    public static UriWrapper wrap(Uri uri) {
        return new IoGrpcUriWrapper(uri);
    }

    public NameResolver newNameResolver(NameResolver.Factory var1, NameResolver.Args var2);

    public String getScheme();

    @Nullable
    public String getAuthority();

    public static final class IoGrpcUriWrapper
    implements UriWrapper {
        private final Uri uri;

        private IoGrpcUriWrapper(Uri uri) {
            this.uri = (Uri)Preconditions.checkNotNull((Object)uri);
        }

        @Override
        public NameResolver newNameResolver(NameResolver.Factory factory, NameResolver.Args args) {
            return factory.newNameResolver(this.uri, args);
        }

        @Override
        public String getScheme() {
            return this.uri.getScheme();
        }

        @Override
        public String getAuthority() {
            return this.uri.getAuthority();
        }

        public String toString() {
            return this.uri.toString();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof IoGrpcUriWrapper)) {
                return false;
            }
            return this.uri.equals((Object)((IoGrpcUriWrapper)other).uri);
        }

        public int hashCode() {
            return this.uri.hashCode();
        }
    }

    public static final class JavaNetUriWrapper
    implements UriWrapper {
        private final URI uri;

        private JavaNetUriWrapper(URI uri) {
            this.uri = (URI)Preconditions.checkNotNull((Object)uri);
        }

        @Override
        public NameResolver newNameResolver(NameResolver.Factory factory, NameResolver.Args args) {
            return factory.newNameResolver(this.uri, args);
        }

        @Override
        public String getScheme() {
            return this.uri.getScheme();
        }

        @Override
        public String getAuthority() {
            return this.uri.getAuthority();
        }

        public String toString() {
            return this.uri.toString();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof JavaNetUriWrapper)) {
                return false;
            }
            return this.uri.equals(((JavaNetUriWrapper)other).uri);
        }

        public int hashCode() {
            return this.uri.hashCode();
        }
    }
}

