/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.StatusOr;
import io.grpc.SynchronizationContext;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

final class OobNameResolverProvider
extends NameResolverProvider {
    private final String authority;
    private final SynchronizationContext parentSyncContext;
    private final Collection<OobNameResolver> resolvers = new LinkedList<OobNameResolver>();
    private List<EquivalentAddressGroup> lastEags;

    public OobNameResolverProvider(String authority, List<EquivalentAddressGroup> eags, SynchronizationContext syncContext) {
        this.authority = Objects.requireNonNull(authority, "authority");
        this.lastEags = Objects.requireNonNull(eags, "eags");
        this.parentSyncContext = Objects.requireNonNull(syncContext, "syncContext");
    }

    public String getDefaultScheme() {
        return "oob";
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 5;
    }

    public void updateAddresses(List<EquivalentAddressGroup> eags) {
        Objects.requireNonNull(eags, "eags");
        this.parentSyncContext.execute(() -> {
            this.lastEags = eags;
            for (OobNameResolver resolver : this.resolvers) {
                resolver.updateAddresses(eags);
            }
        });
    }

    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        return new OobNameResolver(args.getSynchronizationContext());
    }

    final class OobNameResolver
    extends NameResolver {
        private final SynchronizationContext syncContext;
        private NameResolver.Listener2 listener;

        public OobNameResolver(SynchronizationContext syncContext) {
            this.syncContext = Objects.requireNonNull(syncContext, "syncContext");
        }

        public String getServiceAuthority() {
            return OobNameResolverProvider.this.authority;
        }

        public void start(NameResolver.Listener2 listener) {
            this.listener = Objects.requireNonNull(listener, "listener");
            OobNameResolverProvider.this.parentSyncContext.execute(() -> {
                OobNameResolverProvider.this.resolvers.add(this);
                this.updateAddresses(OobNameResolverProvider.this.lastEags);
            });
        }

        void updateAddresses(List<EquivalentAddressGroup> eags) {
            OobNameResolverProvider.this.parentSyncContext.throwIfNotInThisSynchronizationContext();
            this.syncContext.execute(() -> {
                if (this.listener == null) {
                    return;
                }
                this.listener.onResult2(NameResolver.ResolutionResult.newBuilder().setAddressesOrError(StatusOr.fromValue((Object)OobNameResolverProvider.this.lastEags)).build());
            });
        }

        public void shutdown() {
            this.listener = null;
            OobNameResolverProvider.this.parentSyncContext.execute(() -> OobNameResolverProvider.this.resolvers.remove((Object)this));
        }
    }
}

