/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import io.grpc.InternalServiceProviders;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.Uri;
import io.grpc.internal.DnsNameResolver;
import io.grpc.internal.GrpcUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class DnsNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "dns";
    private static final boolean IS_ANDROID = InternalServiceProviders.isAndroid((ClassLoader)DnsNameResolverProvider.class.getClassLoader());

    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (SCHEME.equals(targetUri.getScheme())) {
            String targetPath = (String)Preconditions.checkNotNull((Object)targetUri.getPath(), (Object)"targetPath");
            Preconditions.checkArgument((boolean)targetPath.startsWith("/"), (String)"the path component (%s) of the target (%s) must start with '/'", (Object)targetPath, (Object)targetUri);
            String name = targetPath.substring(1);
            return new DnsNameResolver(targetUri.getAuthority(), name, args, GrpcUtil.SHARED_CHANNEL_EXECUTOR, Stopwatch.createUnstarted(), IS_ANDROID);
        }
        return null;
    }

    public NameResolver newNameResolver(Uri targetUri, NameResolver.Args args) {
        if (SCHEME.equals(targetUri.getScheme())) {
            List pathSegments = targetUri.getPathSegments();
            Preconditions.checkArgument((!pathSegments.isEmpty() ? 1 : 0) != 0, (String)"expected 1 path segment in target %s but found %s", (Object)targetUri, (Object)pathSegments);
            String domainNameToResolve = (String)pathSegments.get(0);
            return new DnsNameResolver(targetUri.getAuthority(), domainNameToResolve, args, GrpcUtil.SHARED_CHANNEL_EXECUTOR, Stopwatch.createUnstarted(), IS_ANDROID);
        }
        return null;
    }

    public String getDefaultScheme() {
        return SCHEME;
    }

    protected boolean isAvailable() {
        return true;
    }

    public int priority() {
        return 5;
    }

    public Collection<Class<? extends SocketAddress>> getProducedSocketAddressTypes() {
        return Collections.singleton(InetSocketAddress.class);
    }
}

