/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.ChannelLogger;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.FixedPickerLoadBalancerProvider;
import io.grpc.internal.ServiceConfigUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class AutoConfiguredLoadBalancerFactory
extends LoadBalancerProvider {
    private final LoadBalancerRegistry registry;
    private final LoadBalancerProvider defaultProvider;

    public AutoConfiguredLoadBalancerFactory(String defaultPolicy) {
        this(LoadBalancerRegistry.getDefaultRegistry(), defaultPolicy);
    }

    @VisibleForTesting
    AutoConfiguredLoadBalancerFactory(LoadBalancerRegistry registry, String defaultPolicy) {
        this.registry = (LoadBalancerRegistry)Preconditions.checkNotNull((Object)registry, (Object)"registry");
        LoadBalancerProvider provider = registry.getProvider((String)Preconditions.checkNotNull((Object)defaultPolicy, (Object)"defaultPolicy"));
        if (provider == null) {
            Status status = Status.INTERNAL.withDescription("Could not find policy '" + defaultPolicy + "'. Make sure its implementation is either registered to LoadBalancerRegistry or included in META-INF/services/io.grpc.LoadBalancerProvider from your jar files.");
            provider = new FixedPickerLoadBalancerProvider(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError((Status)status)), status);
        }
        this.defaultProvider = provider;
    }

    public AutoConfiguredLoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new AutoConfiguredLoadBalancer(helper);
    }

    @Nullable
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> serviceConfig) {
        try {
            List<ServiceConfigUtil.LbConfig> loadBalancerConfigs = null;
            if (serviceConfig != null) {
                List<Map<String, ?>> rawLbConfigs = ServiceConfigUtil.getLoadBalancingConfigsFromServiceConfig(serviceConfig);
                loadBalancerConfigs = ServiceConfigUtil.unwrapLoadBalancingConfigList(rawLbConfigs);
            }
            if (loadBalancerConfigs != null && !loadBalancerConfigs.isEmpty()) {
                return ServiceConfigUtil.selectLbPolicyFromList(loadBalancerConfigs, this.registry);
            }
            return null;
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError((Status)Status.UNKNOWN.withDescription("can't parse load balancer configuration").withCause((Throwable)e));
        }
    }

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "auto_configured_internal";
    }

    @VisibleForTesting
    public final class AutoConfiguredLoadBalancer
    extends LoadBalancer {
        private final LoadBalancer.Helper helper;
        private LoadBalancer delegate;
        private LoadBalancerProvider delegateProvider;

        AutoConfiguredLoadBalancer(LoadBalancer.Helper helper) {
            this.helper = helper;
            this.delegateProvider = AutoConfiguredLoadBalancerFactory.this.defaultProvider;
            this.delegate = this.delegateProvider.newLoadBalancer(helper);
        }

        public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
            Object lbConfig;
            ServiceConfigUtil.PolicySelection policySelection = (ServiceConfigUtil.PolicySelection)resolvedAddresses.getLoadBalancingPolicyConfig();
            if (policySelection == null) {
                policySelection = new ServiceConfigUtil.PolicySelection(AutoConfiguredLoadBalancerFactory.this.defaultProvider, null);
            }
            if (this.delegateProvider == null || !policySelection.provider.getPolicyName().equals(this.delegateProvider.getPolicyName())) {
                this.helper.updateBalancingState(ConnectivityState.CONNECTING, (LoadBalancer.SubchannelPicker)new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withNoResult()));
                this.delegate.shutdown();
                this.delegateProvider = policySelection.provider;
                LoadBalancer old = this.delegate;
                this.delegate = this.delegateProvider.newLoadBalancer(this.helper);
                this.helper.getChannelLogger().log(ChannelLogger.ChannelLogLevel.INFO, "Load balancer changed from {0} to {1}", new Object[]{old.getClass().getSimpleName(), this.delegate.getClass().getSimpleName()});
            }
            if ((lbConfig = policySelection.config) != null) {
                this.helper.getChannelLogger().log(ChannelLogger.ChannelLogLevel.DEBUG, "Load-balancing config: {0}", new Object[]{policySelection.config});
            }
            return this.getDelegate().acceptResolvedAddresses(LoadBalancer.ResolvedAddresses.newBuilder().setAddresses(resolvedAddresses.getAddresses()).setAttributes(resolvedAddresses.getAttributes()).setLoadBalancingPolicyConfig(lbConfig).build());
        }

        public void handleNameResolutionError(Status error) {
            this.getDelegate().handleNameResolutionError(error);
        }

        @Deprecated
        public void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
            this.getDelegate().handleSubchannelState(subchannel, stateInfo);
        }

        public void requestConnection() {
            this.getDelegate().requestConnection();
        }

        public void shutdown() {
            this.delegate.shutdown();
            this.delegate = null;
        }

        @VisibleForTesting
        public LoadBalancer getDelegate() {
            return this.delegate;
        }

        @VisibleForTesting
        void setDelegate(LoadBalancer lb) {
            this.delegate = lb;
        }

        @VisibleForTesting
        LoadBalancerProvider getDelegateProvider() {
            return this.delegateProvider;
        }
    }
}

