/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.spring6.micrometer.configure;

import io.github.resilience4j.common.CompositeCustomizer;
import io.github.resilience4j.common.micrometer.configuration.CommonTimerConfigurationProperties;
import io.github.resilience4j.common.micrometer.configuration.TimerConfigCustomizer;
import io.github.resilience4j.consumer.DefaultEventConsumerRegistry;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.registry.CompositeRegistryEventConsumer;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.micrometer.Timer;
import io.github.resilience4j.micrometer.TimerConfig;
import io.github.resilience4j.micrometer.TimerRegistry;
import io.github.resilience4j.micrometer.event.TimerEvent;
import io.github.resilience4j.spring6.fallback.FallbackExecutor;
import io.github.resilience4j.spring6.fallback.configure.FallbackConfiguration;
import io.github.resilience4j.spring6.micrometer.configure.ReactorTimerAspectExt;
import io.github.resilience4j.spring6.micrometer.configure.RxJava2TimerAspectExt;
import io.github.resilience4j.spring6.micrometer.configure.TimerAspect;
import io.github.resilience4j.spring6.micrometer.configure.TimerAspectExt;
import io.github.resilience4j.spring6.micrometer.configure.TimerConfigurationProperties;
import io.github.resilience4j.spring6.spelresolver.SpelResolver;
import io.github.resilience4j.spring6.spelresolver.configure.SpelResolverConfiguration;
import io.github.resilience4j.spring6.utils.AspectJOnClasspathCondition;
import io.github.resilience4j.spring6.utils.ReactorOnClasspathCondition;
import io.github.resilience4j.spring6.utils.RxJava2OnClasspathCondition;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@Configuration
@Import(value={FallbackConfiguration.class, SpelResolverConfiguration.class})
public class TimerConfiguration {
    @Bean
    @Qualifier(value="compositeTimerCustomizer")
    public CompositeCustomizer<TimerConfigCustomizer> compositeTimerCustomizer(@Autowired(required=false) List<TimerConfigCustomizer> customizers) {
        return new CompositeCustomizer(customizers);
    }

    @Bean
    public TimerRegistry timerRegistry(TimerConfigurationProperties timerConfigurationProperties, EventConsumerRegistry<TimerEvent> timerEventConsumerRegistry, RegistryEventConsumer<Timer> timerRegistryEventConsumer, @Qualifier(value="compositeTimerCustomizer") CompositeCustomizer<TimerConfigCustomizer> compositeTimerCustomizer, @Autowired(required=false) MeterRegistry registry) {
        TimerRegistry timerRegistry = TimerConfiguration.createTimerRegistry(timerConfigurationProperties, timerRegistryEventConsumer, compositeTimerCustomizer, registry);
        TimerConfiguration.registerEventConsumer(timerRegistry, timerEventConsumerRegistry, timerConfigurationProperties);
        this.initTimerRegistry(timerRegistry, timerConfigurationProperties, compositeTimerCustomizer);
        return timerRegistry;
    }

    @Bean
    @Primary
    public RegistryEventConsumer<Timer> timerRegistryEventConsumer(Optional<List<RegistryEventConsumer<Timer>>> optionalRegistryEventConsumers) {
        return new CompositeRegistryEventConsumer(optionalRegistryEventConsumers.orElseGet(ArrayList::new));
    }

    @Bean
    @Conditional(value={AspectJOnClasspathCondition.class})
    public TimerAspect timerAspect(TimerConfigurationProperties timerConfigurationProperties, TimerRegistry timerRegistry, @Autowired(required=false) List<TimerAspectExt> timerAspectExtList, FallbackExecutor fallbackExecutor, SpelResolver spelResolver) {
        return new TimerAspect(timerRegistry, timerConfigurationProperties, timerAspectExtList, fallbackExecutor, spelResolver);
    }

    @Bean
    @Conditional(value={RxJava2OnClasspathCondition.class, AspectJOnClasspathCondition.class})
    public RxJava2TimerAspectExt rxJava2TimerAspectExt() {
        return new RxJava2TimerAspectExt();
    }

    @Bean
    @Conditional(value={ReactorOnClasspathCondition.class, AspectJOnClasspathCondition.class})
    public ReactorTimerAspectExt reactorTimerAspectExt() {
        return new ReactorTimerAspectExt();
    }

    @Bean
    public EventConsumerRegistry<TimerEvent> timerEventsConsumerRegistry() {
        return new DefaultEventConsumerRegistry();
    }

    private static TimerRegistry createTimerRegistry(TimerConfigurationProperties timerConfigurationProperties, RegistryEventConsumer<Timer> timerRegistryEventConsumer, CompositeCustomizer<TimerConfigCustomizer> compositeTimerCustomizer, MeterRegistry meterRegistry) {
        Map<String, TimerConfig> configs = timerConfigurationProperties.getConfigs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> timerConfigurationProperties.createTimerConfig((CommonTimerConfigurationProperties.InstanceProperties)entry.getValue(), compositeTimerCustomizer, (String)entry.getKey())));
        return TimerRegistry.of(configs, List.of(timerRegistryEventConsumer), Map.copyOf(timerConfigurationProperties.getTags()), (MeterRegistry)meterRegistry);
    }

    void initTimerRegistry(TimerRegistry timerRegistry, TimerConfigurationProperties timerConfigurationProperties, CompositeCustomizer<TimerConfigCustomizer> compositeTimerCustomizer) {
        timerConfigurationProperties.getInstances().forEach((name, properties) -> timerRegistry.timer(name, timerConfigurationProperties.createTimerConfig((CommonTimerConfigurationProperties.InstanceProperties)properties, (CompositeCustomizer)compositeTimerCustomizer, (String)name)));
    }

    private static void registerEventConsumer(TimerRegistry timerRegistry, EventConsumerRegistry<TimerEvent> eventConsumerRegistry, TimerConfigurationProperties properties) {
        timerRegistry.getEventPublisher().onEntryAdded(event -> TimerConfiguration.registerEventConsumer(eventConsumerRegistry, (Timer)event.getAddedEntry(), properties)).onEntryReplaced(event -> TimerConfiguration.registerEventConsumer(eventConsumerRegistry, (Timer)event.getNewEntry(), properties));
    }

    private static void registerEventConsumer(EventConsumerRegistry<TimerEvent> eventConsumerRegistry, Timer timer, TimerConfigurationProperties timerConfigurationProperties) {
        int eventConsumerBufferSize = Optional.ofNullable(timerConfigurationProperties.getInstanceProperties(timer.getName())).map(CommonTimerConfigurationProperties.InstanceProperties::getEventConsumerBufferSize).orElse(100);
        timer.getEventPublisher().onEvent((EventConsumer)eventConsumerRegistry.createEventConsumer(timer.getName(), eventConsumerBufferSize));
    }
}

