/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.configure;

import io.github.resilience4j.core.functions.CheckedSupplier;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.fallback.FallbackExecutor;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.ratelimiter.configure.RateLimiterAspectExt;
import io.github.resilience4j.ratelimiter.configure.RateLimiterConfigurationProperties;
import io.github.resilience4j.spelresolver.SpelResolver;
import io.github.resilience4j.utils.AnnotationExtractor;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;

@Aspect
public class RateLimiterAspect
implements Ordered {
    private static final String RATE_LIMITER_RECEIVED = "Created or retrieved rate limiter '{}' with period: '{}'; limit for period: '{}'; timeout: '{}'; method: '{}'";
    private static final Logger logger = LoggerFactory.getLogger(RateLimiterAspect.class);
    private final RateLimiterRegistry rateLimiterRegistry;
    private final RateLimiterConfigurationProperties properties;
    @Nullable
    private final List<RateLimiterAspectExt> rateLimiterAspectExtList;
    private final FallbackExecutor fallbackExecutor;
    private final SpelResolver spelResolver;

    public RateLimiterAspect(RateLimiterRegistry rateLimiterRegistry, RateLimiterConfigurationProperties properties, @Autowired(required=false) List<RateLimiterAspectExt> rateLimiterAspectExtList, FallbackExecutor fallbackExecutor, SpelResolver spelResolver) {
        this.rateLimiterRegistry = rateLimiterRegistry;
        this.properties = properties;
        this.rateLimiterAspectExtList = rateLimiterAspectExtList;
        this.fallbackExecutor = fallbackExecutor;
        this.spelResolver = spelResolver;
    }

    @Pointcut(value="@within(rateLimiter) || @annotation(rateLimiter)", argNames="rateLimiter")
    public void matchAnnotatedClassOrMethod(io.github.resilience4j.ratelimiter.annotation.RateLimiter rateLimiter) {
    }

    @Around(value="matchAnnotatedClassOrMethod(rateLimiterAnnotation)", argNames="proceedingJoinPoint, rateLimiterAnnotation")
    public Object rateLimiterAroundAdvice(ProceedingJoinPoint proceedingJoinPoint, @Nullable io.github.resilience4j.ratelimiter.annotation.RateLimiter rateLimiterAnnotation) throws Throwable {
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        String methodName = method.getDeclaringClass().getName() + "#" + method.getName();
        if (rateLimiterAnnotation == null) {
            rateLimiterAnnotation = this.getRateLimiterAnnotation(proceedingJoinPoint);
        }
        if (rateLimiterAnnotation == null) {
            return proceedingJoinPoint.proceed();
        }
        String name = this.spelResolver.resolve(method, proceedingJoinPoint.getArgs(), rateLimiterAnnotation.name());
        RateLimiter rateLimiter = this.getOrCreateRateLimiter(methodName, name);
        Class<?> returnType = method.getReturnType();
        CheckedSupplier rateLimiterExecution = () -> this.proceed(proceedingJoinPoint, methodName, returnType, rateLimiter);
        return this.fallbackExecutor.execute(proceedingJoinPoint, method, rateLimiterAnnotation.fallbackMethod(), (CheckedSupplier<Object>)rateLimiterExecution);
    }

    private Object proceed(ProceedingJoinPoint proceedingJoinPoint, String methodName, Class<?> returnType, RateLimiter rateLimiter) throws Throwable {
        if (this.rateLimiterAspectExtList != null && !this.rateLimiterAspectExtList.isEmpty()) {
            for (RateLimiterAspectExt rateLimiterAspectExt : this.rateLimiterAspectExtList) {
                if (!rateLimiterAspectExt.canHandleReturnType(returnType)) continue;
                return rateLimiterAspectExt.handle(proceedingJoinPoint, rateLimiter, methodName);
            }
        }
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            return this.handleJoinPointCompletableFuture(proceedingJoinPoint, rateLimiter);
        }
        return this.handleJoinPoint(proceedingJoinPoint, rateLimiter);
    }

    private RateLimiter getOrCreateRateLimiter(String methodName, String name) {
        RateLimiter rateLimiter = this.rateLimiterRegistry.rateLimiter(name);
        if (logger.isDebugEnabled()) {
            RateLimiterConfig rateLimiterConfig = rateLimiter.getRateLimiterConfig();
            logger.debug(RATE_LIMITER_RECEIVED, new Object[]{name, rateLimiterConfig.getLimitRefreshPeriod(), rateLimiterConfig.getLimitForPeriod(), rateLimiterConfig.getTimeoutDuration(), methodName});
        }
        return rateLimiter;
    }

    @Nullable
    private io.github.resilience4j.ratelimiter.annotation.RateLimiter getRateLimiterAnnotation(ProceedingJoinPoint proceedingJoinPoint) {
        if (proceedingJoinPoint.getTarget() instanceof Proxy) {
            logger.debug("The rate limiter annotation is kept on a interface which is acting as a proxy");
            return AnnotationExtractor.extractAnnotationFromProxy(proceedingJoinPoint.getTarget(), io.github.resilience4j.ratelimiter.annotation.RateLimiter.class);
        }
        return AnnotationExtractor.extract(proceedingJoinPoint.getTarget().getClass(), io.github.resilience4j.ratelimiter.annotation.RateLimiter.class);
    }

    private Object handleJoinPoint(ProceedingJoinPoint proceedingJoinPoint, RateLimiter rateLimiter) throws Throwable {
        return rateLimiter.executeCheckedSupplier(() -> ((ProceedingJoinPoint)proceedingJoinPoint).proceed());
    }

    private Object handleJoinPointCompletableFuture(ProceedingJoinPoint proceedingJoinPoint, RateLimiter rateLimiter) {
        return rateLimiter.executeCompletionStage(() -> {
            try {
                return (CompletionStage)proceedingJoinPoint.proceed();
            }
            catch (Throwable throwable) {
                throw new CompletionException(throwable);
            }
        });
    }

    public int getOrder() {
        return this.properties.getRateLimiterAspectOrder();
    }
}

