/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.configure;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.circuitbreaker.configure.CircuitBreakerAspect;
import io.github.resilience4j.circuitbreaker.configure.CircuitBreakerAspectExt;
import io.github.resilience4j.circuitbreaker.configure.CircuitBreakerConfigurationProperties;
import io.github.resilience4j.circuitbreaker.configure.ReactorCircuitBreakerAspectExt;
import io.github.resilience4j.circuitbreaker.configure.RxJava2CircuitBreakerAspectExt;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerEvent;
import io.github.resilience4j.common.CompositeCustomizer;
import io.github.resilience4j.common.circuitbreaker.configuration.CircuitBreakerConfigCustomizer;
import io.github.resilience4j.common.circuitbreaker.configuration.CommonCircuitBreakerConfigurationProperties;
import io.github.resilience4j.consumer.DefaultEventConsumerRegistry;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.registry.CompositeRegistryEventConsumer;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.fallback.FallbackExecutor;
import io.github.resilience4j.fallback.configure.FallbackConfiguration;
import io.github.resilience4j.spelresolver.SpelResolver;
import io.github.resilience4j.spelresolver.configure.SpelResolverConfiguration;
import io.github.resilience4j.utils.AspectJOnClasspathCondition;
import io.github.resilience4j.utils.ReactorOnClasspathCondition;
import io.github.resilience4j.utils.RxJava2OnClasspathCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@Configuration
@Import(value={FallbackConfiguration.class, SpelResolverConfiguration.class})
public class CircuitBreakerConfiguration {
    private final CircuitBreakerConfigurationProperties circuitBreakerProperties;

    public CircuitBreakerConfiguration(CircuitBreakerConfigurationProperties circuitBreakerProperties) {
        this.circuitBreakerProperties = circuitBreakerProperties;
    }

    @Bean
    @Qualifier(value="compositeCircuitBreakerCustomizer")
    public CompositeCustomizer<CircuitBreakerConfigCustomizer> compositeCircuitBreakerCustomizer(@Autowired(required=false) List<CircuitBreakerConfigCustomizer> customizers) {
        return new CompositeCustomizer(customizers);
    }

    @Bean
    public CircuitBreakerRegistry circuitBreakerRegistry(EventConsumerRegistry<CircuitBreakerEvent> eventConsumerRegistry, RegistryEventConsumer<CircuitBreaker> circuitBreakerRegistryEventConsumer, @Qualifier(value="compositeCircuitBreakerCustomizer") CompositeCustomizer<CircuitBreakerConfigCustomizer> compositeCircuitBreakerCustomizer) {
        CircuitBreakerRegistry circuitBreakerRegistry = this.createCircuitBreakerRegistry(this.circuitBreakerProperties, circuitBreakerRegistryEventConsumer, compositeCircuitBreakerCustomizer);
        this.registerEventConsumer(circuitBreakerRegistry, eventConsumerRegistry);
        this.initCircuitBreakerRegistry(circuitBreakerRegistry, compositeCircuitBreakerCustomizer);
        return circuitBreakerRegistry;
    }

    @Bean
    @Primary
    public RegistryEventConsumer<CircuitBreaker> circuitBreakerRegistryEventConsumer(Optional<List<RegistryEventConsumer<CircuitBreaker>>> optionalRegistryEventConsumers) {
        return new CompositeRegistryEventConsumer(optionalRegistryEventConsumers.orElseGet(ArrayList::new));
    }

    @Bean
    @Conditional(value={AspectJOnClasspathCondition.class})
    public CircuitBreakerAspect circuitBreakerAspect(CircuitBreakerRegistry circuitBreakerRegistry, @Autowired(required=false) List<CircuitBreakerAspectExt> circuitBreakerAspectExtList, FallbackExecutor fallbackExecutor, SpelResolver spelResolver) {
        return new CircuitBreakerAspect(this.circuitBreakerProperties, circuitBreakerRegistry, circuitBreakerAspectExtList, fallbackExecutor, spelResolver);
    }

    @Bean
    @Conditional(value={RxJava2OnClasspathCondition.class, AspectJOnClasspathCondition.class})
    public RxJava2CircuitBreakerAspectExt rxJava2CircuitBreakerAspect() {
        return new RxJava2CircuitBreakerAspectExt();
    }

    @Bean
    @Conditional(value={ReactorOnClasspathCondition.class, AspectJOnClasspathCondition.class})
    public ReactorCircuitBreakerAspectExt reactorCircuitBreakerAspect() {
        return new ReactorCircuitBreakerAspectExt();
    }

    @Bean
    public EventConsumerRegistry<CircuitBreakerEvent> eventConsumerRegistry() {
        return new DefaultEventConsumerRegistry();
    }

    CircuitBreakerRegistry createCircuitBreakerRegistry(CircuitBreakerConfigurationProperties circuitBreakerProperties, RegistryEventConsumer<CircuitBreaker> circuitBreakerRegistryEventConsumer, CompositeCustomizer<CircuitBreakerConfigCustomizer> compositeCircuitBreakerCustomizer) {
        Map<String, CircuitBreakerConfig> configs = circuitBreakerProperties.getConfigs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> circuitBreakerProperties.createCircuitBreakerConfig((String)entry.getKey(), (CommonCircuitBreakerConfigurationProperties.InstanceProperties)entry.getValue(), compositeCircuitBreakerCustomizer)));
        return CircuitBreakerRegistry.of(configs, circuitBreakerRegistryEventConsumer, Map.copyOf(circuitBreakerProperties.getTags()));
    }

    private void initCircuitBreakerRegistry(CircuitBreakerRegistry circuitBreakerRegistry, CompositeCustomizer<CircuitBreakerConfigCustomizer> compositeCircuitBreakerCustomizer) {
        this.circuitBreakerProperties.getInstances().forEach((name, properties) -> circuitBreakerRegistry.circuitBreaker(name, this.circuitBreakerProperties.createCircuitBreakerConfig((String)name, (CommonCircuitBreakerConfigurationProperties.InstanceProperties)properties, (CompositeCustomizer)compositeCircuitBreakerCustomizer)));
        compositeCircuitBreakerCustomizer.instanceNames().stream().filter(name -> circuitBreakerRegistry.getConfiguration(name).isEmpty()).forEach(name -> circuitBreakerRegistry.circuitBreaker(name, this.circuitBreakerProperties.createCircuitBreakerConfig((String)name, null, (CompositeCustomizer)compositeCircuitBreakerCustomizer)));
    }

    public void registerEventConsumer(CircuitBreakerRegistry circuitBreakerRegistry, EventConsumerRegistry<CircuitBreakerEvent> eventConsumerRegistry) {
        circuitBreakerRegistry.getEventPublisher().onEntryAdded(event -> this.registerEventConsumer(eventConsumerRegistry, (CircuitBreaker)event.getAddedEntry())).onEntryReplaced(event -> this.registerEventConsumer(eventConsumerRegistry, (CircuitBreaker)event.getNewEntry()));
    }

    private void registerEventConsumer(EventConsumerRegistry<CircuitBreakerEvent> eventConsumerRegistry, CircuitBreaker circuitBreaker) {
        int eventConsumerBufferSize = this.circuitBreakerProperties.findCircuitBreakerProperties(circuitBreaker.getName()).map(CommonCircuitBreakerConfigurationProperties.InstanceProperties::getEventConsumerBufferSize).orElse(100);
        circuitBreaker.getEventPublisher().onEvent((EventConsumer)eventConsumerRegistry.createEventConsumer(circuitBreaker.getName(), eventConsumerBufferSize));
    }
}

