/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.timelimiter.monitoring.endpoint;

import io.github.resilience4j.common.timelimiter.monitoring.endpoint.TimeLimiterEventDTO;
import io.github.resilience4j.common.timelimiter.monitoring.endpoint.TimeLimiterEventsEndpointResponse;
import io.github.resilience4j.consumer.CircularEventConsumer;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.timelimiter.event.TimeLimiterEvent;
import io.vavr.collection.List;
import java.util.Comparator;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="timelimiterevents")
public class TimeLimiterEventsEndpoint {
    private final EventConsumerRegistry<TimeLimiterEvent> eventsConsumerRegistry;

    public TimeLimiterEventsEndpoint(EventConsumerRegistry<TimeLimiterEvent> eventsConsumerRegistry) {
        this.eventsConsumerRegistry = eventsConsumerRegistry;
    }

    @ReadOperation
    public TimeLimiterEventsEndpointResponse getAllTimeLimiterEvents() {
        return new TimeLimiterEventsEndpointResponse(this.eventsConsumerRegistry.getAllEventConsumer().flatMap(CircularEventConsumer::getBufferedEvents).sorted(Comparator.comparing(TimeLimiterEvent::getCreationTime)).map(TimeLimiterEventDTO::createTimeLimiterEventDTO).toJavaList());
    }

    @ReadOperation
    public TimeLimiterEventsEndpointResponse getEventsFilteredByTimeLimiterName(@Selector String name) {
        return new TimeLimiterEventsEndpointResponse(this.getTimeLimiterEvents(name).map(TimeLimiterEventDTO::createTimeLimiterEventDTO).toJavaList());
    }

    @ReadOperation
    public TimeLimiterEventsEndpointResponse getEventsFilteredByTimeLimiterNameAndEventType(@Selector String name, @Selector String eventType) {
        TimeLimiterEvent.Type targetType = TimeLimiterEvent.Type.valueOf((String)eventType.toUpperCase());
        return new TimeLimiterEventsEndpointResponse(this.getTimeLimiterEvents(name).filter(event -> event.getEventType() == targetType).map(TimeLimiterEventDTO::createTimeLimiterEventDTO).toJavaList());
    }

    private List<TimeLimiterEvent> getTimeLimiterEvents(String name) {
        CircularEventConsumer eventConsumer = this.eventsConsumerRegistry.getEventConsumer(name);
        if (eventConsumer != null) {
            return eventConsumer.getBufferedEvents().filter(event -> event.getTimeLimiterName().equals(name));
        }
        return List.empty();
    }
}

