/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.retry;

import io.github.resilience4j.reactor.IllegalPublisherException;
import io.github.resilience4j.retry.Retry;
import java.time.Duration;
import java.util.function.UnaryOperator;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RetryOperator<T>
implements UnaryOperator<Publisher<T>> {
    private final Retry retry;

    private RetryOperator(Retry retry) {
        this.retry = retry;
    }

    public static <T> RetryOperator<T> of(Retry retry) {
        return new RetryOperator<T>(retry);
    }

    @Override
    public Publisher<T> apply(Publisher<T> publisher) {
        if (publisher instanceof Mono) {
            Context context = new Context(this.retry.asyncContext());
            Mono upstream = (Mono)publisher;
            return upstream.doOnNext(context::handleResult).retryWhen(reactor.util.retry.Retry.withThrowable(errors -> errors.flatMap(context::handleErrors))).doOnSuccess(t -> context.onComplete());
        }
        if (publisher instanceof Flux) {
            Context context = new Context(this.retry.asyncContext());
            Flux upstream = (Flux)publisher;
            return upstream.doOnNext(context::handleResult).retryWhen(reactor.util.retry.Retry.withThrowable(errors -> errors.flatMap(context::handleErrors))).doOnComplete(context::onComplete);
        }
        throw new IllegalPublisherException(publisher);
    }

    private static class Context<T> {
        private final Retry.AsyncContext<T> retryContext;

        Context(Retry.AsyncContext<T> retryContext) {
            this.retryContext = retryContext;
        }

        void onComplete() {
            this.retryContext.onComplete();
        }

        void handleResult(T result) {
            long waitDurationMillis = this.retryContext.onResult(result);
            if (waitDurationMillis != -1L) {
                throw new RetryDueToResultException(waitDurationMillis);
            }
        }

        Publisher<Long> handleErrors(Throwable throwable) {
            if (throwable instanceof RetryDueToResultException) {
                long waitDurationMillis = ((RetryDueToResultException)throwable).waitDurationMillis;
                return Mono.delay((Duration)Duration.ofMillis(waitDurationMillis));
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            long waitDurationMillis = this.retryContext.onError(throwable);
            if (waitDurationMillis == -1L) {
                return Mono.error((Throwable)throwable);
            }
            return Mono.delay((Duration)Duration.ofMillis(waitDurationMillis));
        }

        private static class RetryDueToResultException
        extends RuntimeException {
            private final long waitDurationMillis;

            RetryDueToResultException(long waitDurationMillis) {
                super("retry due to retryOnResult predicate");
                this.waitDurationMillis = waitDurationMillis;
            }
        }
    }
}

