/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer;

import io.github.resilience4j.core.lang.NonNull;
import io.github.resilience4j.core.lang.Nullable;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;

public class TimerConfig {
    private static final String DEFAULT_METRIC_NAMES = "resilience4j.timer.calls";
    private static final Function<Throwable, String> DEFAULT_ON_FAILURE_TAG_RESOLVER = throwable -> throwable.getClass().getSimpleName();
    @NonNull
    private final String metricNames;
    @NonNull
    private final Function<Throwable, String> onFailureTagResolver;

    private TimerConfig(@Nullable String metricNames, @Nullable Function<Throwable, String> onFailureTagResolver) {
        this.metricNames = Objects.requireNonNullElse(metricNames, DEFAULT_METRIC_NAMES);
        this.onFailureTagResolver = Objects.requireNonNullElse(onFailureTagResolver, DEFAULT_ON_FAILURE_TAG_RESOLVER);
    }

    public String getMetricNames() {
        return this.metricNames;
    }

    public Function<Throwable, String> getOnFailureTagResolver() {
        return this.onFailureTagResolver;
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder from(TimerConfig prototype) {
        return new Builder(prototype);
    }

    public static TimerConfig ofDefaults() {
        return new Builder().build();
    }

    public String toString() {
        return new StringJoiner(", ", TimerConfig.class.getSimpleName() + "[", "]").add("metricNames=" + this.metricNames).add("onFailureTagResolver=" + this.onFailureTagResolver).toString();
    }

    public static class Builder {
        @Nullable
        private String metricNames;
        @Nullable
        private Function<Throwable, String> onFailureTagResolver;

        private Builder() {
        }

        private Builder(@NonNull TimerConfig prototype) {
            Objects.requireNonNull(prototype, "Timer configuration prototype is null");
            this.metricNames = prototype.getMetricNames();
            this.onFailureTagResolver = prototype.getOnFailureTagResolver();
        }

        public Builder metricNames(@Nullable String metricNames) {
            this.metricNames = metricNames;
            return this;
        }

        public Builder onFailureTagResolver(@Nullable Function<Throwable, String> onFailureTagResolver) {
            this.onFailureTagResolver = onFailureTagResolver;
            return this;
        }

        public TimerConfig build() {
            return new TimerConfig(this.metricNames, this.onFailureTagResolver);
        }
    }
}

