package io.fabric8.kubernetes.client.extended.leaderelection;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.time.Duration;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.Lock;

public interface LeaderElectionConfigFluent<A extends LeaderElectionConfigFluent<A>> extends Fluent<A> {


    public Lock getLock();
    public A withLock(Lock lock);
    public Boolean hasLock();
    public Duration getLeaseDuration();
    public A withLeaseDuration(Duration leaseDuration);
    public Boolean hasLeaseDuration();
    public Duration getRenewDeadline();
    public A withRenewDeadline(Duration renewDeadline);
    public Boolean hasRenewDeadline();
    public Duration getRetryPeriod();
    public A withRetryPeriod(Duration retryPeriod);
    public Boolean hasRetryPeriod();
    public LeaderCallbacks getLeaderCallbacks();
    public A withLeaderCallbacks(LeaderCallbacks leaderCallbacks);
    public Boolean hasLeaderCallbacks();
    public boolean isReleaseOnCancel();
    public A withReleaseOnCancel(boolean releaseOnCancel);
    public Boolean hasReleaseOnCancel();
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(StringBuilder arg1);
    public A withNewName(int[] arg1,int arg2,int arg3);
    public A withNewName(char[] arg1);
    public A withNewName(StringBuffer arg1);
    public A withNewName(byte[] arg1,int arg2);
    public A withNewName(byte[] arg1);
    public A withNewName(char[] arg1,int arg2,int arg3);
    public A withNewName(byte[] arg1,int arg2,int arg3);
    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewName(String arg1);
}
