/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class DeepCopy {
    /*
     * Enabled aggressive exception aggregation
     */
    public static <T> T copy(T orig) {
        if (orig == null) {
            return null;
        }
        try {
            ByteArrayOutputStream fbos = new ByteArrayOutputStream();
            try (ObjectOutputStream out = new ObjectOutputStream(fbos);){
                out.writeObject(orig);
                out.flush();
            }
            try (ByteArrayInputStream fbis = new ByteArrayInputStream(fbos.toByteArray());){
                Object object;
                try (ObjectInputStream in = new ObjectInputStream(fbis);){
                    object = in.readObject();
                }
                return (T)object;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException("Cannot copy " + orig, e);
        }
    }
}

