/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config;

import io.fabric8.maven.docker.util.DeepCopy;
import java.io.Serializable;
import java.util.Map;
import org.apache.maven.plugins.annotations.Parameter;

public class VolumeConfiguration
implements Serializable {
    @Parameter
    private String name;
    @Parameter
    private String driver;
    @Parameter
    private Map<String, String> opts;
    @Parameter
    private Map<String, String> labels;

    public String getName() {
        return this.name;
    }

    public String getDriver() {
        return this.driver;
    }

    public Map<String, String> getOpts() {
        return this.opts;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public static class Builder {
        private final VolumeConfiguration config;

        public Builder() {
            this(null);
        }

        public Builder(VolumeConfiguration that) {
            this.config = that == null ? new VolumeConfiguration() : DeepCopy.copy(that);
        }

        public Builder name(String name) {
            this.config.name = name;
            return this;
        }

        public Builder driver(String driver) {
            this.config.driver = driver;
            return this;
        }

        public Builder opts(Map<String, String> opts) {
            this.config.opts = opts;
            return this;
        }

        public Builder labels(Map<String, String> labels) {
            this.config.labels = labels;
            return this;
        }

        public VolumeConfiguration build() {
            return this.config;
        }
    }
}

