/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access.hc;

import io.fabric8.maven.docker.access.hc.http.HttpRequestException;
import io.fabric8.maven.docker.access.hc.util.ClientBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class ApacheHttpClientDelegate {
    private final ClientBuilder clientBuilder;
    private final CloseableHttpClient httpClient;

    public ApacheHttpClientDelegate(ClientBuilder clientBuilder, boolean pooled) throws IOException {
        this.clientBuilder = clientBuilder;
        this.httpClient = pooled ? clientBuilder.buildPooledClient() : clientBuilder.buildBasicClient();
    }

    public CloseableHttpClient createBasicClient() {
        try {
            return this.clientBuilder.buildBasicClient();
        }
        catch (IOException exp) {
            throw new IllegalStateException("Cannot create single HTTP client: " + exp, exp);
        }
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void close() throws IOException {
        this.httpClient.close();
    }

    public int delete(String url, int ... statusCodes) throws IOException {
        return this.delete(url, new StatusCodeResponseHandler(), statusCodes);
    }

    public <T> T delete(String url, ResponseHandler<T> responseHandler, int ... statusCodes) throws IOException {
        return (T)this.httpClient.execute(this.newDelete(url), new StatusCodeCheckerResponseHandler<T>(responseHandler, statusCodes));
    }

    public String get(String url, int ... statusCodes) throws IOException {
        return (String)this.httpClient.execute(this.newGet(url), new StatusCodeCheckerResponseHandler<String>(new BodyResponseHandler(), statusCodes));
    }

    public <T> T get(String url, ResponseHandler<T> responseHandler, int ... statusCodes) throws IOException {
        return (T)this.httpClient.execute(this.newGet(url), new StatusCodeCheckerResponseHandler<T>(responseHandler, statusCodes));
    }

    private static String getResponseMessage(HttpResponse response) throws IOException {
        return response.getEntity() == null ? null : EntityUtils.toString((HttpEntity)response.getEntity()).trim();
    }

    public <T> T post(String url, Object body, Map<String, String> headers, ResponseHandler<T> responseHandler, int ... statusCodes) throws IOException {
        HttpUriRequest request = this.newPost(url, body);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            request.addHeader(entry.getKey(), entry.getValue());
        }
        return (T)this.httpClient.execute(request, new StatusCodeCheckerResponseHandler<T>(responseHandler, statusCodes));
    }

    public <T> T post(String url, Object body, ResponseHandler<T> responseHandler, int ... statusCodes) throws IOException {
        return (T)this.httpClient.execute(this.newPost(url, body), new StatusCodeCheckerResponseHandler<T>(responseHandler, statusCodes));
    }

    public int post(String url, int ... statusCodes) throws IOException {
        return this.post(url, null, new StatusCodeResponseHandler(), statusCodes);
    }

    public int put(String url, Object body, int ... statusCodes) throws IOException {
        return (Integer)this.httpClient.execute(this.newPut(url, body), new StatusCodeCheckerResponseHandler<Integer>(new StatusCodeResponseHandler(), statusCodes));
    }

    private HttpUriRequest addDefaultHeaders(HttpUriRequest req, Object body) {
        req.addHeader("Accept", "*/*");
        if (body instanceof File) {
            req.addHeader("Content-Type", URLConnection.guessContentTypeFromName(((File)body).getName()));
        }
        if (body != null && !req.containsHeader("Content-Type")) {
            req.addHeader("Content-Type", "application/json");
        }
        return req;
    }

    private HttpUriRequest newDelete(String url) {
        return this.addDefaultHeaders((HttpUriRequest)new HttpDelete(url), null);
    }

    private HttpUriRequest newGet(String url) {
        return this.addDefaultHeaders((HttpUriRequest)new HttpGet(url), null);
    }

    private HttpUriRequest newPut(String url, Object body) {
        HttpPut put = new HttpPut(url);
        this.setEntityIfGiven((HttpEntityEnclosingRequestBase)put, body);
        return this.addDefaultHeaders((HttpUriRequest)put, body);
    }

    private HttpUriRequest newPost(String url, Object body) {
        HttpPost post = new HttpPost(url);
        this.setEntityIfGiven((HttpEntityEnclosingRequestBase)post, body);
        return this.addDefaultHeaders((HttpUriRequest)post, body);
    }

    private void setEntityIfGiven(HttpEntityEnclosingRequestBase request, Object entity) {
        if (entity != null) {
            if (entity instanceof File) {
                request.setEntity((HttpEntity)new FileEntity((File)entity));
            } else {
                request.setEntity((HttpEntity)new StringEntity((String)entity, Charset.defaultCharset()));
            }
        }
    }

    public static class HttpBodyAndStatus {
        private final int statusCode;
        private final String body;

        public HttpBodyAndStatus(int statusCode, String body) {
            this.statusCode = statusCode;
            this.body = body;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getBody() {
            return this.body;
        }
    }

    public static class BodyAndStatusResponseHandler
    implements ResponseHandler<HttpBodyAndStatus> {
        public HttpBodyAndStatus handleResponse(HttpResponse response) throws IOException {
            return new HttpBodyAndStatus(response.getStatusLine().getStatusCode(), ApacheHttpClientDelegate.getResponseMessage(response));
        }
    }

    static class StatusCodeCheckerResponseHandler<T>
    implements ResponseHandler<T> {
        int[] statusCodes;
        ResponseHandler<T> delegate;

        StatusCodeCheckerResponseHandler(ResponseHandler<T> delegate, int ... statusCodes) {
            this.statusCodes = statusCodes;
            this.delegate = delegate;
        }

        public T handleResponse(HttpResponse response) throws IOException {
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            for (int code : this.statusCodes) {
                if (statusCode != code) continue;
                return (T)this.delegate.handleResponse(response);
            }
            String reason = statusLine.getReasonPhrase().trim();
            throw new HttpRequestException(String.format("%s (%s: %d)", ApacheHttpClientDelegate.getResponseMessage(response), reason, statusCode));
        }
    }

    public static class BodyResponseHandler
    implements ResponseHandler<String> {
        public String handleResponse(HttpResponse response) throws IOException {
            return ApacheHttpClientDelegate.getResponseMessage(response);
        }
    }

    public static class StatusCodeResponseHandler
    implements ResponseHandler<Integer> {
        public Integer handleResponse(HttpResponse response) {
            return response.getStatusLine().getStatusCode();
        }
    }
}

