/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.vis;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;

public class VisHttpd
implements Runnable {
    Server server;
    private int port;
    private String listenAddr;

    public static void main(String[] args) {
        VisHttpd server = new VisHttpd(8081, "localhost");
        Thread thread = new Thread(server);
        thread.setDaemon(false);
        thread.start();
    }

    public VisHttpd(int port, String listenAddr) {
        this.port = port;
        this.listenAddr = listenAddr;
    }

    @Override
    public void run() {
        try {
            this.server = this.configure();
            this.server.start();
            this.server.join();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private Server configure() {
        Server server = null;
        try {
            InetAddress byName = InetAddress.getByName(this.listenAddr);
            InetSocketAddress addr = new InetSocketAddress(byName, this.port);
            server = new Server(this.port);
            ResourceHandler resourceHandler = this.getResourceHandler();
            server.setHandler((Handler)resourceHandler);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return server;
    }

    private ResourceHandler getResourceHandler() {
        try {
            ResourceHandler resourceHandler = new ResourceHandler();
            Resource viscp = ResourceCollection.newClassPathResource((String)"viscontent", (boolean)true, (boolean)true);
            ResourceCollection allresources = new ResourceCollection(new Resource[]{viscp});
            resourceHandler.setWelcomeFiles(new String[]{"index.html", "index.html"});
            resourceHandler.setDirAllowed(true);
            resourceHandler.setResourceBase("/");
            resourceHandler.setBaseResource((Resource)allresources);
            return resourceHandler;
        }
        catch (Exception e) {
            this.handleException(e);
            throw new RuntimeException(e);
        }
    }

    private void handleException(Exception e) {
        throw new RuntimeException(e);
    }
}

