/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.openshift.tools.databases.sqlserver;

import io.debezium.testing.openshift.tools.databases.SqlDatabaseController;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.CopyOrReadable;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.Execable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorChannelable;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import io.fabric8.openshift.client.OpenShiftClient;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerController
extends SqlDatabaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlServerController.class);
    private static final String DB_INIT_SCRIPT_PATH = "/database-resources/sqlserver/inventory.sql";
    private static final String DB_INIT_SCRIPT_PATH_CONTAINER = "/opt/inventory.sql";
    private final Path initScript;

    public SqlServerController(Deployment deployment, List<Service> services, String dbType, OpenShiftClient ocp) {
        super(deployment, services, dbType, ocp);
        try {
            this.initScript = Paths.get(this.getClass().getResource(DB_INIT_SCRIPT_PATH).toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String constructDatabaseUrl(String hostname, int port) {
        return "jdbc:" + this.dbType + "://" + hostname + ":" + port;
    }

    @Override
    public void initialize() {
        Pod pod = (Pod)((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.ocp.pods().inNamespace(this.project)).withLabel("deployment", this.name)).list()).getItems().get(0);
        ((CopyOrReadable)((PodResource)((NonNamespaceOperation)this.ocp.pods().inNamespace(this.project)).withName(pod.getMetadata().getName())).file(DB_INIT_SCRIPT_PATH_CONTAINER)).upload(this.initScript);
        ExecWatch exec = (ExecWatch)((Execable)((TtyExecErrorChannelable)((TtyExecErrorable)((ContainerResource)((PodResource)((NonNamespaceOperation)this.ocp.pods().inNamespace(this.project)).withName(pod.getMetadata().getName())).inContainer((Object)"sqlserver")).writingOutput((Object)System.out)).writingError((Object)System.err)).usingListener((Object)new SqlServerInitListener())).exec((Object[])new String[]{"/opt/mssql-tools/bin/sqlcmd", "-U", "sa", "-P", "Debezium1$", "-i", DB_INIT_SCRIPT_PATH_CONTAINER});
        Throwable throwable = null;
        if (exec != null) {
            if (throwable != null) {
                try {
                    exec.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                exec.close();
            }
        }
    }

    private static class SqlServerInitListener
    implements ExecListener {
        private SqlServerInitListener() {
        }

        public void onOpen(Response response) {
            LOGGER.info("Initializing Sqlserver database");
        }

        public void onFailure(Throwable t, Response response) {
            LOGGER.error("Error initializing Sqlserver database");
            LOGGER.error(response.message());
        }

        public void onClose(int code, String reason) {
            LOGGER.info("Sqlserver init executor close: [" + code + "] " + reason);
        }
    }
}

