/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.cloudevents.Attributes;
import io.cloudevents.fun.DataMarshaller;
import io.cloudevents.fun.DataUnmarshaller;
import io.cloudevents.json.ZonedDateTimeDeserializer;
import io.cloudevents.json.ZonedDateTimeSerializer;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Map;

public final class Json {
    public static final ObjectMapper MAPPER = new ObjectMapper();

    public static String encode(Object obj) throws IllegalStateException {
        try {
            return MAPPER.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to encode as JSON: " + e.getMessage());
        }
    }

    public static byte[] binaryEncode(Object obj) throws IllegalStateException {
        try {
            return MAPPER.writeValueAsBytes(obj);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to encode as JSON: " + e.getMessage());
        }
    }

    public static <T> T fromInputStream(InputStream inputStream, Class<T> clazz) {
        try {
            return (T)MAPPER.readValue(inputStream, clazz);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to encode as JSON: " + e.getMessage());
        }
    }

    public static <T> T fromInputStream(InputStream inputStream, TypeReference<T> type) {
        try {
            return (T)MAPPER.readValue(inputStream, type);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to encode as JSON: " + e.getMessage());
        }
    }

    protected static <T> T decodeValue(String str, Class<T> clazz) throws IllegalStateException {
        if (null != str && !"".equals(str.trim())) {
            try {
                return (T)MAPPER.readValue(str.trim(), clazz);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to decode: " + e.getMessage());
            }
        }
        return null;
    }

    protected static <T> T binaryDecodeValue(byte[] payload, Class<T> clazz) {
        if (null != payload) {
            try {
                return (T)MAPPER.readValue(payload, clazz);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to decode: " + e.getMessage());
            }
        }
        return null;
    }

    public static <T> T decodeValue(String str, TypeReference<T> type) throws IllegalStateException {
        if (null != str && !"".equals(str.trim())) {
            try {
                return (T)MAPPER.readValue(str.trim(), type);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to decode: " + e.getMessage(), e);
            }
        }
        return null;
    }

    public static <T> T decodeValue(String str, Class<?> parametrized, Class<?> ... parameterClasses) {
        if (null != str && !"".equals(str.trim())) {
            try {
                JavaType type = MAPPER.getTypeFactory().constructParametricType(parametrized, (Class[])parameterClasses);
                return (T)MAPPER.readValue(str.trim(), type);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to decode: " + e.getMessage(), e);
            }
        }
        return null;
    }

    public static <T> T binaryDecodeValue(byte[] json, Class<?> parametrized, Class<?> ... parameterClasses) {
        if (null != json) {
            try {
                JavaType type = MAPPER.getTypeFactory().constructParametricType(parametrized, (Class[])parameterClasses);
                return (T)MAPPER.readValue(json, type);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to decode: " + e.getMessage(), e);
            }
        }
        return null;
    }

    public static <T, A extends Attributes> DataUnmarshaller<String, T, A> umarshaller(Class<T> type) {
        return (payload, attributes) -> Json.decodeValue(payload, type);
    }

    public static <T, A extends Attributes> DataUnmarshaller<byte[], T, A> binaryUmarshaller(Class<T> type) {
        return (payload, attributes) -> Json.binaryDecodeValue(payload, type);
    }

    public static <T, H> DataMarshaller<String, T, H> marshaller() {
        return (data, headers) -> Json.encode(data);
    }

    public static <T, H> byte[] binaryMarshal(T data, Map<String, H> headers) {
        return Json.binaryEncode(data);
    }

    private Json() {
    }

    static {
        MAPPER.registerModule((Module)new Jdk8Module());
        SimpleModule module = new SimpleModule();
        module.addSerializer(ZonedDateTime.class, (JsonSerializer)new ZonedDateTimeSerializer());
        module.addDeserializer(ZonedDateTime.class, (JsonDeserializer)new ZonedDateTimeDeserializer());
        MAPPER.registerModule((Module)module);
    }
}

