/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.ksef.client.iterator;

import io.alapierre.ksef.client.ApiException;
import io.alapierre.ksef.client.iterator.PageSupplier;
import io.alapierre.ksef.client.iterator.PageableResult;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class KsefResultIterator<T> {
    private final Predicate<T> filter;

    public KsefResultIterator(Predicate<T> filter) {
        this.filter = filter;
    }

    public KsefResultIterator() {
        this.filter = t -> true;
    }

    public List<T> iterate(PageSupplier<PageableResult<T>> supplier) throws ApiException {
        PageableResult<T> result;
        int numberOfRows;
        int numberOfPages;
        int page = 0;
        LinkedList values = new LinkedList();
        do {
            result = supplier.get(page);
            numberOfRows = result.getNumberOfElements();
            values.addAll(result.getItems().stream().filter(this.filter).collect(Collectors.toList()));
        } while (++page < (numberOfPages = (int)Math.ceil((double)numberOfRows / (double)result.getPageSize())));
        return values;
    }
}

