/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.io;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class FileUtil {
    public static String toFileSystemSafeName(String inputName) {
        return inputName.replaceAll("[^a-zA-Z0-9-_\\.]", "_");
    }

    public static void runDefaultApp(File file) throws Exception {
        Desktop desktop = null;
        if (Desktop.isDesktopSupported()) {
            desktop = Desktop.getDesktop();
            desktop.open(file);
        } else {
            System.out.println("Desktop not supported");
        }
    }

    public static void silentDelete(Path path) {
        try {
            Files.delete(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getFileExtension(String fileName) {
        if (!fileName.contains(".") || fileName.endsWith(".")) {
            return null;
        }
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    public static String getBaseFileName(String fileName) {
        if (!fileName.contains(".") || fileName.endsWith(".")) {
            return null;
        }
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public static File addPostfix(File file, String postfix) {
        String originalFileName = file.getName();
        String res = (String)(file.getParent() != null ? file.getParent() + "/" : "") + FileUtil.getBaseFileName(originalFileName) + postfix + FileUtil.getFileExtension(originalFileName);
        return new File(res);
    }

    public static Collection<File> procesFileOrPath(Path inputPath, String fileExtension) throws IOException {
        if (Files.exists(inputPath, new LinkOption[0])) {
            if (Files.isRegularFile(inputPath, new LinkOption[0])) {
                return Collections.singletonList(inputPath.toFile());
            }
            try (DirectoryStream<Path> re = Files.newDirectoryStream(inputPath, path -> path.toString().endsWith(fileExtension));){
                ArrayList<File> ret = new ArrayList<File>();
                re.forEach(path -> ret.add(path.toFile()));
                ArrayList<File> arrayList = ret;
                return arrayList;
            }
        }
        throw new IOException("File or path not exist");
    }
}

