/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.commons.date;

import java.sql.Time;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import org.jetbrains.annotations.NotNull;

public final class TimeUtils {
    private TimeUtils() {
    }

    public static LocalTime asLocalTime(@NotNull Time time) {
        if (time == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/TimeUtils.asLocalTime must not be null");
        }
        return time.toLocalTime();
    }

    public static Time asTime(@NotNull LocalTime localTime) {
        if (localTime == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/TimeUtils.asTime must not be null");
        }
        return Time.valueOf(localTime);
    }

    public static boolean isInRange(@NotNull LocalTime time, @NotNull LocalTime from, @NotNull LocalTime to) {
        if (time == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/TimeUtils.isInRange must not be null");
        }
        if (from == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/TimeUtils.isInRange must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/commons/date/TimeUtils.isInRange must not be null");
        }
        return !time.isBefore(from) && !time.isAfter(to);
    }

    public static boolean isInRange(@NotNull Time time, @NotNull Time from, @NotNull Time to) {
        if (time == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/TimeUtils.isInRange must not be null");
        }
        if (from == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/TimeUtils.isInRange must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/commons/date/TimeUtils.isInRange must not be null");
        }
        return TimeUtils.isInRange(TimeUtils.asLocalTime(time), TimeUtils.asLocalTime(from), TimeUtils.asLocalTime(to));
    }

    public static boolean overlap(@NotNull LocalTime start1, @NotNull LocalTime end1, @NotNull LocalTime start2, @NotNull LocalTime end2) {
        if (start1 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/TimeUtils.overlap must not be null");
        }
        if (end1 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/TimeUtils.overlap must not be null");
        }
        if (start2 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/commons/date/TimeUtils.overlap must not be null");
        }
        if (end2 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 3 of io/alapierre/commons/date/TimeUtils.overlap must not be null");
        }
        return !start1.isAfter(end2) && !end1.isBefore(start2);
    }

    public static boolean overlap(@NotNull Time start1, @NotNull Time end1, @NotNull Time start2, @NotNull Time end2) {
        if (start1 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/TimeUtils.overlap must not be null");
        }
        if (end1 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/TimeUtils.overlap must not be null");
        }
        if (start2 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/commons/date/TimeUtils.overlap must not be null");
        }
        if (end2 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 3 of io/alapierre/commons/date/TimeUtils.overlap must not be null");
        }
        return TimeUtils.overlap(TimeUtils.asLocalTime(start1), TimeUtils.asLocalTime(end1), TimeUtils.asLocalTime(start2), TimeUtils.asLocalTime(end2));
    }

    public static boolean overlapElusive(@NotNull LocalTime start1, @NotNull LocalTime end1, @NotNull LocalTime start2, @NotNull LocalTime end2) {
        if (start1 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/TimeUtils.overlapElusive must not be null");
        }
        if (end1 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/TimeUtils.overlapElusive must not be null");
        }
        if (start2 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/commons/date/TimeUtils.overlapElusive must not be null");
        }
        if (end2 == null) {
            throw new IllegalArgumentException("NotNull annotated argument 3 of io/alapierre/commons/date/TimeUtils.overlapElusive must not be null");
        }
        return start1.isBefore(end2) && end1.isAfter(start2);
    }

    public static String formatDuration(@NotNull Duration d) {
        if (d == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/TimeUtils.formatDuration must not be null");
        }
        long hours = d.toHours();
        long minutes = d.minusHours(hours).toMinutes();
        return String.format("%02d:%02d", hours, minutes);
    }

    public static double hoursBetweenTimes(@NotNull LocalTime hourFrom, @NotNull LocalTime hourTo) {
        if (hourFrom == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/TimeUtils.hoursBetweenTimes must not be null");
        }
        if (hourTo == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/TimeUtils.hoursBetweenTimes must not be null");
        }
        return (double)ChronoUnit.MINUTES.between(hourFrom, hourTo) / 60.0;
    }

    public static double hoursBetweenTimes(@NotNull LocalDateTime hourFrom, @NotNull LocalDateTime hourTo) {
        if (hourFrom == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/TimeUtils.hoursBetweenTimes must not be null");
        }
        if (hourTo == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/TimeUtils.hoursBetweenTimes must not be null");
        }
        return (double)ChronoUnit.MINUTES.between(hourFrom, hourTo) / 60.0;
    }

    public static double hoursBetweenTimes(@NotNull LocalTime hourFrom, @NotNull LocalTime hourTo, @NotNull LocalDate day) {
        if (hourFrom == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/TimeUtils.hoursBetweenTimes must not be null");
        }
        if (hourTo == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/TimeUtils.hoursBetweenTimes must not be null");
        }
        if (day == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 of io/alapierre/commons/date/TimeUtils.hoursBetweenTimes must not be null");
        }
        if (hourFrom.isBefore(hourTo)) {
            return (double)ChronoUnit.MINUTES.between(hourFrom, hourTo) / 60.0;
        }
        LocalDateTime from = LocalDateTime.of(day, hourFrom);
        LocalDateTime to = LocalDateTime.of(day.plusDays(1L), hourTo);
        return (double)ChronoUnit.MINUTES.between(from, to) / 60.0;
    }

    public static double hourToNumber(@NotNull String hourString) {
        if (hourString == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/TimeUtils.hourToNumber must not be null");
        }
        if (hourString.isEmpty()) {
            return 0.0;
        }
        String[] split = hourString.split(":");
        double hour = Double.parseDouble(split[0]);
        double minutes = Double.parseDouble(split[1]) / 60.0;
        return hour + minutes;
    }
}

