/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.commons.date;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.jetbrains.annotations.NotNull;

public final class Period
implements Serializable {
    private static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd";
    private final LocalDate start;
    private final LocalDate end;

    public static Period of(@NotNull LocalDate start, @NotNull LocalDate end) {
        if (start == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/Period.of must not be null");
        }
        if (end == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/Period.of must not be null");
        }
        return new Period(start, end);
    }

    public static Period fromString(@NotNull String start, @NotNull String end) {
        if (start == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/Period.fromString must not be null");
        }
        if (end == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/Period.fromString must not be null");
        }
        return Period.fromString(start, end, DateTimeFormatter.ofPattern(DATE_FORMAT_PATTERN));
    }

    public static Period fromString(@NotNull String start, @NotNull String end, DateTimeFormatter formatter) {
        if (start == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of io/alapierre/commons/date/Period.fromString must not be null");
        }
        if (end == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of io/alapierre/commons/date/Period.fromString must not be null");
        }
        return new Period(LocalDate.parse(start, formatter), LocalDate.parse(end, formatter));
    }

    public Period(LocalDate start, LocalDate end) {
        this.start = start;
        this.end = end;
    }

    public LocalDate getStart() {
        return this.start;
    }

    public LocalDate getEnd() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Period)) {
            return false;
        }
        Period other = (Period)o;
        LocalDate this$start = this.getStart();
        LocalDate other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        LocalDate this$end = this.getEnd();
        LocalDate other$end = other.getEnd();
        return !(this$end == null ? other$end != null : !((Object)this$end).equals(other$end));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDate $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        LocalDate $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        return result;
    }

    public String toString() {
        return "Period(start=" + this.getStart() + ", end=" + this.getEnd() + ")";
    }
}

