/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.testing;

import com.google.common.annotations.Beta;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.bval.jsr303.ApacheValidationProvider;
import org.apache.bval.jsr303.ApacheValidatorConfiguration;
import org.testng.Assert;

@Beta
public class ValidationAssertions {
    private static final Validator VALIDATOR = ((ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure()).buildValidatorFactory().getValidator();

    public static void assertValidates(Object object) {
        ValidationAssertions.assertValidates(object, null);
    }

    public static void assertValidates(Object object, String message) {
        Assert.assertTrue((boolean)VALIDATOR.validate(object, new Class[0]).isEmpty(), (String)String.format("%sexpected:<%s> to pass validation", ValidationAssertions.toMessageString(message), object));
    }

    public static <T> void assertFailsValidation(T object, String field, String expectedErrorMessage, Class<? extends Annotation> annotation, String message) {
        Set violations = VALIDATOR.validate(object, new Class[0]);
        for (ConstraintViolation violation : violations) {
            if (!annotation.isInstance(violation.getConstraintDescriptor().getAnnotation()) || !violation.getPropertyPath().toString().equals(field)) continue;
            if (!violation.getMessage().equals(expectedErrorMessage)) {
                Assert.fail((String)String.format("%sexpected %s.%s for <%s> to fail validation for %s with message '%s', but message was '%s'", ValidationAssertions.toMessageString(message), object.getClass().getName(), field, message, annotation.getName(), expectedErrorMessage, violation.getMessage()));
            }
            return;
        }
        Assert.fail((String)String.format("%sexpected %s.%s for <%s> to fail validation for %s with message '%s'", ValidationAssertions.toMessageString(message), object.getClass().getName(), field, object, annotation.getName(), expectedErrorMessage));
    }

    public static <T> void assertFailsValidation(T object, String field, String expectedErrorMessage, Class<? extends Annotation> annotation) {
        ValidationAssertions.assertFailsValidation(object, field, expectedErrorMessage, annotation, null);
    }

    private static String toMessageString(String message) {
        return message == null ? "" : message + " ";
    }
}

