/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.video;

import com.google.devtools.build.android.desugar.runtime.ThrowableExtension;
import io.agora.base.internal.CalledByNative;
import java.util.HashMap;

class VideoCaptureFormat {
    final int mWidth;
    final int mHeight;
    final int mFramerate;
    final int mPixelFormat;
    static final String keyWidth = "width";
    static final String keyHeight = "height";
    static final String keyFPS = "fps";
    static final String keyFormat = "format";

    @CalledByNative
    public VideoCaptureFormat(int width, int height, int framerate, int pixelformat) {
        this.mWidth = width;
        this.mHeight = height;
        this.mFramerate = framerate;
        this.mPixelFormat = pixelformat;
    }

    @CalledByNative
    public int getWidth() {
        return this.mWidth;
    }

    @CalledByNative
    public int getHeight() {
        return this.mHeight;
    }

    @CalledByNative
    public int getFramerate() {
        return this.mFramerate;
    }

    @CalledByNative
    public int getPixelFormat() {
        return this.mPixelFormat;
    }

    public String toString() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put(keyWidth, this.mWidth);
        map.put(keyHeight, this.mHeight);
        map.put(keyFPS, this.mFramerate);
        map.put(keyFormat, this.mPixelFormat);
        return ((Object)map).toString();
    }

    public static VideoCaptureFormat fromString(String str) {
        if (null == str || !str.startsWith("{")) {
            return null;
        }
        String value = str.substring(1, str.length() - 1);
        String[] keyValuePairs = value.split(",");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        VideoCaptureFormat captureFormat = null;
        try {
            for (String pair : keyValuePairs) {
                String[] entry = pair.split("=");
                map.put(entry[0].trim(), Integer.parseInt(entry[1].trim()));
            }
            int width = (Integer)map.get(keyWidth);
            int height = (Integer)map.get(keyHeight);
            int fps = (Integer)map.get(keyFPS);
            int format = (Integer)map.get(keyFormat);
            captureFormat = new VideoCaptureFormat(width, height, fps, format);
        }
        catch (Exception e) {
            ThrowableExtension.printStackTrace((Throwable)e);
        }
        return captureFormat;
    }
}

