/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.video;

import io.agora.base.internal.CalledByNative;

public class CameraCapturerConfiguration {
    public CAMERA_DIRECTION cameraDirection;
    public CaptureFormat captureFormat;
    public boolean followEncodeDimensionRatio;

    public CameraCapturerConfiguration(CAMERA_DIRECTION cameraDirection) {
        this.cameraDirection = cameraDirection;
        this.captureFormat = new CaptureFormat();
        this.followEncodeDimensionRatio = true;
    }

    public CameraCapturerConfiguration(CaptureFormat captureFormat) {
        this.captureFormat = captureFormat;
        this.cameraDirection = CAMERA_DIRECTION.CAMERA_FRONT;
        this.followEncodeDimensionRatio = true;
    }

    public CameraCapturerConfiguration(CAMERA_DIRECTION cameraDirection, CaptureFormat captureFormat) {
        this.cameraDirection = cameraDirection;
        this.captureFormat = captureFormat;
        this.followEncodeDimensionRatio = true;
    }

    @CalledByNative
    public int getCameraDirection() {
        return this.cameraDirection.value;
    }

    @CalledByNative
    public CaptureFormat getCaptureFormat() {
        return this.captureFormat;
    }

    @CalledByNative
    public boolean isFollowEncodeDimensionRatio() {
        return this.followEncodeDimensionRatio;
    }

    public String toString() {
        return "CameraCapturerConfiguration{cameraDirection=" + (Object)((Object)this.cameraDirection) + ", captureDimensions=" + this.captureFormat + ", followEncodeDimensionRatio=" + this.followEncodeDimensionRatio + '}';
    }

    public static class CaptureFormat {
        public int width;
        public int height;
        public int fps;

        public CaptureFormat(int width, int height, int fps) {
            this.width = width;
            this.height = height;
            this.fps = fps;
        }

        public CaptureFormat() {
            this.width = 640;
            this.height = 480;
            this.fps = 15;
        }

        @CalledByNative(value="CaptureFormat")
        public int getHeight() {
            return this.height;
        }

        @CalledByNative(value="CaptureFormat")
        public int getWidth() {
            return this.width;
        }

        @CalledByNative(value="CaptureFormat")
        public int getFps() {
            return this.fps;
        }

        public String toString() {
            return "CaptureFormat{width=" + this.width + ", height=" + this.height + ", fps=" + this.fps + '}';
        }
    }

    public static enum CAMERA_DIRECTION {
        CAMERA_REAR(0),
        CAMERA_FRONT(1);

        private int value;

        private CAMERA_DIRECTION(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }
    }
}

