/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.internal;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import io.agora.rtc2.internal.CommonUtility;
import io.agora.rtc2.internal.Logging;
import java.lang.ref.WeakReference;

class ProcessLifecycleOwner
implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = "ProcessLifecycleOwner";
    private static final long TIMEOUT_MS = 1000L;
    private final WeakReference<CommonUtility> mCommonUtility;
    private final Handler handler;
    private boolean isForeground;
    private final Runnable mDelayedPauseRunnable = new Runnable(){

        @Override
        public void run() {
            ProcessLifecycleOwner.this.setForeground(false);
        }
    };
    private final Runnable mDelayedResumeRunnable = new Runnable(){

        @Override
        public void run() {
            ProcessLifecycleOwner.this.setForeground(true);
        }
    };

    ProcessLifecycleOwner(boolean foreground, CommonUtility cu) {
        this.isForeground = foreground;
        this.handler = new Handler(Looper.getMainLooper());
        this.mCommonUtility = new WeakReference<CommonUtility>(cu);
        Logging.d(TAG, "ProcessLifecycleOwner, isForeground : " + this.isForeground);
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        Logging.d(TAG, "onActivityResumed()");
        this.handler.removeCallbacks(this.mDelayedPauseRunnable);
        this.handler.postDelayed(this.mDelayedResumeRunnable, 1000L);
    }

    public void onActivityPaused(Activity activity) {
        Logging.d(TAG, "onActivityPaused()");
        this.handler.removeCallbacks(this.mDelayedResumeRunnable);
        this.handler.postDelayed(this.mDelayedPauseRunnable, 1000L);
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    private void setForeground(boolean para) {
        if (this.isForeground == para) {
            return;
        }
        this.isForeground = para;
        CommonUtility cu = (CommonUtility)this.mCommonUtility.get();
        if (cu == null) {
            return;
        }
        cu.onForegroundChanged(this.isForeground);
    }
}

