/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.voiceengine;

import android.annotation.TargetApi;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioRouting;
import android.media.AudioTimestamp;
import android.os.Build;
import android.os.Process;
import androidx.annotation.Nullable;
import io.agora.base.internal.ContextUtils;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.voiceengine.WebRtcAudioEffects;
import io.agora.base.internal.voiceengine.WebRtcAudioUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class WebRtcAudioRecord {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioRecord [JavaAdm]";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final int BUFFER_SIZE_FACTOR = 2;
    private static final long AUDIO_RECORD_THREAD_JOIN_TIMEOUT_MS = 2000L;
    private static final int DEFAULT_AUDIO_SOURCE;
    private static final int CALCULATE_LATENCY_PERIOD = 400;
    private static final int MAX_RECORD_LATENCY = 250;
    private static int audioSource;
    private final long nativeAudioRecord;
    private final AudioManager audioManager;
    @Nullable
    private WebRtcAudioEffects effects = null;
    private ByteBuffer byteBuffer;
    @Nullable
    private AudioRecord audioRecord = null;
    @Nullable
    private AudioRecordThread audioThread = null;
    private static volatile boolean microphoneMute;
    private byte[] emptyBytes;
    private int mRecordLatency = 0;
    private long mFramesRead = 0L;
    private int mBytesPerFrame = 2;
    private int mRecordLoopCounter = 0;
    private static final int DEFAULT_RECORD_LATENCY = 60;
    @Nullable
    private static WebRtcAudioRecordErrorCallback errorCallback;
    @Nullable
    private static AudioRecordRouteCallback recordRouteCallback;
    @Nullable
    private static WebRtcAudioRecordSamplesReadyCallback audioSamplesReadyCallback;
    @Nullable
    private AudioRecordRoutingListenerForAPI23 recordRouteListenerForAPI23 = null;
    @Nullable
    private AudioRecordRoutingListener recordRouteListener = null;

    public static void setErrorCallback(WebRtcAudioRecordErrorCallback errorCallback) {
        Logging.d(TAG, "Set error callback");
        WebRtcAudioRecord.errorCallback = errorCallback;
    }

    public static void setRecordRouteCallback(AudioRecordRouteCallback recRouteCallback) {
        Logging.d(TAG, "[USB] Set AudioRecordRouteCallback");
        recordRouteCallback = recRouteCallback;
    }

    public static void setOnAudioSamplesReady(WebRtcAudioRecordSamplesReadyCallback callback) {
        audioSamplesReadyCallback = callback;
    }

    WebRtcAudioRecord(long nativeAudioRecord) {
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
        this.nativeAudioRecord = nativeAudioRecord;
        this.audioManager = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
        this.effects = WebRtcAudioEffects.create();
        int apiLevel = Build.VERSION.SDK_INT;
        if (apiLevel == 23) {
            this.recordRouteListenerForAPI23 = new AudioRecordRoutingListenerForAPI23();
        } else if (apiLevel > 23) {
            this.recordRouteListener = new AudioRecordRoutingListener();
        }
    }

    private boolean enableBuiltInAEC(boolean enable) {
        Logging.d(TAG, "enableBuiltInAEC(" + enable + ')');
        if (this.effects == null) {
            Logging.e(TAG, "Built-in AEC is not supported on this platform");
            return false;
        }
        return this.effects.setAEC(enable);
    }

    private boolean enableBuiltInNS(boolean enable) {
        Logging.d(TAG, "enableBuiltInNS(" + enable + ')');
        if (this.effects == null) {
            Logging.e(TAG, "Built-in NS is not supported on this platform");
            return false;
        }
        return this.effects.setNS(enable);
    }

    private boolean enableBuiltInAGC(boolean enable) {
        Logging.d(TAG, "enableBuiltInAGC(" + enable + ')');
        if (this.effects == null) {
            Logging.e(TAG, "Built-in AGC is not supported on this platform");
            return false;
        }
        return this.effects.setAGC(enable);
    }

    private int initRecording(int sampleRate, int channels, int minBufMs) {
        Logging.d(TAG, "initRecording(sampleRate=" + sampleRate + ", channels=" + channels + ", minBufMs " + minBufMs + ")");
        if (this.audioRecord != null) {
            this.reportWebRtcAudioRecordInitError("InitRecording called twice without StopRecording.");
            return -1;
        }
        this.mBytesPerFrame = channels * 2;
        int framesPerBuffer = sampleRate / 100;
        this.byteBuffer = ByteBuffer.allocateDirect(this.mBytesPerFrame * framesPerBuffer);
        Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.emptyBytes = new byte[this.byteBuffer.capacity()];
        this.nativeCacheDirectBufferAddress(this.byteBuffer, this.nativeAudioRecord);
        int channelConfig = this.channelCountToConfiguration(channels);
        int minBufferSize = AudioRecord.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)2);
        if (minBufferSize == -1 || minBufferSize == -2) {
            this.reportWebRtcAudioRecordInitError("AudioRecord.getMinBufferSize failed: " + minBufferSize);
            return -1;
        }
        Logging.d(TAG, "AudioRecord.getMinBufferSize: " + minBufferSize);
        int bufferSizeInBytes = Math.max(2 * minBufferSize, this.byteBuffer.capacity());
        int profileBufferSize = minBufMs * (sampleRate / 1000 * channels * 2);
        if (bufferSizeInBytes < profileBufferSize) {
            bufferSizeInBytes = profileBufferSize;
        }
        Logging.d(TAG, "bufferSizeInBytes: " + bufferSizeInBytes);
        Logging.d(TAG, "initRecording audio mode: " + WebRtcAudioUtils.modeToString(this.audioManager.getMode()) + ", source: " + WebRtcAudioUtils.sourceToString(audioSource) + ", sampleRate: " + sampleRate);
        if (!ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.microphone")) {
            Logging.d(TAG, "[USB] Before create audiorecord instance: has no PackageManager.FEATURE_MICROPHONE");
        }
        try {
            this.audioRecord = new AudioRecord(audioSource, sampleRate, channelConfig, 2, bufferSizeInBytes);
        }
        catch (IllegalArgumentException e) {
            this.reportWebRtcAudioRecordInitError("AudioRecord ctor error: " + e.getMessage());
            this.releaseAudioResources();
            return -1;
        }
        if (this.audioRecord == null || this.audioRecord.getState() != 1) {
            this.reportWebRtcAudioRecordInitError("Failed to create a new AudioRecord instance: instance= " + this.audioRecord == null ? "null" : "success state = " + this.audioRecord.getState());
            this.releaseAudioResources();
            return -1;
        }
        if (this.effects != null) {
            this.effects.enable(this.audioRecord.getAudioSessionId());
        }
        this.logMainParameters();
        this.logMainParametersExtended();
        int apiLevel = Build.VERSION.SDK_INT;
        if (apiLevel >= 23) {
            AudioDeviceInfo defaultDevice = this.audioRecord.getPreferredDevice();
            if (defaultDevice != null) {
                Logging.d(TAG, "[USB] deviceType = " + defaultDevice.getType());
            } else {
                Logging.d(TAG, "[USB] has no preferred device");
                defaultDevice = this.audioRecord.getRoutedDevice();
                if (defaultDevice != null) {
                    Logging.d(TAG, "[USB] initRecording-getRoutedDevice deviceType = " + defaultDevice.getType());
                }
            }
            if (defaultDevice != null && recordRouteCallback != null) {
                recordRouteCallback.onAudioRecordRouteNotify(0, defaultDevice);
            }
            Logging.d(TAG, "android.os.Build.VERSION.SDK_INT = " + apiLevel);
            if (apiLevel == 23) {
                if (this.recordRouteListenerForAPI23 != null) {
                    this.audioRecord.addOnRoutingChangedListener((AudioRecord.OnRoutingChangedListener)this.recordRouteListenerForAPI23, null);
                }
            } else if (apiLevel > 23 && this.recordRouteListener != null) {
                this.audioRecord.addOnRoutingChangedListener((AudioRouting.OnRoutingChangedListener)this.recordRouteListener, null);
            }
        }
        return framesPerBuffer;
    }

    private int startRecording() {
        Logging.d(TAG, "startRecording");
        WebRtcAudioRecord.assertTrue(this.audioRecord != null);
        WebRtcAudioRecord.assertTrue(this.audioThread == null);
        try {
            this.audioRecord.startRecording();
        }
        catch (IllegalStateException e) {
            this.releaseAudioResources();
            this.reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode.AUDIO_RECORD_START_EXCEPTION, "AudioRecord.startRecording failed: " + e.getMessage());
            return -1;
        }
        int recState = this.audioRecord.getRecordingState();
        if (recState != 3) {
            this.releaseAudioResources();
            this.reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode.AUDIO_RECORD_START_STATE_MISMATCH, "AudioRecord.startRecording failed - incorrect state :" + recState);
            return -1;
        }
        this.mFramesRead = 0L;
        this.audioThread = new AudioRecordThread("AudioRecordJavaThread");
        this.audioThread.start();
        return this.audioRecord.getAudioSessionId();
    }

    private boolean stopRecording() {
        Logging.d(TAG, "stopRecording");
        WebRtcAudioRecord.assertTrue(this.audioThread != null);
        this.audioThread.stopThread();
        if (!ThreadUtils.joinUninterruptibly(this.audioThread, 2000L)) {
            Logging.e(TAG, "Join of AudioRecordJavaThread timed out");
            WebRtcAudioUtils.logAudioState(TAG);
        }
        this.audioThread = null;
        int apiLevel = Build.VERSION.SDK_INT;
        if (apiLevel == 23) {
            if (this.recordRouteListenerForAPI23 != null) {
                this.audioRecord.removeOnRoutingChangedListener((AudioRecord.OnRoutingChangedListener)this.recordRouteListenerForAPI23);
            }
        } else if (apiLevel > 23 && this.recordRouteListener != null) {
            this.audioRecord.removeOnRoutingChangedListener((AudioRouting.OnRoutingChangedListener)this.recordRouteListener);
        }
        this.releaseAudioResources();
        return true;
    }

    private int calculateLatencyMillis() {
        if (this.audioRecord == null) {
            Logging.e(TAG, "audioRecord is null");
            return -1;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            AudioTimestamp audioTimestamp = new AudioTimestamp();
            int result = this.audioRecord.getTimestamp(audioTimestamp, 0);
            if (result != 0) {
                Logging.e(TAG, "audioTimestamp is unavailable");
                return -1;
            }
            long appFrameIndex = this.mFramesRead;
            long frameIndexDelta = appFrameIndex - audioTimestamp.framePosition;
            long frameTimeDeltaNano = frameIndexDelta * 1000L * 1000L * 1000L / (long)this.audioRecord.getSampleRate();
            long appFrameHardwareTimeNano = audioTimestamp.nanoTime + frameTimeDeltaNano;
            long appTimeNano = System.nanoTime();
            long latencyNano = appTimeNano - appFrameHardwareTimeNano;
            int latencyMillis = (int)(latencyNano / 1000000L);
            int extraTime = this.audioRecord.getBufferSizeInFrames() * 1000 / this.audioRecord.getSampleRate();
            if (latencyMillis > 0 && latencyMillis <= 250) {
                this.mRecordLatency = latencyMillis + (extraTime > 20 ? extraTime / 2 : 10);
            }
        } else {
            this.mRecordLatency = 60;
        }
        return this.mRecordLatency;
    }

    private void logMainParameters() {
        Logging.d(TAG, "AudioRecord: session ID: " + this.audioRecord.getAudioSessionId() + ", channels: " + this.audioRecord.getChannelCount() + ", sample rate: " + this.audioRecord.getSampleRate());
    }

    @TargetApi(value=23)
    private void logMainParametersExtended() {
        if (WebRtcAudioUtils.runningOnMarshmallowOrHigher()) {
            Logging.d(TAG, "AudioRecord: buffer size in frames: " + this.audioRecord.getBufferSizeInFrames());
        }
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private int channelCountToConfiguration(int channels) {
        return channels == 1 ? 16 : 12;
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeDataIsRecorded(int var1, int var2, long var3);

    public static synchronized int setAudioSource(int source) {
        Logging.w(TAG, "Audio source is changed from: " + audioSource + " to " + source);
        audioSource = source;
        return 0;
    }

    private static int getDefaultAudioSource() {
        return 7;
    }

    public static void setMicrophoneMute(boolean mute) {
        Logging.w(TAG, "setMicrophoneMute(" + mute + ")");
        microphoneMute = mute;
    }

    private void releaseAudioResources() {
        Logging.d(TAG, "releaseAudioResources");
        try {
            if (this.effects != null) {
                this.effects.release();
            }
            if (this.audioRecord != null) {
                this.audioRecord.release();
                this.audioRecord = null;
            }
        }
        catch (Exception e) {
            Logging.w(TAG, "releaseAudioResources e: " + e.getMessage());
        }
    }

    private void reportWebRtcAudioRecordInitError(String errorMessage) {
        Logging.e(TAG, "Init recording error: " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG);
        if (errorCallback != null) {
            errorCallback.onWebRtcAudioRecordInitError(errorMessage);
        }
    }

    private void reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode errorCode, String errorMessage) {
        Logging.e(TAG, "Start recording error: " + (Object)((Object)errorCode) + ". " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG);
        if (errorCallback != null) {
            errorCallback.onWebRtcAudioRecordStartError(errorCode, errorMessage);
        }
    }

    private void reportWebRtcAudioRecordError(String errorMessage) {
        Logging.e(TAG, "Run-time recording error: " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG);
        if (errorCallback != null) {
            errorCallback.onWebRtcAudioRecordError(errorMessage);
        }
    }

    static {
        audioSource = DEFAULT_AUDIO_SOURCE = WebRtcAudioRecord.getDefaultAudioSource();
        microphoneMute = false;
        errorCallback = null;
        recordRouteCallback = null;
        audioSamplesReadyCallback = null;
    }

    private class AudioRecordRoutingListener
    implements AudioRouting.OnRoutingChangedListener {
        private AudioRecordRoutingListener() {
        }

        public void onRoutingChanged(AudioRouting audioRouting) {
            AudioDeviceInfo dev = audioRouting.getPreferredDevice();
            int type = -1;
            if (dev != null) {
                type = dev.getType();
            }
            if ((dev = audioRouting.getRoutedDevice()) != null && type == -1) {
                type = dev.getType();
            }
            if (dev != null && recordRouteCallback != null) {
                recordRouteCallback.onAudioRecordRouteNotify(1, dev);
            }
            Logging.d(WebRtcAudioRecord.TAG, "[USB] [AudioRecord-audioRouting] onRoutingChanged: " + type);
        }
    }

    private class AudioRecordRoutingListenerForAPI23
    implements AudioRecord.OnRoutingChangedListener {
        private AudioRecordRoutingListenerForAPI23() {
        }

        public void onRoutingChanged(AudioRecord audioTrack) {
            AudioDeviceInfo dev = audioTrack.getPreferredDevice();
            int type = -1;
            if (dev != null) {
                type = dev.getType();
            }
            if ((dev = audioTrack.getRoutedDevice()) != null && type == -1) {
                type = dev.getType();
            }
            if (dev != null && recordRouteCallback != null) {
                recordRouteCallback.onAudioRecordRouteNotify(1, dev);
            }
            Logging.d(WebRtcAudioRecord.TAG, "[USB] [AudioRecord-audioRecord] onRoutingChanged:" + type);
        }

        public void onRoutingChanged(AudioRouting audioRouting) {
            AudioDeviceInfo dev = audioRouting.getPreferredDevice();
            int type = -1;
            if (dev != null) {
                type = dev.getType();
            }
            if ((dev = audioRouting.getRoutedDevice()) != null && type == -1) {
                type = dev.getType();
            }
            if (dev != null && recordRouteCallback != null) {
                recordRouteCallback.onAudioRecordRouteNotify(1, dev);
            }
            Logging.d(WebRtcAudioRecord.TAG, "[USB] [AudioRecord-audioRouting] onRoutingChanged: " + type);
        }
    }

    private class AudioRecordThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioRecordThread(String name) {
            super(name);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            Logging.d(WebRtcAudioRecord.TAG, "AudioRecordThread" + WebRtcAudioUtils.getThreadInfo());
            WebRtcAudioRecord.assertTrue(WebRtcAudioRecord.this.audioRecord.getRecordingState() == 3);
            long lastTime = System.nanoTime();
            while (this.keepAlive) {
                int bytesRead = WebRtcAudioRecord.this.audioRecord.read(WebRtcAudioRecord.this.byteBuffer, WebRtcAudioRecord.this.byteBuffer.capacity());
                if (bytesRead == WebRtcAudioRecord.this.byteBuffer.capacity()) {
                    if (microphoneMute) {
                        WebRtcAudioRecord.this.byteBuffer.clear();
                        WebRtcAudioRecord.this.byteBuffer.put(WebRtcAudioRecord.this.emptyBytes);
                    }
                    if (this.keepAlive) {
                        WebRtcAudioRecord.this.nativeDataIsRecorded(bytesRead, WebRtcAudioRecord.this.mRecordLatency, WebRtcAudioRecord.this.nativeAudioRecord);
                    }
                    if (audioSamplesReadyCallback != null) {
                        byte[] data = Arrays.copyOf(WebRtcAudioRecord.this.byteBuffer.array(), WebRtcAudioRecord.this.byteBuffer.capacity());
                        audioSamplesReadyCallback.onWebRtcAudioRecordSamplesReady(new AudioSamples(WebRtcAudioRecord.this.audioRecord, data));
                    }
                } else {
                    String errorMessage = "AudioRecord.read failed: " + bytesRead;
                    Logging.e(WebRtcAudioRecord.TAG, errorMessage);
                    if (bytesRead == -3) {
                        this.keepAlive = false;
                        WebRtcAudioRecord.this.reportWebRtcAudioRecordError(errorMessage);
                    }
                }
                if (WebRtcAudioRecord.this.mFramesRead == 0L) {
                    Logging.d(WebRtcAudioRecord.TAG, "AudioRecordThread read first frame : " + bytesRead / WebRtcAudioRecord.this.mBytesPerFrame + " finished. ");
                }
                WebRtcAudioRecord.this.mFramesRead += bytesRead / WebRtcAudioRecord.this.mBytesPerFrame;
                try {
                    if (WebRtcAudioRecord.this.mRecordLoopCounter % 400 == 0) {
                        WebRtcAudioRecord.this.calculateLatencyMillis();
                    }
                    WebRtcAudioRecord.this.mRecordLoopCounter = (WebRtcAudioRecord.this.mRecordLoopCounter + 1) % 400;
                }
                catch (Throwable e) {
                    Logging.e(WebRtcAudioRecord.TAG, "calculateLatencyMillis failed: " + e.getMessage());
                }
            }
            try {
                if (WebRtcAudioRecord.this.audioRecord != null) {
                    WebRtcAudioRecord.this.audioRecord.stop();
                }
            }
            catch (IllegalStateException e) {
                Logging.e(WebRtcAudioRecord.TAG, "AudioRecord.stop failed: " + e.getMessage());
            }
        }

        public void stopThread() {
            Logging.d(WebRtcAudioRecord.TAG, "stopThread");
            this.keepAlive = false;
        }
    }

    public static interface WebRtcAudioRecordSamplesReadyCallback {
        public void onWebRtcAudioRecordSamplesReady(AudioSamples var1);
    }

    public static class AudioSamples {
        private final int audioFormat;
        private final int channelCount;
        private final int sampleRate;
        private final byte[] data;

        private AudioSamples(AudioRecord audioRecord, byte[] data) {
            this.audioFormat = audioRecord.getAudioFormat();
            this.channelCount = audioRecord.getChannelCount();
            this.sampleRate = audioRecord.getSampleRate();
            this.data = data;
        }

        public int getAudioFormat() {
            return this.audioFormat;
        }

        public int getChannelCount() {
            return this.channelCount;
        }

        public int getSampleRate() {
            return this.sampleRate;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    public static interface AudioRecordRouteCallback {
        public void onAudioRecordRouteNotify(int var1, AudioDeviceInfo var2);
    }

    public static interface WebRtcAudioRecordErrorCallback {
        public void onWebRtcAudioRecordInitError(String var1);

        public void onWebRtcAudioRecordStartError(AudioRecordStartErrorCode var1, String var2);

        public void onWebRtcAudioRecordError(String var1);
    }

    public static enum AudioRecordStartErrorCode {
        AUDIO_RECORD_START_EXCEPTION,
        AUDIO_RECORD_START_STATE_MISMATCH;

    }
}

