/*
 * Decompiled with CFR 0.152.
 */
package io.agora.push;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Pair;
import io.agora.chat.ChatClient;
import io.agora.cloud.EMHttpClient;
import io.agora.push.PushConfig;
import io.agora.push.PushListener;
import io.agora.push.PushType;
import io.agora.push.platform.a.a;
import io.agora.util.DeviceUuidFactory;
import io.agora.util.EMLog;
import java.util.ArrayList;
import java.util.Random;
import org.json.JSONObject;

public class PushHelper {
    private static final String a = "PushHelper";
    private static final int b = 3;
    private static final int c = 0;
    private static final int d = 1;
    private static final int e = 2;
    private Context f;
    private PushConfig g;
    private io.agora.push.platform.a h;
    private Handler i;
    private PushType j;
    private String k;
    private boolean l;
    private final Object m = new Object();
    private final Object n = new Object();
    private PushListener o;
    private boolean p = false;

    private PushHelper() {
        HandlerThread handlerThread = new HandlerThread("token-uploader");
        handlerThread.start();
        this.i = new Handler(handlerThread.getLooper()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 0: {
                        Object object = PushHelper.this.m;
                        synchronized (object) {
                            boolean bl;
                            String string = (String)msg.obj;
                            boolean bl2 = PushHelper.this.a(PushHelper.this.h.a(), string);
                            if (bl2) {
                                this.removeMessages(0);
                                return;
                            }
                            boolean bl3 = bl = !this.hasMessages(0);
                            if (bl) {
                                PushHelper.this.onErrorResponse(PushHelper.this.j, 1501L);
                                PushHelper.this.a(PushType.NORMAL);
                            }
                            break;
                        }
                    }
                    case 1: {
                        PushHelper.this.l = PushHelper.this.a(PushHelper.this.h.a(), "");
                        if (!PushHelper.this.l) {
                            PushHelper.this.onErrorResponse(PushHelper.this.j, 1502L);
                        }
                        Object object = PushHelper.this.n;
                        synchronized (object) {
                            PushHelper.this.n.notifyAll();
                            break;
                        }
                    }
                    case 2: {
                        Bundle bundle = msg.getData();
                        if (bundle == null) {
                            return;
                        }
                        String string = bundle.getString("type", "");
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            return;
                        }
                        PushType pushType = PushType.getType(string);
                        PushHelper.this.c(pushType, (String)msg.obj);
                        break;
                    }
                    default: {
                        super.handleMessage(msg);
                    }
                }
            }
        };
    }

    public static PushHelper getInstance() {
        return InstanceHolder.a;
    }

    public void setPushListener(PushListener callback) {
        this.o = callback;
    }

    public void init(Context context, PushConfig config) {
        EMLog.e(a, "PushHelper init, config: " + config.toString());
        if (context == null || config == null) {
            throw new IllegalArgumentException("Null parameters, context=" + context + ", config=" + config);
        }
        this.f = context.getApplicationContext();
        this.g = config;
    }

    public void register() {
        if (this.f == null || this.g == null) {
            EMLog.e(a, "PushHelper#init(Context, PushConfig) method not call previously.");
            return;
        }
        PushType pushType = this.a(this.g);
        EMLog.e(a, "PushHelper register, prefer push type: " + (Object)((Object)pushType));
        this.a(pushType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(boolean unbindToken) {
        EMLog.e(a, "PushHelper unregister, unbind token: " + unbindToken);
        if (!this.p) {
            EMLog.e(a, "PushHelper is not registered previously, return true directly.");
            return true;
        }
        this.p = false;
        this.h.a(this.f);
        this.i.removeMessages(2);
        this.i.removeMessages(0);
        if (!unbindToken) {
            this.j = null;
            return true;
        }
        if (this.j != null && this.j != PushType.NORMAL) {
            this.a();
            Object object = this.n;
            synchronized (object) {
                try {
                    this.n.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.l) {
                this.j = null;
            }
        } else {
            this.l = true;
            this.j = null;
        }
        EMLog.e(a, "Push type after unregister is " + (Object)((Object)this.j));
        return this.l;
    }

    private boolean a(PushType pushType, String string) {
        String string2 = PushHelper.getInstance().getPushTokenWithType(pushType);
        return string2 == null || !string2.equals(string);
    }

    public void onReceiveToken(PushType type, String token) {
        EMLog.e(a, "onReceiveToken: " + (Object)((Object)type) + " - " + token);
        if (!this.p) {
            EMLog.e(a, "PushHelper is not registered, abort token upload action.");
            return;
        }
        this.k = token;
        if (this.a(type, token)) {
            EMLog.d(a, "push token changed, upload to server");
            this.b(type, token);
            return;
        }
        if (ChatClient.getInstance().getChatConfigPrivate().J()) {
            EMLog.d(a, "push token not change, but last login is not on this device, upload to server");
            this.b(type, token);
        } else {
            EMLog.e(a, "PushHelper not first login, ignore token upload action.");
        }
    }

    public void onErrorResponse(PushType type, long resultCode) {
        EMLog.e(a, "onErrorResponse: " + (Object)((Object)type) + " - " + resultCode);
        if (!this.p) {
            EMLog.e(a, "PushHelper is not registered, abort error response action.");
            return;
        }
        if (resultCode == 1500L) {
            this.a(PushType.NORMAL);
        }
        if (this.o != null) {
            this.o.onError(type, resultCode);
        }
    }

    public PushType getPushType() {
        return this.j;
    }

    public String getPushToken() {
        return this.k;
    }

    public String getFCMPushToken() {
        return io.agora.chat.core.a.a().m();
    }

    public void setFCMPushToken(String token) {
        io.agora.chat.core.a.a().d(token);
    }

    public String getPushTokenWithType(PushType type) {
        return io.agora.chat.core.a.a().a(type);
    }

    public void setPushTokenWithType(PushType type, String token) {
        io.agora.chat.core.a.a().a(type, token);
    }

    private void a(@NonNull PushType pushType, boolean bl) {
        if (this.j == pushType) {
            EMLog.e(a, "Push type " + (Object)((Object)pushType) + " no change, return. ");
            return;
        }
        if (this.h != null) {
            EMLog.e(a, (Object)((Object)this.h.b()) + " push already exists, unregister it and change to " + (Object)((Object)pushType) + " push.");
            this.h.a(this.f);
        }
        this.j = pushType;
        switch (pushType) {
            case FCM: {
                this.h = new a();
                break;
            }
            case MIPUSH: {
                this.h = new io.agora.push.platform.mi.a();
                break;
            }
            case OPPOPUSH: {
                this.h = new io.agora.push.platform.oppo.a();
                break;
            }
            case VIVOPUSH: {
                this.h = new io.agora.push.platform.vivo.a();
                break;
            }
            case MEIZUPUSH: {
                this.h = new io.agora.push.platform.meizu.a();
                break;
            }
            case HMSPUSH: {
                this.h = new io.agora.push.platform.b.a();
                break;
            }
            case HONORPUSH: {
                this.h = new io.agora.push.platform.c.a();
                break;
            }
            default: {
                this.h = new io.agora.push.platform.d.a();
            }
        }
        this.p = true;
        if (bl) {
            return;
        }
        this.h.a(this.f, this.g, this.o);
    }

    private void a(@NonNull PushType pushType) {
        this.a(pushType, false);
    }

    private void b(PushType pushType, String string) {
        Message message = this.i.obtainMessage(2, (Object)string);
        Bundle bundle = new Bundle();
        bundle.putString("type", pushType.getName());
        message.setData(bundle);
        this.i.sendMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c(PushType pushType, String string) {
        Object object = this.m;
        synchronized (object) {
            this.i.removeMessages(0);
            this.a(pushType, true);
            for (int i = -1; i < 3; ++i) {
                Message message = this.i.obtainMessage(0, (Object)string);
                if (i == -1) {
                    this.i.sendMessage(message);
                    continue;
                }
                int n = this.randomDelay(i);
                EMLog.i(a, "Retry upload after " + n + "s if failed.");
                this.i.sendMessageDelayed(message, (long)(n * 1000));
            }
        }
    }

    private void a() {
        this.i.obtainMessage(1).sendToTarget();
    }

    private boolean a(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            EMLog.e(a, "uploadTokenInternal notifierName is null, return. current push type: " + (Object)((Object)this.j));
            return false;
        }
        String string3 = ChatClient.getInstance().getChatConfigPrivate().a(true, false) + "/users/" + ChatClient.getInstance().getCurrentUser() + "/push/binding";
        DeviceUuidFactory deviceUuidFactory = new DeviceUuidFactory(ChatClient.getInstance().getContext());
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("device_token", (Object)string2);
            jSONObject.put("notifier_name", (Object)string);
            jSONObject.put("device_id", (Object)deviceUuidFactory.getDeviceUuid().toString());
        }
        catch (Exception exception) {
            EMLog.e(a, "uploadTokenInternal put json exception: " + exception.toString());
        }
        int n = 2;
        do {
            try {
                EMLog.e(a, "uploadTokenInternal, token=" + string2 + ", url=" + string3 + ", notifier name=" + string);
                Pair<Integer, String> pair = EMHttpClient.getInstance().sendRequestWithToken(string3, jSONObject.toString(), EMHttpClient.PUT);
                int n2 = (Integer)pair.first;
                String string4 = (String)pair.second;
                if (n2 == 200) {
                    EMLog.e(a, "uploadTokenInternal success.");
                    PushHelper.getInstance().setPushTokenWithType(this.j, string2);
                    return true;
                }
                EMLog.e(a, "uploadTokenInternal failed: " + string4);
                string3 = ChatClient.getInstance().getChatConfigPrivate().a(true, true) + "/users/" + ChatClient.getInstance().getCurrentUser();
            }
            catch (Exception exception) {
                EMLog.e(a, "uploadTokenInternal exception: " + exception.toString());
                string3 = ChatClient.getInstance().getChatConfigPrivate().a(true, true) + "/users/" + ChatClient.getInstance().getCurrentUser();
            }
        } while (--n > 0);
        return false;
    }

    private PushType a(PushConfig pushConfig) {
        PushType[] pushTypeArray = new PushType[]{PushType.FCM, PushType.MIPUSH, PushType.HMSPUSH, PushType.MEIZUPUSH, PushType.OPPOPUSH, PushType.VIVOPUSH, PushType.HONORPUSH};
        ArrayList<PushType> arrayList = pushConfig.getEnabledPushTypes();
        for (PushType pushType : pushTypeArray) {
            if (!arrayList.contains((Object)pushType) || !this.a(pushType, pushConfig)) continue;
            return pushType;
        }
        return PushType.NORMAL;
    }

    private boolean a(PushType pushType, PushConfig pushConfig) {
        boolean bl = this.o != null ? this.o.isSupportPush(pushType, pushConfig) : io.agora.push.a.a.a(pushType, pushConfig);
        EMLog.i(a, "isSupportPush: " + (Object)((Object)pushType) + " - " + bl);
        return bl;
    }

    public int randomDelay(int attempts) {
        if (attempts == 0) {
            return new Random().nextInt(5) + 1;
        }
        if (attempts == 1) {
            return new Random().nextInt(54) + 6;
        }
        return new Random().nextInt(540) + 60;
    }

    private static class InstanceHolder {
        static PushHelper a = new PushHelper();

        private InstanceHolder() {
        }
    }
}

