/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat.adapter;

import android.text.TextUtils;
import io.agora.chat.ChatThreadEvent;
import io.agora.chat.adapter.EMABase;
import io.agora.chat.adapter.message.EMAMessage;
import io.agora.util.EMLog;

public class EMAThreadInfo
extends EMABase {
    public EMAThreadInfo() {
        this.nativeInit();
    }

    public void finalize() throws Throwable {
        this.nativeFinalize();
        super.finalize();
    }

    public ChatThreadEvent.TYPE getType() {
        String string = this.nativeGetThreadType();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        ChatThreadEvent.TYPE tYPE = null;
        try {
            tYPE = ChatThreadEvent.TYPE.valueOf(string.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            EMLog.e("EMThreadEvent", illegalArgumentException.getMessage());
            tYPE = ChatThreadEvent.TYPE.UNKNOWN;
        }
        return tYPE;
    }

    public String getThreadId() {
        return this.nativeGetThreadId();
    }

    public String getThreadName() {
        return this.nativeGetThreadName();
    }

    public String getOwner() {
        return this.nativeGetOwner();
    }

    public String getParentId() {
        return this.nativeGetParentId();
    }

    public String getMessageId() {
        return this.nativeGetMessageId();
    }

    public String getFrom() {
        return this.nativeGetFrom();
    }

    public String getTo() {
        return this.nativeGetTo();
    }

    public long getCreateAt() {
        return this.nativeGetCreateAt();
    }

    public long getUpdateAt() {
        return this.nativeGetUpdateAt();
    }

    public int getMessageCount() {
        return this.nativeGetMessageCount();
    }

    public int getMemberCount() {
        return this.nativeGetMemberCount();
    }

    public EMAMessage getLastMessage() {
        return this.nativeGetLastMessage();
    }

    native void nativeInit();

    native void nativeFinalize();

    native String nativeGetThreadType();

    native String nativeGetThreadId();

    native String nativeGetThreadName();

    native String nativeGetOwner();

    native String nativeGetParentId();

    native String nativeGetMessageId();

    native String nativeGetFrom();

    native String nativeGetTo();

    native long nativeGetCreateAt();

    native long nativeGetUpdateAt();

    native int nativeGetMessageCount();

    native int nativeGetMemberCount();

    native EMAMessage nativeGetLastMessage();

    public static enum LeaveReason {
        LEFT,
        BE_KICKED,
        DESTROYED;

    }
}

