/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat.adapter;

import io.agora.chat.Conversation;
import io.agora.chat.CursorResult;
import io.agora.chat.adapter.EMABase;
import io.agora.chat.adapter.EMAChatManagerListener;
import io.agora.chat.adapter.EMAConversation;
import io.agora.chat.adapter.EMAEncryptProviderInterface;
import io.agora.chat.adapter.EMAError;
import io.agora.chat.adapter.EMAFetchMessageOption;
import io.agora.chat.adapter.EMAGroupReadAck;
import io.agora.chat.adapter.message.EMAMessage;
import io.agora.chat.adapter.message.EMAMessageBody;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EMAChatManager
extends EMABase {
    private Set<EMAChatManagerListener> listeners = new HashSet<EMAChatManagerListener>();

    public void sendMessage(EMAMessage msg) {
        this.nativeSendMessage(msg);
    }

    public void recallMessage(EMAMessage msg, EMAError error) {
        this.nativeRecallMessage(msg, error);
    }

    public void sendReadAckForConversation(String conversationId, EMAError error) {
        this.nativeSendReadAckForConversation(conversationId, error);
    }

    public void sendReadAckForMessage(EMAMessage msg) {
        this.nativeSendReadAckForMessage(msg);
    }

    public void sendReadAckForGroupMessage(EMAMessage msg, String ext) {
        this.nativeSendReadAckForGroupMessage(msg, ext);
    }

    public void resendMessage(EMAMessage msg) {
        this.nativeResendMessage(msg);
    }

    public void downloadMessageThumbnail(EMAMessage msg) {
        this.nativeDownloadMessageThumbnail(msg);
    }

    public void downloadMessageAttachments(EMAMessage msg) {
        this.nativeDownloadMessageAttachments(msg);
    }

    public void removeConversation(String conversationId, boolean isRemoveMessages, boolean isThread) {
        this.nativeRemoveConversation(conversationId, isRemoveMessages, isThread);
    }

    public EMAError deleteConversationFromServer(String conversationId, EMAConversation.EMAConversationType type, boolean isDeleteServerMessages) {
        return this.nativeDeleteConversationFromServer(conversationId, type.ordinal(), isDeleteServerMessages);
    }

    public EMAConversation conversationWithType(String conversationId, EMAConversation.EMAConversationType type, boolean createIfNotExist, boolean isThread) {
        return this.nativeConversationWithType(conversationId, type.ordinal(), createIfNotExist, isThread);
    }

    public List<EMAConversation> getConversations() {
        return this.nativeGetConversations();
    }

    public List<EMAConversation> fetchConversationsFromServer(EMAError error) {
        return this.nativeFetchConversationsFromServer(error);
    }

    public List<EMAConversation> fetchConversationsFromServerWithPage(EMAError error, int pageNum, int pageSize) {
        return this.nativeFetchConversationsFromServerWithPage(error, pageNum, pageSize);
    }

    public List<EMAConversation> loadAllConversationsFromDB() {
        return this.nativeLoadAllConversationsFromDB();
    }

    public void addListener(EMAChatManagerListener listener) {
        this.listeners.add(listener);
        this.nativeAddListener(listener);
    }

    public void removeListener(EMAChatManagerListener listener) {
        this.listeners.remove(listener);
        this.nativeRemoveListener(listener);
    }

    public void clearListeners() {
        this.listeners.clear();
        this.nativeClearListeners();
    }

    public void setEncryptProvider(EMAEncryptProviderInterface provider) {
        this.nativeSetEncryptProvider(provider);
    }

    public EMAEncryptProviderInterface getEncryptProvider(boolean createIfNotExist) {
        return this.nativeGetEncryptProvider(createIfNotExist);
    }

    public EMAMessage getMessage(String messageId) {
        return this.nativeGetMessage(messageId);
    }

    public EMAMessage getMessage(long nativeHandler) {
        return this.nativeGetMessageByHandler(nativeHandler);
    }

    public void uploadLog() {
        this.nativeUploadLog();
    }

    public EMAError deleteRoamMsgFromServerById(String conversationId, Conversation.ConversationType type, List<String> msgIdList) {
        return this.nativeDeleteRoamMsgFromServerById(conversationId, type.ordinal(), msgIdList);
    }

    public EMAError deleteRoamMsgFromServerByTime(String conversationId, Conversation.ConversationType type, long startTimeStamp) {
        return this.nativeDeleteRoamMsgFromServerByTime(conversationId, type.ordinal(), startTimeStamp);
    }

    native void nativeSendMessage(EMAMessage var1);

    native void nativeRecallMessage(EMAMessage var1, EMAError var2);

    native void nativeSendReadAckForConversation(String var1, EMAError var2);

    native void nativeSendReadAckForMessage(EMAMessage var1);

    native void nativeSendReadAckForGroupMessage(EMAMessage var1, String var2);

    native void nativeResendMessage(EMAMessage var1);

    native void nativeDownloadMessageThumbnail(EMAMessage var1);

    native void nativeDownloadMessageAttachments(EMAMessage var1);

    native void nativeRemoveConversation(String var1, boolean var2, boolean var3);

    native EMAError nativeDeleteConversationFromServer(String var1, int var2, boolean var3);

    native EMAConversation nativeConversationWithType(String var1, int var2, boolean var3, boolean var4);

    native List<EMAConversation> nativeGetConversations();

    native List<EMAConversation> nativeFetchConversationsFromServer(EMAError var1);

    native List<EMAConversation> nativeFetchConversationsFromServerWithPage(EMAError var1, int var2, int var3);

    native List<EMAConversation> nativeLoadAllConversationsFromDB();

    native void nativeAddListener(EMAChatManagerListener var1);

    native void nativeRemoveListener(EMAChatManagerListener var1);

    native void nativeClearListeners();

    native void nativeSetEncryptProvider(EMAEncryptProviderInterface var1);

    native EMAEncryptProviderInterface nativeGetEncryptProvider(boolean var1);

    native EMAMessage nativeGetMessage(String var1);

    native EMAMessage nativeGetMessageByHandler(long var1);

    native void nativeUploadLog();

    protected EMAChatManager() {
    }

    protected EMAChatManager(EMAChatManager manager) {
        this.nativeInit(manager);
    }

    native void nativeInit(EMAChatManager var1);

    public boolean updateParticipant(String from, String changeTo) {
        return this.nativeUpdateParticipant(from, changeTo);
    }

    native boolean nativeUpdateParticipant(String var1, String var2);

    public CursorResult<EMAGroupReadAck> fetchGroupReadAcks(String msgId, String groupId, EMAError error, int pageSize, String startAckId) {
        return this.nativeFetchGroupReadAcks(msgId, groupId, error, pageSize, startAckId);
    }

    public CursorResult<EMAMessage> fetchHistoryMessages(String conversationId, int type, int pageSize, String startMsgId, EMAConversation.EMASearchDirection direction, EMAError error) {
        return this.nativeFetchHistoryMessages(conversationId, type, pageSize, startMsgId, direction.ordinal(), error);
    }

    public CursorResult<EMAMessage> fetchHistoryMessages(String conversationId, int type, int pageSize, String cursor, EMAFetchMessageOption option, EMAError error) {
        return this.nativeFetchHistoryMessagesByOption(conversationId, type, pageSize, cursor, option, error);
    }

    native CursorResult<EMAGroupReadAck> nativeFetchGroupReadAcks(String var1, String var2, EMAError var3, int var4, String var5);

    native CursorResult<EMAMessage> nativeFetchHistoryMessages(String var1, int var2, int var3, String var4, int var5, EMAError var6);

    native CursorResult<EMAMessage> nativeFetchHistoryMessagesByOption(String var1, int var2, int var3, String var4, EMAFetchMessageOption var5, EMAError var6);

    public List<EMAMessage> searchMessages(int type, long timeStamp, int maxCount, String from, EMAConversation.EMASearchDirection direction) {
        return this.nativeSearchMessages(type, timeStamp, maxCount, from, direction.ordinal());
    }

    public List<EMAMessage> searchMessages(String keywords, long timeStamp, int maxCount, String from, EMAConversation.EMASearchDirection direction) {
        return this.nativeSearchMessages(keywords, timeStamp, maxCount, from, direction.ordinal());
    }

    native List<EMAMessage> nativeSearchMessages(int var1, long var2, int var4, String var5, int var6);

    native List<EMAMessage> nativeSearchMessages(String var1, long var2, int var4, String var5, int var6);

    public boolean removeMessagesBeforeTimestamp(long timeStamp) {
        return this.nativeRemoveMessagesBeforeTimestamp(timeStamp);
    }

    native boolean nativeRemoveMessagesBeforeTimestamp(long var1);

    public void reportMessage(String msgId, String reportTarget, String reportReason, EMAError error) {
        this.nativeReportMessage(msgId, reportTarget, reportReason, error);
    }

    native void nativeReportMessage(String var1, String var2, String var3, EMAError var4);

    public List<List<String>> fetchSupportLanguages(EMAError error) {
        return this.nativeFetchSupportLanguages(error);
    }

    native List<List<String>> nativeFetchSupportLanguages(EMAError var1);

    public EMAMessage translateMessage(EMAMessage msg, List<String> languages, EMAError error) {
        return this.nativeTranslateMessage(msg, languages, error);
    }

    native EMAMessage nativeTranslateMessage(EMAMessage var1, List<String> var2, EMAError var3);

    native EMAError nativeDeleteRoamMsgFromServerById(String var1, int var2, List<String> var3);

    native EMAError nativeDeleteRoamMsgFromServerByTime(String var1, int var2, long var3);

    public EMAMessage modifyMessage(String messageId, EMAMessageBody body, EMAError error) {
        return this.nativeModifyMessage(messageId, body, error);
    }

    native EMAMessage nativeModifyMessage(String var1, EMAMessageBody var2, EMAError var3);

    public CursorResult<EMAConversation> fetchPinnedConversationsFromServer(int limit, String cursor, EMAError error) {
        return this.nativeFetchPinnedConversationsFromServer(limit, cursor, error);
    }

    native CursorResult<EMAConversation> nativeFetchPinnedConversationsFromServer(int var1, String var2, EMAError var3);

    public CursorResult<EMAConversation> fetchConversationsFromServerWithCursor(int limit, String cursor, EMAError error) {
        return this.nativeFetchConversationsFromServerWithCursor(limit, cursor, error);
    }

    native CursorResult<EMAConversation> nativeFetchConversationsFromServerWithCursor(int var1, String var2, EMAError var3);

    public void pinConversation(String conversationId, boolean isPinned, EMAError error) {
        this.nativePinConversation(conversationId, isPinned, error);
    }

    native void nativePinConversation(String var1, boolean var2, EMAError var3);

    public List<EMAConversation> getAllConversationsBySort() {
        return this.nativeGetAllConversationsBySort();
    }

    native List<EMAConversation> nativeGetAllConversationsBySort();

    public List<EMAMessage> downloadCombineMessages(EMAMessage message, EMAError error) {
        return this.nativeDownloadCombineMessages(message, error);
    }

    native List<EMAMessage> nativeDownloadCombineMessages(EMAMessage var1, EMAError var2);
}

