/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import io.agora.chat.FileMessageBody;
import io.agora.chat.adapter.message.EMAVoiceMessageBody;
import io.agora.util.EMLog;
import io.agora.util.FileHelper;
import java.io.File;

public class VoiceMessageBody
extends FileMessageBody
implements Parcelable {
    public static final Parcelable.Creator<VoiceMessageBody> CREATOR = new Parcelable.Creator<VoiceMessageBody>(){

        public VoiceMessageBody createFromParcel(Parcel in) {
            return new VoiceMessageBody(in);
        }

        public VoiceMessageBody[] newArray(int size) {
            return new VoiceMessageBody[size];
        }
    };

    public VoiceMessageBody(File voiceFile, int duration) {
        this(Uri.fromFile((File)voiceFile), duration);
    }

    public VoiceMessageBody(Uri voiceFile, int duration) {
        super(voiceFile, 4);
        ((EMAVoiceMessageBody)this.emaObject).setDuration(duration);
        ((EMAVoiceMessageBody)this.emaObject).setDisplayName(FileHelper.getInstance().getFilename(voiceFile));
        EMLog.d("voicemsg", "create voice, message body for:" + voiceFile);
    }

    public VoiceMessageBody(EMAVoiceMessageBody body) {
        super(body);
    }

    VoiceMessageBody(String fileName, String remoteUrl, int length) {
        super(fileName, 4);
        ((EMAVoiceMessageBody)this.emaObject).setLocalPath(fileName);
        ((EMAVoiceMessageBody)this.emaObject).setRemotePath(remoteUrl);
        ((EMAVoiceMessageBody)this.emaObject).setDuration(length);
    }

    public int getLength() {
        return ((EMAVoiceMessageBody)this.emaObject).duration();
    }

    public long getFileSize() {
        return ((EMAVoiceMessageBody)this.emaObject).fileLength();
    }

    public String toString() {
        return "voice:" + ((EMAVoiceMessageBody)this.emaObject).displayName() + ",localurl:" + ((EMAVoiceMessageBody)this.emaObject).getLocalUrl() + ",remoteurl:" + ((EMAVoiceMessageBody)this.emaObject).getRemoteUrl() + ",length:" + ((EMAVoiceMessageBody)this.emaObject).duration();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(((EMAVoiceMessageBody)this.emaObject).displayName());
        dest.writeString(((EMAVoiceMessageBody)this.emaObject).getLocalUrl());
        dest.writeString(((EMAVoiceMessageBody)this.emaObject).getRemoteUrl());
        dest.writeInt(((EMAVoiceMessageBody)this.emaObject).duration());
    }

    private VoiceMessageBody(Parcel in) {
        super("", 4);
        ((EMAVoiceMessageBody)this.emaObject).setDisplayName(in.readString());
        ((EMAVoiceMessageBody)this.emaObject).setLocalPath(in.readString());
        ((EMAVoiceMessageBody)this.emaObject).setRemotePath(in.readString());
        ((EMAVoiceMessageBody)this.emaObject).setDuration(in.readInt());
    }
}

