/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat;

import android.os.AsyncTask;
import io.agora.ValueCallBack;
import io.agora.chat.CacheManager;
import io.agora.chat.ChatClient;
import io.agora.chat.Language;
import io.agora.chat.TranslateParams;
import io.agora.chat.TranslationResult;
import io.agora.chat.Translator;
import io.agora.chat.adapter.EMATranslateManager;
import io.agora.chat.adapter.EMATranslateResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

@Deprecated
public class TranslationManager {
    private static final String TAG = TranslationManager.class.getSimpleName();
    public static final int MaxTranslationTextSize = 5000;
    private static TranslationManager instance = null;
    private Translator mTranslator;
    private AtomicBoolean mInitializing = new AtomicBoolean(false);
    private AtomicBoolean mInitialized = new AtomicBoolean(false);
    private List<Language> mLanguageList;
    EMATranslateManager emaObject;
    static final int MaxCacheSize = 10000;
    private CacheManager mCacheManager;

    TranslationManager(EMATranslateManager translateManager) {
        this.emaObject = translateManager;
        this.mLanguageList = new ArrayList<Language>();
        this.mCacheManager = new CacheManager(10000);
    }

    public void init(final TranslateParams params) {
        if (!ChatClient.getInstance().isLoggedInBefore()) {
            return;
        }
        if (this.mInitializing.compareAndSet(false, true)) {
            AsyncTask.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    TranslationManager.this.cleanCache();
                    TranslationManager.this.loadIds(params.LoadCount);
                    TranslationManager.this.mInitialized.set(true);
                    TranslationManager.this.mTranslator = new Translator(params);
                    TranslationManager.this.mLanguageList = TranslationManager.this.mTranslator.getSupportedLanguages();
                }
            });
        }
    }

    public boolean isInitialized() {
        return this.mInitialized.get();
    }

    public List<Language> getSupportedLanguages() {
        if (!this.mInitialized.get()) {
            return new ArrayList<Language>();
        }
        return this.mLanguageList;
    }

    public void translate(String messageId, String conversationId, String messageText, String targetLanguageCode, ValueCallBack<TranslationResult> callback) {
        TranslationResult translationResult;
        if (!this.mInitializing.get()) {
            callback.onError(905, "TranslationManager is not initialized");
            return;
        }
        if (messageText.length() > 5000) {
            callback.onError(903, "Text exceeds limit");
            return;
        }
        if (this.isTranslationResultForMessage(messageId)) {
            translationResult = this.getTranslationResult(messageId);
        } else {
            translationResult = new TranslationResult(messageId);
            translationResult.setConversationId(conversationId);
        }
        this.mTranslator.translate(messageText, targetLanguageCode, (TranslationText, ErrorText) -> {
            if (!TranslationText.isEmpty()) {
                translationResult.setShowTranslation(true);
                translationResult.setTranslatedText(TranslationText);
                translationResult.setTranslateCount(translationResult.translateCount() + 1);
                this.updateTranslationResult(translationResult);
                callback.onSuccess(translationResult);
            } else {
                callback.onError(904, ErrorText);
            }
        });
    }

    public void removeTranslationResult(String messageId) {
        this.removeTranslationResults(Arrays.asList(messageId));
    }

    public void removeTranslationResults(List<String> messageIds) {
        if (!this.mInitializing.get()) {
            return;
        }
        this.deleteTranslationResults(messageIds);
    }

    public void clearTranslations() {
        if (!this.mInitializing.get()) {
            return;
        }
        this.deleteAll();
    }

    public void removeResultsByConversationId(String conversationId) {
        if (!this.mInitializing.get()) {
            return;
        }
        this.removeTranslationsByConversationId(conversationId);
        this.mCacheManager.removeByConversationId(conversationId);
    }

    public TranslationResult getTranslationResult(String messageId) {
        if (!this.mInitializing.get()) {
            return null;
        }
        if (!this.mCacheManager.check(messageId)) {
            return null;
        }
        if (this.mCacheManager.get(messageId) != null) {
            return this.mCacheManager.get(messageId);
        }
        TranslationResult translationResult = this.getTranslationResultByMsgId(messageId);
        return translationResult;
    }

    public boolean isTranslationResultForMessage(String messageId) {
        if (!this.mInitialized.get()) {
            return false;
        }
        return this.isMessageResult(messageId);
    }

    public void logout() {
        if (!this.mInitialized.get()) {
            return;
        }
        this.mInitializing.set(false);
        this.mInitialized.set(false);
        this.cleanCache();
        this.mLanguageList.clear();
    }

    private void loadIds(int loadCount) {
        List<TranslationResult> list = this.loadTranslateResults(loadCount);
        if (list.size() > 0) {
            for (TranslationResult translationResult : list) {
                this.mCacheManager.add(translationResult);
            }
        }
    }

    public void updateTranslationResult(TranslationResult result) {
        String string = result.msgId();
        if (this.mCacheManager.check(string)) {
            this.removeTranslationResult(string);
        }
        this.mCacheManager.add(result);
        this.updateTranslate(result);
    }

    private void deleteTranslationResults(List<String> messageIds) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : messageIds) {
            if (!this.mCacheManager.check(string)) continue;
            arrayList.add(string);
        }
        this.removeTranslationsByMsgId(arrayList);
        this.mCacheManager.removeByMsgIds(arrayList);
    }

    private void deleteAll() {
        this.removeAllTranslations();
        this.mCacheManager.clear();
    }

    private boolean isMessageResult(String messageId) {
        return this.mCacheManager.check(messageId);
    }

    private void cleanCache() {
        this.mCacheManager.clear();
    }

    private boolean updateTranslate(TranslationResult result) {
        return this.emaObject.updateTranslation((EMATranslateResult)result.emaObject);
    }

    private TranslationResult getTranslationResultByMsgId(String msgId) {
        EMATranslateResult eMATranslateResult = this.emaObject.getTranslationResultByMsgId(msgId);
        if (eMATranslateResult == null) {
            return new TranslationResult(msgId);
        }
        return new TranslationResult(eMATranslateResult);
    }

    private List<TranslationResult> loadTranslateResults(int count) {
        List<EMATranslateResult> list = this.emaObject.loadTranslateResults(count);
        ArrayList<TranslationResult> arrayList = new ArrayList<TranslationResult>();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                EMATranslateResult eMATranslateResult = list.get(i);
                TranslationResult translationResult = new TranslationResult(eMATranslateResult);
                arrayList.add(translationResult);
            }
            return arrayList;
        }
        return arrayList;
    }

    private boolean removeTranslationsByMsgId(List<String> msgIds) {
        return this.emaObject.removeTranslationsByMsgId(msgIds);
    }

    private boolean removeTranslationsByConversationId(String conversationId) {
        return this.emaObject.removeTranslationsByConversationId(conversationId);
    }

    private boolean removeAllTranslations() {
        return this.emaObject.removeAllTranslations();
    }
}

