/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat;

import android.text.TextUtils;
import android.util.Pair;
import io.agora.CallBack;
import io.agora.ValueCallBack;
import io.agora.chat.ChatClient;
import io.agora.chat.Conversation;
import io.agora.chat.PushConfigs;
import io.agora.chat.SilentModeParam;
import io.agora.chat.SilentModeResult;
import io.agora.chat.adapter.EMAError;
import io.agora.chat.adapter.EMAPushConfigs;
import io.agora.chat.adapter.EMAPushManager;
import io.agora.chat.adapter.EMASilentModeItem;
import io.agora.chat.adapter.EMASilentModeParam;
import io.agora.chat.core.a;
import io.agora.cloud.EMHttpClient;
import io.agora.exceptions.ChatException;
import io.agora.util.DeviceUuidFactory;
import io.agora.util.EMLog;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class PushManager {
    private static final String TAG = PushManager.class.getSimpleName();
    ChatClient mClient;
    EMAPushManager emaObject;

    PushManager(ChatClient client, EMAPushManager pushManager) {
        this.emaObject = pushManager;
        this.mClient = client;
    }

    @Deprecated
    public void enableOfflinePush() throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.enableOfflineNotification(eMAError);
        this.handleError(eMAError);
    }

    @Deprecated
    public void disableOfflinePush(int start, int end) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.disableOfflineNotification(start, end, eMAError);
        this.handleError(eMAError);
    }

    public PushConfigs getPushConfigs() {
        EMAPushConfigs eMAPushConfigs = this.emaObject.getPushConfigs();
        if (eMAPushConfigs == null) {
            return null;
        }
        return new PushConfigs(eMAPushConfigs);
    }

    public PushConfigs getPushConfigsFromServer() throws ChatException {
        EMAError eMAError = new EMAError();
        EMAPushConfigs eMAPushConfigs = this.emaObject.getPushConfigsFromServer(eMAError);
        this.handleError(eMAError);
        return new PushConfigs(eMAPushConfigs);
    }

    @Deprecated
    public void updatePushServiceForGroup(List<String> groupIds, boolean noPush) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.updatePushServiceForGroup(groupIds, noPush, eMAError);
        this.handleError(eMAError);
    }

    @Deprecated
    public void updatePushServiceForUsers(List<String> userIds, boolean noPush) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.updatePushServiceForUsers(userIds, noPush, eMAError);
        this.handleError(eMAError);
    }

    @Deprecated
    public List<String> getNoPushGroups() {
        return this.emaObject.getNoPushGroups();
    }

    @Deprecated
    public List<String> getNoPushUsers() {
        return this.emaObject.getNoPushUsers();
    }

    public boolean updatePushNickname(String nickname) throws IllegalArgumentException, ChatException {
        if (TextUtils.isEmpty((CharSequence)nickname)) {
            throw new IllegalArgumentException("nick name is null or empty");
        }
        String string = ChatClient.getInstance().getCurrentUser();
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("currentUser is null or empty");
        }
        String string2 = ChatClient.getInstance().getAccessToken();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("token is null or empty");
        }
        EMAError eMAError = new EMAError();
        this.emaObject.updatePushNickname(nickname, eMAError);
        this.handleError(eMAError);
        return true;
    }

    public void asyncUpdatePushNickname(final String nickname, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    PushManager.this.updatePushNickname(nickname);
                    callback.onSuccess();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    callback.onError(205, illegalArgumentException.getMessage());
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void updatePushDisplayStyle(DisplayStyle style) throws IllegalArgumentException, ChatException {
        String string = ChatClient.getInstance().getCurrentUser();
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("currentUser is null or empty");
        }
        String string2 = ChatClient.getInstance().getAccessToken();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("token is null or empty");
        }
        EMAError eMAError = new EMAError();
        this.emaObject.updatePushDisplayStyle(style.ordinal(), eMAError);
        this.handleError(eMAError);
    }

    public void asyncUpdatePushDisplayStyle(final DisplayStyle style, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    PushManager.this.updatePushDisplayStyle(style);
                    callback.onSuccess();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    callback.onError(205, illegalArgumentException.getMessage());
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    private void reportPushAction(String parameters) throws IllegalArgumentException, ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.reportPushAction(parameters, eMAError);
        this.handleError(eMAError);
    }

    private void handleError(EMAError error) throws ChatException {
        if (error.errCode() != 0) {
            throw new ChatException(error);
        }
    }

    public void setSilentModeForConversation(final String conversationId, final Conversation.ConversationType type, final SilentModeParam param, final ValueCallBack<SilentModeResult> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMASilentModeItem eMASilentModeItem = PushManager.this.emaObject.setSilentModeForConversation(conversationId, type.ordinal(), (EMASilentModeParam)param.emaObject, eMAError);
                    PushManager.this.handleError(eMAError);
                    callBack.onSuccess(new SilentModeResult(eMASilentModeItem));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void clearRemindTypeForConversation(final String conversationId, final Conversation.ConversationType type, final CallBack callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    PushManager.this.emaObject.clearRemindTypeForConversation(conversationId, type.ordinal(), eMAError);
                    PushManager.this.handleError(eMAError);
                    callBack.onSuccess();
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void getSilentModeForConversation(final String conversationId, final Conversation.ConversationType type, final ValueCallBack<SilentModeResult> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMASilentModeItem eMASilentModeItem = PushManager.this.emaObject.getSilentModeForConversation(conversationId, type.ordinal(), eMAError);
                    PushManager.this.handleError(eMAError);
                    callBack.onSuccess(new SilentModeResult(eMASilentModeItem));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void setSilentModeForAll(final SilentModeParam param, final ValueCallBack<SilentModeResult> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMASilentModeItem eMASilentModeItem = PushManager.this.emaObject.setSilentModeForAll((EMASilentModeParam)param.emaObject, eMAError);
                    PushManager.this.handleError(eMAError);
                    callBack.onSuccess(new SilentModeResult(eMASilentModeItem));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void getSilentModeForAll(final ValueCallBack<SilentModeResult> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMASilentModeItem eMASilentModeItem = PushManager.this.emaObject.getSilentModeForAll(eMAError);
                    PushManager.this.handleError(eMAError);
                    callBack.onSuccess(new SilentModeResult(eMASilentModeItem));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void getSilentModeForConversations(final List<Conversation> conversationList, final ValueCallBack<Map<String, SilentModeResult>> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Object object2;
                    StringBuilder stringBuilder = new StringBuilder();
                    StringBuilder stringBuilder2 = new StringBuilder();
                    for (Object object2 : conversationList) {
                        if (((Conversation)object2).getType() == Conversation.ConversationType.Chat) {
                            if (!stringBuilder.toString().isEmpty()) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(((Conversation)object2).conversationId());
                            continue;
                        }
                        if (!stringBuilder2.toString().isEmpty()) {
                            stringBuilder2.append(",");
                        }
                        stringBuilder2.append(((Conversation)object2).conversationId());
                    }
                    HashMap hashMap = new HashMap();
                    hashMap.put("user", stringBuilder.toString());
                    hashMap.put("group", stringBuilder2.toString());
                    object2 = new EMAError();
                    List<EMASilentModeItem> list = PushManager.this.emaObject.getSilentModeForConversations(hashMap, (EMAError)object2);
                    PushManager.this.handleError((EMAError)object2);
                    HashMap<String, SilentModeResult> hashMap2 = new HashMap<String, SilentModeResult>();
                    for (EMASilentModeItem eMASilentModeItem : list) {
                        hashMap2.put(eMASilentModeItem.getConversationId(), new SilentModeResult(eMASilentModeItem));
                    }
                    callBack.onSuccess(hashMap2);
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void setPreferredNotificationLanguage(final String languageCode, final CallBack callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    PushManager.this.emaObject.setPushPerformLanguage(languageCode, eMAError);
                    PushManager.this.handleError(eMAError);
                    callBack.onSuccess();
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void getPreferredNotificationLanguage(final ValueCallBack<String> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    String string = PushManager.this.emaObject.getPushPerformLanguage(eMAError);
                    PushManager.this.handleError(eMAError);
                    callBack.onSuccess(string);
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public synchronized void bindDeviceToken(String notifierName, String deviceToken, CallBack callBack) {
        if (this.mClient == null || !this.mClient.isSdkInited()) {
            if (callBack != null) {
                callBack.onError(1, "SDK should init first!");
            }
            return;
        }
        this.mClient.execute(() -> {
            block3: {
                try {
                    this.bindDeviceToken(notifierName, deviceToken);
                    if (callBack != null) {
                        callBack.onSuccess();
                    }
                }
                catch (ChatException chatException) {
                    if (callBack == null) break block3;
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    void unBindDeviceToken() throws ChatException {
        this.bindDeviceToken(a.a().r(), "");
    }

    synchronized void bindDeviceToken(String notifierName, String deviceToken) throws ChatException {
        if (this.mClient == null || !this.mClient.isSdkInited()) {
            throw new ChatException(1, "SDK should init first!");
        }
        if (!this.mClient.isLoggedInBefore()) {
            throw new ChatException(1, "You need to log in first!");
        }
        if (TextUtils.isEmpty((CharSequence)notifierName)) {
            throw new ChatException(110, "Notifier name should not be empty!");
        }
        a a2 = a.a();
        String string = a2.q();
        if (!TextUtils.isEmpty((CharSequence)string) && TextUtils.equals((CharSequence)string, (CharSequence)deviceToken)) {
            if (!ChatClient.getInstance().getChatConfigPrivate().J()) {
                EMLog.e(TAG, TAG + " not first login, ignore token upload action.");
                return;
            }
            EMLog.d(TAG, "push token not change, but last login is not on this device, upload to server");
        }
        String string2 = ChatClient.getInstance().getChatConfigPrivate().a(true, false) + "/users/" + ChatClient.getInstance().getCurrentUser() + "/push/binding";
        DeviceUuidFactory deviceUuidFactory = new DeviceUuidFactory(ChatClient.getInstance().getContext());
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("device_token", (Object)(TextUtils.isEmpty((CharSequence)notifierName) ? "" : deviceToken));
            jSONObject.put("notifier_name", (Object)notifierName);
            jSONObject.put("device_id", (Object)deviceUuidFactory.getDeviceUuid().toString());
        }
        catch (Exception exception) {
            EMLog.e(TAG, "uploadTokenInternal put json exception: " + exception.toString());
            throw new ChatException(1, "uploadTokenInternal put json exception: " + exception.getMessage());
        }
        int n = 2;
        int n2 = 1;
        String string3 = "";
        do {
            try {
                EMLog.e(TAG, "uploadTokenInternal, token=" + deviceToken + ", url=" + string2 + ", notifier name=" + notifierName);
                Pair<Integer, String> pair = EMHttpClient.getInstance().sendRequestWithToken(string2, jSONObject.toString(), EMHttpClient.PUT);
                n2 = (Integer)pair.first;
                string3 = (String)pair.second;
                if (n2 == 200) {
                    a.a().h(deviceToken);
                    a.a().i(notifierName);
                    EMLog.e(TAG, "uploadTokenInternal success.");
                    return;
                }
                EMLog.e(TAG, "uploadTokenInternal failed: " + string3);
                string2 = ChatClient.getInstance().getChatConfigPrivate().a(true, true) + "/users/" + ChatClient.getInstance().getCurrentUser();
            }
            catch (ChatException chatException) {
                EMLog.e(TAG, "uploadTokenInternal failed: " + chatException.getDescription());
                string2 = ChatClient.getInstance().getChatConfigPrivate().a(true, true) + "/users/" + ChatClient.getInstance().getCurrentUser();
            }
        } while (--n > 0);
        throw new ChatException(n2, string3);
    }

    public void setPushTemplate(final String templateName, final CallBack callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    PushManager.this.emaObject.setPushTemplate(templateName, eMAError);
                    PushManager.this.handleError(eMAError);
                    callBack.onSuccess();
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void getPushTemplate(final ValueCallBack<String> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    String string = PushManager.this.emaObject.getPushTemplate(eMAError);
                    PushManager.this.handleError(eMAError);
                    callBack.onSuccess(string);
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void reportPushAction(final JSONObject json, final EMPushAction action, final CallBack callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (json != null) {
                        json.put("action", (Object)action.name);
                        PushManager.this.reportPushAction(json.toString());
                    }
                    callBack.onSuccess();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    callBack.onError(205, illegalArgumentException.getMessage());
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
        });
    }

    public static enum PushRemindType {
        ALL,
        MENTION_ONLY,
        NONE;

    }

    public static enum EMPushAction {
        ARRIVE("arrive"),
        CLICK("click");

        private String name;

        private EMPushAction(String name) {
            this.name = name;
        }
    }

    public static enum DisplayStyle {
        SimpleBanner,
        MessageSummary;

    }
}

