/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import io.agora.chat.FileMessageBody;
import io.agora.chat.adapter.message.EMAFileMessageBody;
import io.agora.util.EMLog;
import io.agora.util.FileHelper;
import java.io.File;

public class NormalFileMessageBody
extends FileMessageBody
implements Parcelable {
    public static final Parcelable.Creator<NormalFileMessageBody> CREATOR = new Parcelable.Creator<NormalFileMessageBody>(){

        public NormalFileMessageBody createFromParcel(Parcel in) {
            return new NormalFileMessageBody(in);
        }

        public NormalFileMessageBody[] newArray(int size) {
            return new NormalFileMessageBody[size];
        }
    };

    public NormalFileMessageBody(File file) {
        this(Uri.fromFile((File)file));
    }

    public NormalFileMessageBody(Uri localPath) {
        super(localPath);
        ((EMAFileMessageBody)this.emaObject).setDisplayName(FileHelper.getInstance().getFilename(localPath));
    }

    NormalFileMessageBody(String fileName, String remoteUrl) {
        super(fileName);
        super.setRemoteUrl(remoteUrl);
        EMLog.d("NormalFileMessageBody", "filename = " + fileName);
    }

    NormalFileMessageBody(EMAFileMessageBody body) {
        super(body);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(((EMAFileMessageBody)this.emaObject).displayName());
        dest.writeString(((EMAFileMessageBody)this.emaObject).getLocalUrl());
        dest.writeString(((EMAFileMessageBody)this.emaObject).getRemoteUrl());
        dest.writeLong(((EMAFileMessageBody)this.emaObject).fileLength());
        dest.writeString(((EMAFileMessageBody)this.emaObject).getSecret());
    }

    public NormalFileMessageBody() {
        super("");
    }

    private NormalFileMessageBody(Parcel in) {
        super("");
        ((EMAFileMessageBody)this.emaObject).setDisplayName(in.readString());
        ((EMAFileMessageBody)this.emaObject).setLocalPath(in.readString());
        ((EMAFileMessageBody)this.emaObject).setRemotePath(in.readString());
        ((EMAFileMessageBody)this.emaObject).setFileLength(in.readLong());
        ((EMAFileMessageBody)this.emaObject).setSecretKey(in.readString());
    }

    public String toString() {
        return "normal file:" + ((EMAFileMessageBody)this.emaObject).displayName() + ",localUrl:" + ((EMAFileMessageBody)this.emaObject).getLocalUrl() + ",remoteUrl:" + ((EMAFileMessageBody)this.emaObject).getRemoteUrl() + ",file size:" + ((EMAFileMessageBody)this.emaObject).fileLength();
    }

    public long getFileSize() {
        return ((EMAFileMessageBody)this.emaObject).fileLength();
    }
}

