/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat;

import io.agora.CallBack;
import io.agora.GroupChangeListener;
import io.agora.ValueCallBack;
import io.agora.chat.ChatClient;
import io.agora.chat.CursorResult;
import io.agora.chat.Group;
import io.agora.chat.GroupInfo;
import io.agora.chat.GroupOptions;
import io.agora.chat.MucSharedFile;
import io.agora.chat.adapter.EMACallback;
import io.agora.chat.adapter.EMAError;
import io.agora.chat.adapter.EMAGroup;
import io.agora.chat.adapter.EMAGroupManager;
import io.agora.chat.adapter.EMAGroupManagerListener;
import io.agora.chat.adapter.EMAGroupSetting;
import io.agora.chat.adapter.EMAMucShareFile;
import io.agora.exceptions.ChatException;
import io.agora.util.EMLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class GroupManager {
    EMAGroupManager emaObject;
    private static String TAG = "group";
    List<GroupChangeListener> groupChangeListeners;
    EMAGroupManagerListener listenerImpl = new EMAGroupManagerListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceiveInviteFromGroup(String groupId, String groupName, String inviter, String inviteMessage) {
            List<GroupChangeListener> list = GroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (GroupChangeListener groupChangeListener : GroupManager.this.groupChangeListeners) {
                        groupChangeListener.onInvitationReceived(groupId, groupName, inviter, inviteMessage);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceiveInviteAcceptionFromGroup(EMAGroup group, String invitee) {
            List<GroupChangeListener> list = GroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (GroupChangeListener groupChangeListener : GroupManager.this.groupChangeListeners) {
                        groupChangeListener.onInvitationAccepted(group.groupId(), invitee, "");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceiveInviteDeclineFromGroup(EMAGroup group, String invitee, String reason) {
            List<GroupChangeListener> list = GroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (GroupChangeListener groupChangeListener : GroupManager.this.groupChangeListeners) {
                        groupChangeListener.onInvitationDeclined(group.groupId(), invitee, "");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAutoAcceptInvitationFromGroup(EMAGroup group, String inviter, String inviteMessage) {
            List<GroupChangeListener> list = GroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (GroupChangeListener groupChangeListener : GroupManager.this.groupChangeListeners) {
                        groupChangeListener.onAutoAcceptInvitationFromGroup(group.groupId(), inviter, inviteMessage);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLeaveGroup(EMAGroup group, int reason) {
            ChatClient.getInstance().chatManager().caches.remove(group.groupId());
            List<GroupChangeListener> list = GroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (GroupChangeListener groupChangeListener : GroupManager.this.groupChangeListeners) {
                        if (reason == EMAGroup.GroupLeaveReason.BE_KICKED.ordinal()) {
                            groupChangeListener.onUserRemoved(group.groupId(), group.groupSubject());
                            continue;
                        }
                        groupChangeListener.onGroupDestroyed(group.groupId(), group.groupSubject());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceiveJoinGroupApplication(EMAGroup group, String from, String message) {
            List<GroupChangeListener> list = GroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (GroupChangeListener groupChangeListener : GroupManager.this.groupChangeListeners) {
                        groupChangeListener.onRequestToJoinReceived(group.groupId(), group.groupSubject(), from, message);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceiveAcceptionFromGroup(EMAGroup group) {
            List<GroupChangeListener> list = GroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (GroupChangeListener groupChangeListener : GroupManager.this.groupChangeListeners) {
                        groupChangeListener.onRequestToJoinAccepted(group.groupId(), group.groupSubject(), group.getOwner());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceiveRejectionFromGroup(String groupId, String reason) {
            Group group = GroupManager.this.getGroup(groupId);
            String string = group == null ? "" : group.groupSubject();
            String string2 = group == null ? "" : group.getOwner();
            List<GroupChangeListener> list = GroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (GroupChangeListener groupChangeListener : GroupManager.this.groupChangeListeners) {
                        groupChangeListener.onRequestToJoinDeclined(groupId, string, string2, reason);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        @Override
        public void onUpdateMyGroupList(List<EMAGroup> groups) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAddMutesFromGroup(EMAGroup group, List<String> muteMembers, long muteExpire) {
            List<GroupChangeListener> list = GroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (GroupChangeListener groupChangeListener : GroupManager.this.groupChangeListeners) {
                        groupChangeListener.onMuteListAdded(group.groupId(), muteMembers, muteExpire);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoveMutesFromGroup(EMAGroup group, List<String> banPostList) {
            List<GroupChangeListener> list = GroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (GroupChangeListener groupChangeListener : GroupManager.this.groupChangeListeners) {
                        groupChangeListener.onMuteListRemoved(group.groupId(), banPostList);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWhiteListAdded(EMAGroup group, List<String> members) {
            List<GroupChangeListener> list = GroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (GroupChangeListener groupChangeListener : GroupManager.this.groupChangeListeners) {
                        groupChangeListener.onWhiteListAdded(group.groupId(), members);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWhiteListRemoved(EMAGroup group, List<String> members) {
            List<GroupChangeListener> list = GroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (GroupChangeListener groupChangeListener : GroupManager.this.groupChangeListeners) {
                        groupChangeListener.onWhiteListRemoved(group.groupId(), members);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAllMemberMuteStateChanged(EMAGroup group, boolean isMuted) {
            List<GroupChangeListener> list = GroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (GroupChangeListener groupChangeListener : GroupManager.this.groupChangeListeners) {
                        groupChangeListener.onAllMemberMuteStateChanged(group.groupId(), isMuted);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAddAdminFromGroup(EMAGroup group, String admin) {
            List<GroupChangeListener> list = GroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (GroupChangeListener groupChangeListener : GroupManager.this.groupChangeListeners) {
                        groupChangeListener.onAdminAdded(group.groupId(), admin);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoveAdminFromGroup(EMAGroup group, String admin) {
            List<GroupChangeListener> list = GroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (GroupChangeListener groupChangeListener : GroupManager.this.groupChangeListeners) {
                        groupChangeListener.onAdminRemoved(group.groupId(), admin);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAssignOwnerFromGroup(EMAGroup group, String newOwner, String oldOwner) {
            List<GroupChangeListener> list = GroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (GroupChangeListener groupChangeListener : GroupManager.this.groupChangeListeners) {
                        groupChangeListener.onOwnerChanged(group.groupId(), newOwner, oldOwner);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMemberJoined(EMAGroup group, String member) {
            List<GroupChangeListener> list = GroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (GroupChangeListener groupChangeListener : GroupManager.this.groupChangeListeners) {
                        groupChangeListener.onMemberJoined(group.groupId(), member);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMemberExited(EMAGroup group, String member) {
            List<GroupChangeListener> list = GroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (GroupChangeListener groupChangeListener : GroupManager.this.groupChangeListeners) {
                        groupChangeListener.onMemberExited(group.groupId(), member);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAnnouncementChanged(EMAGroup group, String announcement) {
            List<GroupChangeListener> list = GroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (GroupChangeListener groupChangeListener : GroupManager.this.groupChangeListeners) {
                        groupChangeListener.onAnnouncementChanged(group.groupId(), announcement);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUploadShareFileFromGroup(EMAGroup group, EMAMucShareFile shareFile) {
            List<GroupChangeListener> list = GroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (GroupChangeListener groupChangeListener : GroupManager.this.groupChangeListeners) {
                        groupChangeListener.onSharedFileAdded(group.groupId(), new MucSharedFile(shareFile));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDeleteShareFileFromGroup(EMAGroup group, String fileId) {
            List<GroupChangeListener> list = GroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (GroupChangeListener groupChangeListener : GroupManager.this.groupChangeListeners) {
                        groupChangeListener.onSharedFileDeleted(group.groupId(), fileId);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUpdateSpecificationFromGroup(EMAGroup group) {
            List<GroupChangeListener> list = GroupManager.this.groupChangeListeners;
            synchronized (list) {
                for (GroupChangeListener groupChangeListener : GroupManager.this.groupChangeListeners) {
                    try {
                        if (null == group) continue;
                        groupChangeListener.onSpecificationChanged(new Group(group));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStateChangedFromGroup(EMAGroup group, boolean isDisabled) {
            List<GroupChangeListener> list = GroupManager.this.groupChangeListeners;
            synchronized (list) {
                for (GroupChangeListener groupChangeListener : GroupManager.this.groupChangeListeners) {
                    try {
                        groupChangeListener.onStateChanged(new Group(group), isDisabled);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onGroupMemberAttributeChanged(String groupId, String userId, Map<String, String> attributeMap, String from) {
            List<GroupChangeListener> list = GroupManager.this.groupChangeListeners;
            synchronized (list) {
                if (null != attributeMap && attributeMap.size() > 0) {
                    for (GroupChangeListener groupChangeListener : GroupManager.this.groupChangeListeners) {
                        try {
                            groupChangeListener.onGroupMemberAttributeChanged(groupId, userId, attributeMap, from);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }
        }
    };
    ChatClient mClient;

    GroupManager(ChatClient client, EMAGroupManager groupManager) {
        this.emaObject = groupManager;
        this.mClient = client;
        this.groupChangeListeners = Collections.synchronizedList(new ArrayList());
        this.emaObject.addListener(this.listenerImpl);
        ChatClient.getInstance().chatManager();
    }

    public List<Group> getAllGroups() {
        EMAError eMAError = new EMAError();
        List<EMAGroup> list = this.emaObject.allMyGroups(eMAError);
        ArrayList<Group> arrayList = new ArrayList<Group>();
        for (EMAGroup eMAGroup : list) {
            arrayList.add(new Group(eMAGroup));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Group getGroup(String groupId) {
        EMAError eMAError = new EMAError();
        List<EMAGroup> list = this.emaObject.allMyGroups(eMAError);
        for (EMAGroup eMAGroup : list) {
            if (!eMAGroup.groupId().equals(groupId)) continue;
            return new Group(eMAGroup);
        }
        return null;
    }

    public Group createGroup(String groupName, String desc, String[] allMembers, String reason, GroupOptions option) throws ChatException {
        int n = 0;
        switch (option.style) {
            case GroupStylePrivateOnlyOwnerInvite: {
                n = 0;
                break;
            }
            case GroupStylePrivateMemberCanInvite: {
                n = 1;
                break;
            }
            case GroupStylePublicJoinNeedApproval: {
                n = 2;
                break;
            }
            case GroupStylePublicOpenJoin: {
                n = 3;
            }
        }
        return this.createGroup(n, groupName, desc, allMembers, option.maxUsers, reason, option.inviteNeedConfirm, option.extField);
    }

    public void asyncCreateGroup(final String groupName, final String desc, final String[] allMembers, final String reason, final GroupOptions option, final ValueCallBack<Group> callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Group group = GroupManager.this.createGroup(groupName, desc, allMembers, reason, option);
                    callback.onSuccess(group);
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    private Group createGroup(int style, String groupName, String desc, String[] allMembers, int maxUsers, String reason, boolean inviteNeedConfirm, String extension) throws ChatException {
        EMAGroupSetting eMAGroupSetting = new EMAGroupSetting(style, maxUsers, inviteNeedConfirm, extension);
        ArrayList<String> arrayList = new ArrayList<String>();
        Collections.addAll(arrayList, allMembers);
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.createGroup(groupName, desc, reason, eMAGroupSetting, arrayList, inviteNeedConfirm, eMAError);
        this.handleError(eMAError);
        return new Group(eMAGroup);
    }

    public synchronized void loadAllGroups() {
        this.emaObject.loadAllMyGroupsFromDB();
    }

    public void destroyGroup(String groupId) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.destroyGroup(groupId, eMAError);
        ChatClient.getInstance().chatManager().caches.remove(groupId);
        this.handleError(eMAError);
    }

    public void asyncDestroyGroup(final String groupId, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    GroupManager.this.destroyGroup(groupId);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void addUsersToGroup(String groupId, String[] newmembers) throws ChatException {
        this.addUsersToGroup(groupId, newmembers, "welcome");
    }

    public void addUsersToGroup(String groupId, String[] newmembers, String welcomeMessage) throws ChatException {
        EMAError eMAError = new EMAError();
        ArrayList<String> arrayList = new ArrayList<String>();
        Collections.addAll(arrayList, newmembers);
        this.emaObject.addGroupMembers(groupId, arrayList, welcomeMessage, eMAError);
        this.handleError(eMAError);
    }

    public void asyncAddUsersToGroup(final String groupId, final String[] newmembers, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    GroupManager.this.addUsersToGroup(groupId, newmembers);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void removeUserFromGroup(String groupId, String username) throws ChatException {
        ArrayList<String> arrayList = new ArrayList<String>();
        EMAError eMAError = new EMAError();
        arrayList.add(username);
        this.emaObject.removeGroupMembers(groupId, arrayList, eMAError);
        this.handleError(eMAError);
        this.emaObject.fetchGroupSpecification(groupId, eMAError, true);
        this.handleError(eMAError);
    }

    public void asyncRemoveUserFromGroup(final String groupId, final String username, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    GroupManager.this.removeUserFromGroup(groupId, username);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void removeUsersFromGroup(String groupId, List<String> members) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.removeGroupMembers(groupId, members, eMAError);
        this.handleError(eMAError);
        this.emaObject.fetchGroupSpecification(groupId, eMAError, true);
        this.handleError(eMAError);
    }

    public void asyncRemoveUsersFromGroup(final String groupId, final List<String> members, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    GroupManager.this.removeUsersFromGroup(groupId, members);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void leaveGroup(String groupId) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.leaveGroup(groupId, eMAError);
        ChatClient.getInstance().chatManager().caches.remove(groupId);
        this.handleError(eMAError);
    }

    public void asyncLeaveGroup(final String groupId, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    GroupManager.this.leaveGroup(groupId);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public Group getGroupFromServer(String groupId) throws ChatException {
        if (groupId == null || groupId.isEmpty()) {
            throw new ChatException(600, "group id is null or empty");
        }
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.fetchGroupSpecification(groupId, eMAError, false);
        this.handleError(eMAError);
        return new Group(eMAGroup);
    }

    public Group getGroupFromServer(String groupId, boolean fetchMembers) throws ChatException {
        if (groupId == null || groupId.isEmpty()) {
            throw new ChatException(600, "group id is null or empty");
        }
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.fetchGroupSpecification(groupId, eMAError, fetchMembers);
        this.handleError(eMAError);
        return new Group(eMAGroup);
    }

    public void asyncGetGroupFromServer(final String groupId, final ValueCallBack<Group> callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Group group = GroupManager.this.getGroupFromServer(groupId);
                    callback.onSuccess(group);
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    synchronized List<Group> getGroupsFromServer() throws ChatException {
        EMAError eMAError = new EMAError();
        List<EMAGroup> list = this.emaObject.fetchAllMyGroups(eMAError);
        this.handleError(eMAError);
        ArrayList<Group> arrayList = new ArrayList<Group>();
        for (EMAGroup eMAGroup : list) {
            arrayList.add(new Group(eMAGroup));
        }
        return arrayList;
    }

    synchronized List<Group> getGroupsFromServer(int pageIndex, int pageSize) throws ChatException {
        EMAError eMAError = new EMAError();
        List<EMAGroup> list = this.emaObject.fetchAllMyGroupsWithPage(pageIndex, pageSize, eMAError);
        this.handleError(eMAError);
        ArrayList<Group> arrayList = new ArrayList<Group>();
        for (EMAGroup eMAGroup : list) {
            arrayList.add(new Group(eMAGroup));
        }
        return arrayList;
    }

    synchronized List<Group> getGroupsFromServer(int pageIndex, int pageSize, boolean needMemberCount, boolean needRole) throws ChatException {
        EMAError eMAError = new EMAError();
        List<EMAGroup> list = this.emaObject.fetchAllMyGroupsWithPage(pageIndex, pageSize, needMemberCount, needRole, eMAError);
        this.handleError(eMAError);
        ArrayList<Group> arrayList = new ArrayList<Group>();
        for (EMAGroup eMAGroup : list) {
            arrayList.add(new Group(eMAGroup));
        }
        return arrayList;
    }

    void asyncGetGroupsFromServer(final ValueCallBack<List<Group>> callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<Group> list = GroupManager.this.getGroupsFromServer();
                    callback.onSuccess(list);
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public synchronized List<Group> getJoinedGroupsFromServer() throws ChatException {
        return this.getGroupsFromServer();
    }

    @Deprecated
    public synchronized List<Group> getJoinedGroupsFromServer(int pageIndex, int pageSize) throws ChatException {
        return this.getGroupsFromServer(pageIndex, pageSize);
    }

    public synchronized List<Group> getJoinedGroupsFromServer(int pageIndex, int pageSize, boolean needMemberCount, boolean needRole) throws ChatException {
        return this.getGroupsFromServer(pageIndex, pageSize, needMemberCount, needRole);
    }

    public void asyncGetJoinedGroupsFromServer(final ValueCallBack<List<Group>> callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<Group> list = GroupManager.this.getJoinedGroupsFromServer();
                    callback.onSuccess(list);
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    @Deprecated
    public void asyncGetJoinedGroupsFromServer(final int pageIndex, final int pageSize, final ValueCallBack<List<Group>> callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<Group> list = GroupManager.this.getJoinedGroupsFromServer(pageIndex, pageSize);
                    callback.onSuccess(list);
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void asyncGetJoinedGroupsFromServer(final int pageIndex, final int pageSize, final boolean needMemberCount, final boolean needRole, final ValueCallBack<List<Group>> callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<Group> list = GroupManager.this.getJoinedGroupsFromServer(pageIndex, pageSize, needMemberCount, needRole);
                    callback.onSuccess(list);
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public CursorResult<GroupInfo> getPublicGroupsFromServer(int pageSize, String cursor) throws ChatException {
        EMAError eMAError = new EMAError();
        CursorResult<GroupInfo> cursorResult = this.emaObject.fetchPublicGroupsWithCursor(cursor, pageSize, eMAError);
        this.handleError(eMAError);
        return cursorResult;
    }

    public void asyncGetPublicGroupsFromServer(final int pageSize, final String cursor, final ValueCallBack<CursorResult<GroupInfo>> callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    CursorResult<GroupInfo> cursorResult = GroupManager.this.getPublicGroupsFromServer(pageSize, cursor);
                    callback.onSuccess(cursorResult);
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void joinGroup(String groupId) throws ChatException {
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.fetchGroupSpecification(groupId, eMAError, false);
        this.handleError(eMAError);
        if (eMAGroup.groupSetting() == null) {
            throw new ChatException();
        }
        if (eMAGroup.groupSetting().style() == 3) {
            this.emaObject.joinPublicGroup(groupId, eMAError);
            this.handleError(eMAError);
            return;
        }
        if (eMAGroup.groupSetting().style() == 2) {
            this.emaObject.applyJoinPublicGroup(groupId, this.mClient.getCurrentUser(), "hello", eMAError);
            this.handleError(eMAError);
            return;
        }
    }

    public void asyncJoinGroup(final String groupId, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    GroupManager.this.joinGroup(groupId);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void changeGroupName(String groupId, String changedGroupName) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.changeGroupSubject(groupId, changedGroupName, eMAError);
        this.handleError(eMAError);
    }

    public void asyncChangeGroupName(final String groupId, final String changedGroupName, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    GroupManager.this.changeGroupName(groupId, changedGroupName);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void changeGroupDescription(String groupId, String changedDescription) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.changeGroupDescription(groupId, changedDescription, eMAError);
        this.handleError(eMAError);
    }

    public void asyncChangeGroupDescription(final String groupId, final String changedDescription, final CallBack callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    GroupManager.this.changeGroupDescription(groupId, changedDescription);
                    callBack.onSuccess();
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public Group acceptInvitation(String groupId, String inviter) throws ChatException {
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.acceptInvitationFromGroup(groupId, inviter == null ? "" : inviter, eMAError);
        this.handleError(eMAError);
        return new Group(eMAGroup);
    }

    public void asyncAcceptInvitation(final String groupId, final String inviter, final ValueCallBack<Group> callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Group group = GroupManager.this.acceptInvitation(groupId, inviter);
                    callback.onSuccess(group);
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void declineInvitation(String groupId, String inviter, String reason) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.declineInvitationFromGroup(groupId, inviter == null ? "" : inviter, reason == null ? "" : reason, eMAError);
        this.handleError(eMAError);
    }

    public void asyncDeclineInvitation(final String groupId, final String inviter, final String reason, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    GroupManager.this.declineInvitation(groupId, inviter, reason);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void acceptApplication(String username, String groupId) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.acceptJoinGroupApplication(groupId, username, eMAError);
        this.handleError(eMAError);
    }

    public void asyncAcceptApplication(final String username, final String groupId, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    GroupManager.this.acceptApplication(username, groupId);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void declineApplication(String username, String groupId, String reason) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.declineJoinGroupApplication(groupId, username, reason, eMAError);
        this.handleError(eMAError);
    }

    public void asyncDeclineApplication(final String username, final String groupId, final String reason, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    GroupManager.this.declineApplication(username, groupId, reason);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void inviteUser(String groupId, String[] beInvitedUsernames, String reason) throws ChatException {
        EMAError eMAError = new EMAError();
        ArrayList<String> arrayList = new ArrayList<String>();
        Collections.addAll(arrayList, beInvitedUsernames);
        this.emaObject.addGroupMembers(groupId, arrayList, reason, eMAError);
        this.handleError(eMAError);
    }

    public void asyncInviteUser(final String groupId, final String[] beInvitedUsernames, final String reason, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    GroupManager.this.inviteUser(groupId, beInvitedUsernames, reason);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void applyJoinToGroup(String groupId, String reason) throws ChatException {
        String string = this.mClient.getCurrentUser();
        EMAError eMAError = new EMAError();
        this.emaObject.applyJoinPublicGroup(groupId, string, reason, eMAError);
        this.handleError(eMAError);
    }

    public void asyncApplyJoinToGroup(final String groupId, final String reason, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    GroupManager.this.applyJoinToGroup(groupId, reason);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void blockGroupMessage(String groupId) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.blockGroupMessage(groupId, eMAError);
        this.handleError(eMAError);
    }

    public void asyncBlockGroupMessage(final String groupId, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    GroupManager.this.blockGroupMessage(groupId);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void unblockGroupMessage(String groupId) throws ChatException {
        EMLog.d(TAG, "try to unblock group msg:" + groupId);
        EMAError eMAError = new EMAError();
        this.emaObject.unblockGroupMessage(groupId, eMAError);
        this.handleError(eMAError);
    }

    public void asyncUnblockGroupMessage(final String groupId, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    GroupManager.this.unblockGroupMessage(groupId);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void blockUser(String groupId, String username) throws ChatException {
        EMLog.d(TAG, "block user for groupid:" + groupId + " username:" + username);
        EMAError eMAError = new EMAError();
        String string = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(username);
        this.emaObject.blockGroupMembers(groupId, arrayList, eMAError, string);
        this.handleError(eMAError);
    }

    public void asyncBlockUser(final String groupId, final String username, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    GroupManager.this.blockUser(groupId, username);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void blockUsers(String groupId, List<String> members) throws ChatException {
        EMLog.d(TAG, "block user for groupid:" + groupId + " members:" + members == null ? "" : members.toString());
        EMAError eMAError = new EMAError();
        String string = "";
        this.emaObject.blockGroupMembers(groupId, members, eMAError, string);
        this.handleError(eMAError);
    }

    public void asyncBlockUsers(final String groupId, final List<String> members, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    GroupManager.this.blockUsers(groupId, members);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void unblockUser(String groupId, String username) throws ChatException {
        EMLog.d(TAG, "unblock user groupid:" + groupId + " username:" + username);
        EMAError eMAError = new EMAError();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(username);
        this.emaObject.unblockGroupMembers(groupId, arrayList, eMAError);
        this.handleError(eMAError);
    }

    public void asyncUnblockUser(final String groupId, final String username, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    GroupManager.this.unblockUser(groupId, username);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void unblockUsers(String groupId, List<String> members) throws ChatException {
        EMLog.d(TAG, "unblock user groupid:" + groupId + " members:" + members == null ? "" : members.toString());
        EMAError eMAError = new EMAError();
        this.emaObject.unblockGroupMembers(groupId, members, eMAError);
        this.handleError(eMAError);
    }

    public void asyncUnblockUsers(final String groupId, final List<String> members, final CallBack callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    GroupManager.this.unblockUsers(groupId, members);
                    callback.onSuccess();
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public List<String> getBlockedUsers(String groupId) throws ChatException {
        return this.getBlockedUsers(groupId, 0, 200);
    }

    public List<String> getBlockedUsers(String groupId, int pageIndex, int pageSize) throws ChatException {
        EMLog.d(TAG, "get blocked users of the group: " + groupId);
        EMAError eMAError = new EMAError();
        List<String> list = this.emaObject.fetchGroupBlackList(groupId, pageIndex, pageSize, eMAError);
        this.handleError(eMAError);
        return list;
    }

    public void asyncGetBlockedUsers(String groupId, ValueCallBack<List<String>> callback) {
        this.asyncGetBlockedUsers(groupId, 0, 200, callback);
    }

    public void asyncGetBlockedUsers(final String groupId, final int pageIndex, final int pageSize, final ValueCallBack<List<String>> callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<String> list = GroupManager.this.getBlockedUsers(groupId, pageIndex, pageSize);
                    callback.onSuccess(list);
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void addGroupChangeListener(GroupChangeListener listener) {
        EMLog.d(TAG, "add group change listener:" + listener.getClass().getName());
        if (!this.groupChangeListeners.contains(listener)) {
            this.groupChangeListeners.add(listener);
        }
    }

    public void removeGroupChangeListener(GroupChangeListener listener) {
        if (listener != null) {
            EMLog.d(TAG, "remove group change listener:" + listener.getClass().getName());
            this.groupChangeListeners.remove(listener);
        }
    }

    public CursorResult<String> fetchGroupMembers(String groupId, String cursor, int pageSize) throws ChatException {
        EMAError eMAError = new EMAError();
        CursorResult<String> cursorResult = this.emaObject.fetchGroupMembers(groupId, cursor, pageSize, eMAError);
        this.handleError(eMAError);
        return cursorResult;
    }

    public void asyncFetchGroupMembers(final String groupId, final String cursor, final int pageSize, final ValueCallBack<CursorResult<String>> callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    CursorResult<String> cursorResult = GroupManager.this.fetchGroupMembers(groupId, cursor, pageSize);
                    callback.onSuccess(cursorResult);
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public Group changeOwner(String groupId, String newOwner) throws ChatException {
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.transferGroupOwner(groupId, newOwner, eMAError);
        this.handleError(eMAError);
        return new Group(eMAGroup);
    }

    public void asyncChangeOwner(final String groupId, final String newOwner, final ValueCallBack<Group> callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Group group = GroupManager.this.changeOwner(groupId, newOwner);
                    callback.onSuccess(group);
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public Group addGroupAdmin(String groupId, String admin) throws ChatException {
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.addGroupAdmin(groupId, admin, eMAError);
        this.handleError(eMAError);
        return new Group(eMAGroup);
    }

    public void asyncAddGroupAdmin(final String groupId, final String admin, final ValueCallBack<Group> callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.onSuccess(GroupManager.this.addGroupAdmin(groupId, admin));
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public Group removeGroupAdmin(String groupId, String admin) throws ChatException {
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.removeGroupAdmin(groupId, admin, eMAError);
        this.handleError(eMAError);
        return new Group(eMAGroup);
    }

    public void asyncRemoveGroupAdmin(final String groupId, final String admin, final ValueCallBack<Group> callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.onSuccess(GroupManager.this.removeGroupAdmin(groupId, admin));
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public Group muteGroupMembers(String groupId, List<String> muteMembers, long duration) throws ChatException {
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.muteGroupMembers(groupId, muteMembers, duration, eMAError);
        this.handleError(eMAError);
        return new Group(eMAGroup);
    }

    public void asyncMuteGroupMembers(final String groupId, final List<String> muteMembers, final long duration, final ValueCallBack<Group> callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.onSuccess(GroupManager.this.muteGroupMembers(groupId, muteMembers, duration));
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public Group unMuteGroupMembers(String groupId, List<String> members) throws ChatException {
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.unMuteGroupMembers(groupId, members, eMAError);
        this.handleError(eMAError);
        return new Group(eMAGroup);
    }

    public void asyncUnMuteGroupMembers(final String groupId, final List<String> members, final ValueCallBack<Group> callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.onSuccess(GroupManager.this.unMuteGroupMembers(groupId, members));
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public Map<String, Long> fetchGroupMuteList(String groupId, int pageNum, int pageSize) throws ChatException {
        EMAError eMAError = new EMAError();
        Map<String, Long> map = this.emaObject.fetchGroupMutes(groupId, pageNum, pageSize, eMAError);
        this.handleError(eMAError);
        return map;
    }

    public void asyncFetchGroupMuteList(final String groupId, final int pageNum, final int pageSize, final ValueCallBack<Map<String, Long>> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(GroupManager.this.fetchGroupMuteList(groupId, pageNum, pageSize));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    void asyncCheckIfInMuteList(final String groupId, final ValueCallBack<Boolean> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    Boolean bl = GroupManager.this.emaObject.checkIfBeMuted(groupId, eMAError);
                    GroupManager.this.handleError(eMAError);
                    callBack.onSuccess(bl);
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public List<String> fetchGroupBlackList(String groupId, int pageNum, int pageSize) throws ChatException {
        EMAError eMAError = new EMAError();
        List<String> list = this.emaObject.fetchGroupBlackList(groupId, pageNum, pageSize, eMAError);
        this.handleError(eMAError);
        return list;
    }

    public void asyncFetchGroupBlackList(final String groupId, final int pageNum, final int pageSize, final ValueCallBack<List<String>> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(GroupManager.this.fetchGroupBlackList(groupId, pageNum, pageSize));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void addToGroupWhiteList(final String groupId, final List<String> members, final CallBack callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    GroupManager.this.emaObject.addToWhiteList(groupId, members, eMAError);
                    GroupManager.this.handleError(eMAError);
                    callBack.onSuccess();
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void removeFromGroupWhiteList(final String groupId, final List<String> members, final CallBack callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    GroupManager.this.emaObject.removeFromWhiteList(groupId, members, eMAError);
                    GroupManager.this.handleError(eMAError);
                    callBack.onSuccess();
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void checkIfInGroupWhiteList(final String groupId, final ValueCallBack<Boolean> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    Boolean bl = GroupManager.this.emaObject.checkIfInWhiteList(groupId, eMAError);
                    GroupManager.this.handleError(eMAError);
                    callBack.onSuccess(bl);
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void fetchGroupWhiteList(final String groupId, final ValueCallBack<List<String>> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    List<String> list = GroupManager.this.emaObject.fetchGroupWhiteList(groupId, eMAError);
                    GroupManager.this.handleError(eMAError);
                    callBack.onSuccess(list);
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void muteAllMembers(final String groupId, final ValueCallBack<Group> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMAGroup eMAGroup = GroupManager.this.emaObject.muteAllMembers(groupId, eMAError);
                    GroupManager.this.handleError(eMAError);
                    callBack.onSuccess(new Group(eMAGroup));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void unmuteAllMembers(final String groupId, final ValueCallBack<Group> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMAGroup eMAGroup = GroupManager.this.emaObject.unmuteAllMembers(groupId, eMAError);
                    GroupManager.this.handleError(eMAError);
                    callBack.onSuccess(new Group(eMAGroup));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void updateGroupAnnouncement(String groupId, String announcement) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.updateGroupAnnouncement(groupId, announcement, eMAError);
        this.handleError(eMAError);
    }

    public void asyncUpdateGroupAnnouncement(final String groupId, final String announcement, final CallBack callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    GroupManager.this.updateGroupAnnouncement(groupId, announcement);
                    callBack.onSuccess();
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public String fetchGroupAnnouncement(String groupId) throws ChatException {
        EMAError eMAError = new EMAError();
        String string = this.emaObject.fetchGroupAnnouncement(groupId, eMAError);
        this.handleError(eMAError);
        return string;
    }

    public void asyncFetchGroupAnnouncement(final String groupId, final ValueCallBack<String> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(GroupManager.this.fetchGroupAnnouncement(groupId));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public MucSharedFile uploadGroupSharedFile(String groupId, String filePath, CallBack callBack) throws ChatException {
        EMAError eMAError = new EMAError();
        EMACallback eMACallback = new EMACallback(callBack);
        EMAMucShareFile eMAMucShareFile = this.emaObject.uploadGroupShareFile(groupId, filePath, eMACallback, eMAError);
        this.handleError(eMAError);
        callBack.onSuccess();
        return new MucSharedFile(eMAMucShareFile);
    }

    @Deprecated
    public void asyncUploadGroupSharedFile(final String groupId, final String filePath, final CallBack callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    MucSharedFile mucSharedFile = GroupManager.this.uploadGroupSharedFile(groupId, filePath, callBack);
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void asyncUploadGroupSharedFile(final String groupId, final String filePath, final ValueCallBack<MucSharedFile> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    MucSharedFile mucSharedFile = GroupManager.this.uploadGroupSharedFile(groupId, filePath, new CallBack(){

                        @Override
                        public void onSuccess() {
                        }

                        @Override
                        public void onError(int code, String error) {
                        }

                        @Override
                        public void onProgress(int progress, String status) {
                            callBack.onProgress(progress, status);
                        }
                    });
                    if (mucSharedFile != null) {
                        callBack.onSuccess(mucSharedFile);
                    }
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public List<MucSharedFile> fetchGroupSharedFileList(String groupId, int pageNum, int pageSize) throws ChatException {
        EMAError eMAError = new EMAError();
        List<EMAMucShareFile> list = this.emaObject.fetchGroupShareFiles(groupId, pageNum, pageSize, eMAError);
        this.handleError(eMAError);
        ArrayList<MucSharedFile> arrayList = new ArrayList<MucSharedFile>();
        for (EMAMucShareFile eMAMucShareFile : list) {
            arrayList.add(new MucSharedFile(eMAMucShareFile));
        }
        return arrayList;
    }

    public void asyncFetchGroupSharedFileList(final String groupId, final int pageNum, final int pageSize, final ValueCallBack<List<MucSharedFile>> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(GroupManager.this.fetchGroupSharedFileList(groupId, pageNum, pageSize));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void deleteGroupSharedFile(String groupId, String fileId) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.deleteGroupShareFile(groupId, fileId, eMAError);
        this.handleError(eMAError);
    }

    public void asyncDeleteGroupSharedFile(final String groupId, final String fileId, final CallBack callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    GroupManager.this.deleteGroupSharedFile(groupId, fileId);
                    callBack.onSuccess();
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void downloadGroupSharedFile(String groupId, String fileId, String savePath, CallBack callBack) throws ChatException {
        EMAError eMAError = new EMAError();
        EMACallback eMACallback = new EMACallback(callBack);
        this.emaObject.downloadGroupShareFile(groupId, fileId, savePath, eMACallback, eMAError);
        this.handleError(eMAError);
        callBack.onSuccess();
    }

    public void asyncDownloadGroupSharedFile(final String groupId, final String fileId, final String savePath, final CallBack callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    GroupManager.this.downloadGroupSharedFile(groupId, fileId, savePath, callBack);
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    protected void setMemberAttributes(String groupId, String userId, Map<String, String> attributeMap) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.setMemberAttributes(groupId, userId, attributeMap, eMAError);
        this.handleError(eMAError);
    }

    public void asyncSetGroupMemberAttributes(String groupId, String userId, Map<String, String> attributeMap, CallBack callBack) {
        ChatClient.getInstance().execute(() -> {
            try {
                this.setMemberAttributes(groupId, userId, attributeMap);
                callBack.onSuccess();
            }
            catch (ChatException chatException) {
                callBack.onError(chatException.getErrorCode(), chatException.getDescription());
            }
        });
    }

    protected Map<String, Map<String, String>> fetchMemberAllAttributes(String groupId, List<String> userList) throws ChatException {
        EMAError eMAError = new EMAError();
        Map<String, Map<String, String>> map = this.emaObject.fetchMemberAllAttributes(groupId, userList, eMAError);
        this.handleError(eMAError);
        return map;
    }

    public void asyncFetchGroupMemberAllAttributes(String groupId, String userId, ValueCallBack<Map<String, Map<String, String>>> callBack) {
        ChatClient.getInstance().execute(() -> {
            try {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(userId);
                callBack.onSuccess(this.fetchMemberAllAttributes(groupId, arrayList));
            }
            catch (ChatException chatException) {
                callBack.onError(chatException.getErrorCode(), chatException.getDescription());
            }
        });
    }

    protected Map<String, Map<String, String>> fetchMembersAttributes(String groupId, List<String> userList, List<String> keyList) throws ChatException {
        EMAError eMAError = new EMAError();
        Map<String, Map<String, String>> map = this.emaObject.fetchMembersAttributes(groupId, userList, keyList, eMAError);
        this.handleError(eMAError);
        return map;
    }

    public void asyncFetchGroupMembersAttributes(String groupId, List<String> userList, List<String> keyList, ValueCallBack<Map<String, Map<String, String>>> callBack) {
        ChatClient.getInstance().execute(() -> {
            try {
                callBack.onSuccess(this.fetchMembersAttributes(groupId, userList, keyList));
            }
            catch (ChatException chatException) {
                callBack.onError(chatException.getErrorCode(), chatException.getDescription());
            }
        });
    }

    public Group updateGroupExtension(String groupId, String extension) throws ChatException {
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.updateGroupExtension(groupId, extension, eMAError);
        this.handleError(eMAError);
        return new Group(eMAGroup);
    }

    void onLogout() {
    }

    private void handleError(EMAError error) throws ChatException {
        if (error.errCode() != 0) {
            throw new ChatException(error);
        }
    }

    public static enum GroupStyle {
        GroupStylePrivateOnlyOwnerInvite,
        GroupStylePrivateMemberCanInvite,
        GroupStylePublicJoinNeedApproval,
        GroupStylePublicOpenJoin;

    }
}

