/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import io.agora.chat.ChatClient;
import io.agora.chat.EMContact;
import io.agora.chat.adapter.EMAConnectionListener;
import io.agora.chat.adapter.EMAREncryptUtils;
import io.agora.chat.adapter.EMASessionManager;
import io.agora.util.DeviceUuidFactory;
import io.agora.util.EMLog;
import java.util.Timer;
import java.util.TimerTask;

class EMSessionManager {
    private static final String TAG = "Session";
    private Context appContext = null;
    private static final String PREF_KEY_LOGIN_USER = "easemob.chat.loginuser";
    private static final String PREF_KEY_LOGIN_PWD = "easemob.chat.loginpwd";
    private static final String PREF_KEY_LOGIN_TOKEN = "easemob.chat.login.token";
    private static final String PREF_KEY_LOGIN_WITH_TOKEN = "easemob.chat.login_with_token";
    private static final String PREF_KEY_LOGIN_PWD_GCM = "easemob.chat.loginpwd.gcm";
    private static final String PREF_KEY_LOGIN_TOKEN_GCM = "easemob.chat.login.token.gcm";
    private static final String PREF_KEY_TOKEN_TIMESTAMP = "easemob.chat.token_timestamp";
    private static final String PREF_KEY_TOKEN_AVAILABLE_PERIOD = "easemob.chat.token_available_period";
    private static final String PREF_KEY_IS_LOGIN_WITH_AGORA_TOKEN = "easemob.chat.is_login_with_agora_token";
    public EMContact currentUser = null;
    private static EMSessionManager instance = new EMSessionManager();
    private String lastLoginUser = null;
    private String lastLoginPwd = null;
    private String lastLoginToken = null;
    private String tokenTimeStamp = null;
    private long tokenAvailablePeriod = 0L;
    private Timer timer;
    ChatClient mClient;
    EMASessionManager mSessionManager;
    private EMAREncryptUtils encryptUtils;

    EMSessionManager() {
    }

    static synchronized EMSessionManager getInstance() {
        if (EMSessionManager.instance.appContext == null) {
            EMSessionManager.instance.appContext = ChatClient.getInstance().getContext();
        }
        return instance;
    }

    void init(ChatClient client, EMASessionManager sessionManager) {
        this.mClient = client;
        this.mSessionManager = sessionManager;
        this.encryptUtils = new EMAREncryptUtils();
    }

    String getLastLoginUser() {
        if (this.lastLoginUser == null) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            this.lastLoginUser = sharedPreferences.getString(PREF_KEY_LOGIN_USER, "");
            this.currentUser = new EMContact(this.lastLoginUser);
        }
        return this.lastLoginUser;
    }

    void setLastLoginUser(String username) {
        if (username == null) {
            return;
        }
        this.currentUser = new EMContact(username);
        this.lastLoginUser = username;
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(PREF_KEY_LOGIN_USER, username);
        editor.commit();
    }

    String getLastLoginPwd() {
        if (this.lastLoginPwd == null) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            String string = sharedPreferences.getString(PREF_KEY_LOGIN_PWD_GCM, "");
            if (TextUtils.isEmpty((CharSequence)string)) {
                string = sharedPreferences.getString(PREF_KEY_LOGIN_PWD, "");
                if (TextUtils.isEmpty((CharSequence)string)) {
                    this.lastLoginPwd = "";
                    return this.lastLoginPwd;
                }
                try {
                    this.lastLoginPwd = this.mSessionManager.decrypt(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return this.lastLoginPwd;
            }
            try {
                this.lastLoginPwd = this.decryptData(this.getSecretKey(false), string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.lastLoginPwd;
    }

    void setLastLoginPwd(String pwd) {
        if (pwd == null) {
            return;
        }
        this.lastLoginPwd = pwd;
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        try {
            String string = this.encryptData(this.getSecretKey(true), pwd);
            editor.putString(PREF_KEY_LOGIN_PWD_GCM, string);
            editor.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    String getLastLoginToken() {
        if (this.lastLoginToken == null) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            String string = sharedPreferences.getString(PREF_KEY_LOGIN_TOKEN_GCM, "");
            if (TextUtils.isEmpty((CharSequence)string)) {
                string = sharedPreferences.getString(PREF_KEY_LOGIN_TOKEN, "");
                if (TextUtils.isEmpty((CharSequence)string)) {
                    this.lastLoginToken = "";
                    return this.lastLoginToken;
                }
                try {
                    this.lastLoginToken = this.mSessionManager.decrypt(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return this.lastLoginToken;
            }
            try {
                this.lastLoginToken = this.decryptData(this.getSecretKey(false), string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.lastLoginToken;
    }

    void setLastLoginToken(String token) {
        if (token == null) {
            return;
        }
        this.lastLoginToken = token;
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        try {
            String string = this.encryptData(this.getSecretKey(true), token);
            editor.putString(PREF_KEY_LOGIN_TOKEN_GCM, string);
            editor.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void clearLastLoginUser() {
        try {
            this.lastLoginUser = "";
            this.currentUser.username = "";
            this.currentUser.nick = "";
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(PREF_KEY_LOGIN_USER, this.lastLoginUser);
            editor.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void clearLastLoginPwd() {
        try {
            this.lastLoginPwd = "";
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(PREF_KEY_LOGIN_PWD, this.lastLoginPwd);
            editor.putString(PREF_KEY_LOGIN_PWD_GCM, this.lastLoginPwd);
            editor.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void clearLastLoginToken() {
        try {
            this.lastLoginToken = "";
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(PREF_KEY_LOGIN_TOKEN, this.lastLoginToken);
            editor.putString(PREF_KEY_LOGIN_TOKEN_GCM, this.lastLoginToken);
            editor.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    boolean isLastLoginWithToken() {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
        return sharedPreferences.getBoolean(PREF_KEY_LOGIN_WITH_TOKEN, false);
    }

    void setLastLoginWithToken(boolean loginWithToken) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean(PREF_KEY_LOGIN_WITH_TOKEN, loginWithToken);
        editor.commit();
    }

    public String getLoginUserName() {
        return this.currentUser.username;
    }

    synchronized String encryptData(byte[] key, String data) {
        this.encryptUtils.initAESgcm(key);
        return this.encryptUtils.aesGcmEncrypt(data, 1);
    }

    String decryptData(byte[] key, String encryptData) {
        return this.encryptUtils.aesGcmDecrypt(encryptData, key, 1);
    }

    String getTokenTimeStamp() {
        if (this.tokenTimeStamp == null) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            this.tokenTimeStamp = sharedPreferences.getString(PREF_KEY_TOKEN_TIMESTAMP, "");
        }
        return this.tokenTimeStamp;
    }

    void setLoginWithAgoraData(boolean isLoginWithAgoraToken, String timeStamp, long period) {
        if (timeStamp == null || period < 0L) {
            return;
        }
        this.tokenTimeStamp = timeStamp;
        this.tokenAvailablePeriod = period;
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        try {
            editor.putBoolean(PREF_KEY_IS_LOGIN_WITH_AGORA_TOKEN, isLoginWithAgoraToken);
            editor.putString(PREF_KEY_TOKEN_TIMESTAMP, timeStamp);
            editor.putLong(PREF_KEY_TOKEN_AVAILABLE_PERIOD, this.tokenAvailablePeriod);
            editor.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    long getTokenAvailablePeriod() {
        if (this.tokenAvailablePeriod == 0L) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            this.tokenAvailablePeriod = sharedPreferences.getLong(PREF_KEY_TOKEN_AVAILABLE_PERIOD, 0L);
        }
        return this.tokenAvailablePeriod;
    }

    boolean getIsLoginWithAgoraToken() {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
        return sharedPreferences.getBoolean(PREF_KEY_IS_LOGIN_WITH_AGORA_TOKEN, false);
    }

    synchronized void checkTokenAvailability(EMAConnectionListener connectionListener) {
        String string = this.getTokenTimeStamp();
        if (TextUtils.isEmpty((CharSequence)string) || connectionListener == null) {
            return;
        }
        long l = Long.valueOf(string) - System.currentTimeMillis();
        EMLog.d(TAG, "checkTokenAvailability, delay=" + l);
        if (l <= 0L) {
            connectionListener.onTokenNotification(108);
        } else if (l <= this.getTokenAvailablePeriod() / 2L) {
            connectionListener.onTokenNotification(109);
        }
    }

    synchronized void startCountDownTokenAvailableTime(final EMAConnectionListener connectionListener) {
        String string = this.getTokenTimeStamp();
        if (TextUtils.isEmpty((CharSequence)string) || connectionListener == null) {
            return;
        }
        long l = this.getTokenAvailablePeriod();
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                EMSessionManager.this.checkTokenAvailability(connectionListener);
            }
        };
        long l2 = Long.valueOf(string) - System.currentTimeMillis();
        if (l2 <= 0L) {
            connectionListener.onTokenNotification(108);
        } else if (l2 <= l / 2L) {
            EMLog.d(TAG, "timer.schedule task1, delay=" + l2);
            this.timer.schedule(timerTask, l2);
            connectionListener.onTokenNotification(109);
        } else {
            EMLog.d(TAG, "timer.schedule task1\u3001task2, delay= " + l2);
            TimerTask timerTask2 = new TimerTask(){

                @Override
                public void run() {
                    EMSessionManager.this.checkTokenAvailability(connectionListener);
                }
            };
            this.timer.schedule(timerTask, l2);
            this.timer.schedule(timerTask2, l2 - l / 2L);
        }
    }

    void clearLoginWithAgoraTokenData() {
        try {
            this.tokenAvailablePeriod = 0L;
            this.tokenTimeStamp = "";
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.appContext);
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putLong(PREF_KEY_TOKEN_AVAILABLE_PERIOD, this.tokenAvailablePeriod);
            editor.putString(PREF_KEY_TOKEN_TIMESTAMP, this.tokenTimeStamp);
            editor.putBoolean(PREF_KEY_IS_LOGIN_WITH_AGORA_TOKEN, false);
            editor.commit();
            if (this.timer != null) {
                this.timer.cancel();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    byte[] getSecretKey(boolean replace) {
        String string = this.getDeviceId(replace);
        String string2 = this.getLastLoginUser();
        return this.mSessionManager.getEncryptionKey(string2, string);
    }

    String getDeviceId(boolean replace) {
        DeviceUuidFactory deviceUuidFactory = new DeviceUuidFactory(this.appContext);
        String string = deviceUuidFactory.getDeviceUuid().toString();
        if (replace) {
            this.saveDeviceId(string);
        } else {
            String string2 = DeviceUuidFactory.getBakDeviceId(this.appContext);
            if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.equals((CharSequence)string, (CharSequence)string2)) {
                return string2;
            }
        }
        return string;
    }

    void saveDeviceId(String deviceId) {
        DeviceUuidFactory.saveBakDeviceId(this.appContext, deviceId);
    }
}

