/*
 * Decompiled with CFR 0.152.
 */
package io.agora.chat;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import io.agora.CallBack;
import io.agora.ChatRoomChangeListener;
import io.agora.ResultCallBack;
import io.agora.ValueCallBack;
import io.agora.chat.ChatClient;
import io.agora.chat.ChatOptions;
import io.agora.chat.ChatRoom;
import io.agora.chat.CursorResult;
import io.agora.chat.EMSessionManager;
import io.agora.chat.PageResult;
import io.agora.chat.adapter.EMAChatRoom;
import io.agora.chat.adapter.EMAChatRoomManager;
import io.agora.chat.adapter.EMAChatRoomManagerListener;
import io.agora.chat.adapter.EMAError;
import io.agora.exceptions.ChatException;
import io.agora.util.EMLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ChatRoomManager {
    EMAChatRoomManager emaObject;
    private List<ChatRoomChangeListener> chatRoomListeners = Collections.synchronizedList(new ArrayList());
    private ExecutorService threadPool = null;
    private List<ChatRoom> chatRooms = Collections.synchronizedList(new ArrayList());
    ChatClient mClient;
    EMAChatRoomManagerListener chatRoomListenerImpl = new EMAChatRoomManagerListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLeaveChatRoom(EMAChatRoom chatroom, int leaveReason) {
            ChatClient.getInstance().chatManager().caches.remove(chatroom.getId());
            List list = ChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (ChatRoomChangeListener chatRoomChangeListener : ChatRoomManager.this.chatRoomListeners) {
                        if (leaveReason == 1) {
                            chatRoomChangeListener.onChatRoomDestroyed(chatroom.getId(), chatroom.getName());
                            continue;
                        }
                        chatRoomChangeListener.onRemovedFromChatRoom(leaveReason, chatroom.getId(), chatroom.getName(), ChatClient.getInstance().getCurrentUser());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMemberJoinedChatRoom(EMAChatRoom chatroom, String member) {
            List list = ChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (ChatRoomChangeListener chatRoomChangeListener : ChatRoomManager.this.chatRoomListeners) {
                        chatRoomChangeListener.onMemberJoined(chatroom.getId(), member);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMemberLeftChatRoom(EMAChatRoom chatroom, String member) {
            List list = ChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (ChatRoomChangeListener chatRoomChangeListener : ChatRoomManager.this.chatRoomListeners) {
                        chatRoomChangeListener.onMemberExited(chatroom.getId(), chatroom.getName(), member);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAddMuteList(EMAChatRoom chatRoom, List<String> mutes, long expireTime) {
            List list = ChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (ChatRoomChangeListener chatRoomChangeListener : ChatRoomManager.this.chatRoomListeners) {
                        chatRoomChangeListener.onMuteListAdded(chatRoom.getId(), mutes, expireTime);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoveMutes(EMAChatRoom chatRoom, List<String> mutes) {
            List list = ChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (ChatRoomChangeListener chatRoomChangeListener : ChatRoomManager.this.chatRoomListeners) {
                        chatRoomChangeListener.onMuteListRemoved(chatRoom.getId(), mutes);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWhiteListAdded(EMAChatRoom chatRoom, List<String> members) {
            List list = ChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (ChatRoomChangeListener chatRoomChangeListener : ChatRoomManager.this.chatRoomListeners) {
                        chatRoomChangeListener.onWhiteListAdded(chatRoom.getId(), members);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWhiteListRemoved(EMAChatRoom chatRoom, List<String> members) {
            List list = ChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (ChatRoomChangeListener chatRoomChangeListener : ChatRoomManager.this.chatRoomListeners) {
                        chatRoomChangeListener.onWhiteListRemoved(chatRoom.getId(), members);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAllMemberMuteStateChanged(EMAChatRoom chatRoom, boolean isMuted) {
            List list = ChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (ChatRoomChangeListener chatRoomChangeListener : ChatRoomManager.this.chatRoomListeners) {
                        chatRoomChangeListener.onAllMemberMuteStateChanged(chatRoom.getId(), isMuted);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAddAdmin(EMAChatRoom chatRoom, String admin) {
            List list = ChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (ChatRoomChangeListener chatRoomChangeListener : ChatRoomManager.this.chatRoomListeners) {
                        chatRoomChangeListener.onAdminAdded(chatRoom.getId(), admin);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoveAdmin(EMAChatRoom chatRoom, String admin) {
            List list = ChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (ChatRoomChangeListener chatRoomChangeListener : ChatRoomManager.this.chatRoomListeners) {
                        chatRoomChangeListener.onAdminRemoved(chatRoom.getId(), admin);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onOwnerChanged(EMAChatRoom chatRoom, String newOwner, String oldOwner) {
            List list = ChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (ChatRoomChangeListener chatRoomChangeListener : ChatRoomManager.this.chatRoomListeners) {
                        chatRoomChangeListener.onOwnerChanged(chatRoom.getId(), newOwner, oldOwner);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAnnouncementChanged(EMAChatRoom chatRoom, String announcement) {
            List list = ChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                try {
                    for (ChatRoomChangeListener chatRoomChangeListener : ChatRoomManager.this.chatRoomListeners) {
                        chatRoomChangeListener.onAnnouncementChanged(chatRoom.getId(), announcement);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUpdateSpecificationFromChatroom(EMAChatRoom chatroom) {
            List list = ChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                for (ChatRoomChangeListener chatRoomChangeListener : ChatRoomManager.this.chatRoomListeners) {
                    try {
                        if (null == chatroom) continue;
                        chatRoomChangeListener.onSpecificationChanged(new ChatRoom(chatroom));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAttributesUpdate(String chatRoomId, String attributes, String from) {
            List list = ChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                for (ChatRoomChangeListener chatRoomChangeListener : ChatRoomManager.this.chatRoomListeners) {
                    Map map = ChatRoomManager.this.parseJsonUpdate(attributes);
                    try {
                        if (null == map || map.size() <= 0) continue;
                        chatRoomChangeListener.onAttributesUpdate(chatRoomId, map, from);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAttributesRemoved(String chatRoomId, String attributes, String from) {
            List list = ChatRoomManager.this.chatRoomListeners;
            synchronized (list) {
                for (ChatRoomChangeListener chatRoomChangeListener : ChatRoomManager.this.chatRoomListeners) {
                    List list2 = ChatRoomManager.this.parseJsonRemove(attributes);
                    try {
                        if (null == list2 || list2.size() <= 0) continue;
                        chatRoomChangeListener.onAttributesRemoved(chatRoomId, list2, from);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    };

    public ChatRoomManager(ChatClient client, EMAChatRoomManager manager) {
        this.emaObject = manager;
        this.emaObject.addListener(this.chatRoomListenerImpl);
        this.mClient = client;
        this.threadPool = Executors.newCachedThreadPool();
    }

    public void addChatRoomChangeListener(ChatRoomChangeListener listener) {
        this.chatRoomListeners.add(listener);
    }

    @Deprecated
    public void removeChatRoomChangeListener(ChatRoomChangeListener listener) {
        this.removeChatRoomListener(listener);
    }

    public void removeChatRoomListener(ChatRoomChangeListener listener) {
        this.chatRoomListeners.remove(listener);
    }

    public void joinChatRoom(final String roomId, final ValueCallBack<ChatRoom> callback) {
        this.threadPool.submit(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                EMAChatRoom eMAChatRoom = ChatRoomManager.this.emaObject.joinChatRoom(roomId, eMAError);
                ChatRoom chatRoom = new ChatRoom(eMAChatRoom);
                if (callback != null) {
                    if (eMAError.errCode() == 0 || eMAError.errCode() == 701) {
                        callback.onSuccess(chatRoom);
                    } else {
                        callback.onError(eMAError.errCode(), eMAError.errMsg());
                    }
                }
            }
        });
    }

    public void leaveChatRoom(final String roomId) {
        ChatRoom chatRoom = this.getChatRoom(roomId);
        if (chatRoom == null) {
            return;
        }
        ChatOptions chatOptions = ChatClient.getInstance().getOptions();
        boolean bl = chatOptions.isChatroomOwnerLeaveAllowed();
        String string = chatRoom.getOwner();
        if (!bl && string.equals(EMSessionManager.getInstance().getLastLoginUser())) {
            return;
        }
        boolean bl2 = chatOptions.isDeleteMessagesAsExitChatRoom();
        if (bl2) {
            ChatClient.getInstance().chatManager().deleteConversation(roomId, true);
        }
        this.threadPool.submit(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                ChatRoomManager.this.emaObject.leaveChatRoom(roomId, eMAError);
            }
        });
    }

    public void leaveChatRoom(final String roomId, final CallBack callback) {
        ChatRoom chatRoom = this.getChatRoom(roomId);
        if (chatRoom == null) {
            callback.onError(705, "chatroom not exist");
            return;
        }
        ChatOptions chatOptions = ChatClient.getInstance().getOptions();
        boolean bl = chatOptions.canChatroomOwnerLeave();
        String string = chatRoom.getOwner();
        if (!bl && string.equals(EMSessionManager.getInstance().getLastLoginUser())) {
            callback.onError(1, "The owner can not allowed to leave chatroom");
            return;
        }
        boolean bl2 = chatOptions.deleteMessagesOnLeaveChatroom();
        if (bl2) {
            ChatClient.getInstance().chatManager().deleteConversation(roomId, true);
        }
        this.threadPool.submit(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                ChatRoomManager.this.emaObject.leaveChatRoom(roomId, eMAError);
                if (callback != null) {
                    if (eMAError.errCode() == 0 || eMAError.errCode() == 705) {
                        callback.onSuccess();
                    } else {
                        callback.onError(eMAError.errCode(), eMAError.errMsg());
                    }
                }
            }
        });
    }

    public PageResult<ChatRoom> fetchPublicChatRoomsFromServer(int pageNum, int pageSize) throws ChatException {
        EMAError eMAError = new EMAError();
        PageResult<EMAChatRoom> pageResult = this.emaObject.fetchChatroomsWithPage(pageNum, pageSize, eMAError);
        this.handleError(eMAError);
        List list = (List)pageResult.getData();
        int n = pageResult.getPageCount();
        PageResult<ChatRoom> pageResult2 = new PageResult<ChatRoom>();
        ArrayList<ChatRoom> arrayList = new ArrayList<ChatRoom>();
        for (EMAChatRoom eMAChatRoom : list) {
            arrayList.add(new ChatRoom(eMAChatRoom));
        }
        pageResult2.setPageCount(n);
        pageResult2.setData(arrayList);
        this.chatRooms.clear();
        this.chatRooms.addAll(arrayList);
        return pageResult2;
    }

    @Deprecated
    public CursorResult<ChatRoom> fetchPublicChatRoomsFromServer(int pageSize, String cursor) throws ChatException {
        EMAError eMAError = new EMAError();
        CursorResult<EMAChatRoom> cursorResult = this.emaObject.fetchChatroomsWithCursor(cursor, pageSize, eMAError);
        this.handleError(eMAError);
        CursorResult<ChatRoom> cursorResult2 = new CursorResult<ChatRoom>();
        ArrayList<ChatRoom> arrayList = new ArrayList<ChatRoom>();
        for (EMAChatRoom eMAChatRoom : (List)cursorResult.getData()) {
            arrayList.add(new ChatRoom(eMAChatRoom));
        }
        cursorResult2.setCursor(cursorResult.getCursor());
        cursorResult2.setData(arrayList);
        this.chatRooms.clear();
        this.chatRooms.addAll(arrayList);
        return cursorResult2;
    }

    @Deprecated
    public void asyncFetchPublicChatRoomsFromServer(final int pageSize, final String cursor, final ValueCallBack<CursorResult<ChatRoom>> callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    CursorResult<ChatRoom> cursorResult = ChatRoomManager.this.fetchPublicChatRoomsFromServer(pageSize, cursor);
                    callback.onSuccess(cursorResult);
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void asyncFetchPublicChatRoomsFromServer(final int pageNum, final int pageSize, final ValueCallBack<PageResult<ChatRoom>> callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    PageResult<ChatRoom> pageResult = ChatRoomManager.this.fetchPublicChatRoomsFromServer(pageNum, pageSize);
                    callback.onSuccess(pageResult);
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public ChatRoom fetchChatRoomFromServer(String roomId) throws ChatException {
        return this.fetchChatRoomFromServer(roomId, false);
    }

    public ChatRoom fetchChatRoomFromServer(String roomId, boolean fetchMembers) throws ChatException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.fetchChatroomSpecification(roomId, eMAError, fetchMembers);
        this.handleError(eMAError);
        return new ChatRoom(eMAChatRoom);
    }

    public void asyncFetchChatRoomFromServer(final String roomId, final ValueCallBack<ChatRoom> callback) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ChatRoom chatRoom = ChatRoomManager.this.fetchChatRoomFromServer(roomId);
                    callback.onSuccess(chatRoom);
                }
                catch (ChatException chatException) {
                    callback.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public ChatRoom getChatRoom(String roomId) {
        EMAChatRoom eMAChatRoom = this.emaObject.getChatroom(roomId);
        if (eMAChatRoom == null) {
            return null;
        }
        return new ChatRoom(eMAChatRoom);
    }

    @Deprecated
    public List<ChatRoom> getAllChatRooms() {
        return Collections.unmodifiableList(this.chatRooms);
    }

    public ChatRoom createChatRoom(String subject, String description, String welcomeMessage, int maxUserCount, List<String> members) throws ChatException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.createChatRoom(subject, description, welcomeMessage, ChatRoom.ChatRoomStyle.ChatRoomStylePublicOpenJoin.ordinal(), maxUserCount, members, eMAError);
        this.handleError(eMAError);
        return new ChatRoom(eMAChatRoom);
    }

    public void asyncCreateChatRoom(final String subject, final String description, final String welcomeMessage, final int maxUserCount, final List<String> members, final ValueCallBack<ChatRoom> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(ChatRoomManager.this.createChatRoom(subject, description, welcomeMessage, maxUserCount, members));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void destroyChatRoom(String chatRoomId) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.destroyChatroom(chatRoomId, eMAError);
        this.handleError(eMAError);
    }

    public void asyncDestroyChatRoom(final String chatRoomId, final CallBack callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ChatRoomManager.this.destroyChatRoom(chatRoomId);
                    callBack.onSuccess();
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public ChatRoom changeChatRoomSubject(String chatRoomId, String newSubject) throws ChatException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.changeChatroomSubject(chatRoomId, newSubject, eMAError);
        this.handleError(eMAError);
        return new ChatRoom(eMAChatRoom);
    }

    public void asyncChangeChatRoomSubject(final String chatRoomId, final String newSubject, final ValueCallBack<ChatRoom> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(ChatRoomManager.this.changeChatRoomSubject(chatRoomId, newSubject));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public ChatRoom changeChatroomDescription(String chatRoomId, String newDescription) throws ChatException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.changeChatroomDescription(chatRoomId, newDescription, eMAError);
        this.handleError(eMAError);
        return new ChatRoom(eMAChatRoom);
    }

    public void asyncChangeChatroomDescription(final String chatRoomId, final String newDescription, final ValueCallBack<ChatRoom> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(ChatRoomManager.this.changeChatroomDescription(chatRoomId, newDescription));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public CursorResult<String> fetchChatRoomMembers(String chatRoomId, String cursor, int pageSize) throws ChatException {
        EMAError eMAError = new EMAError();
        CursorResult<String> cursorResult = this.emaObject.fetchChatroomMembers(chatRoomId, cursor, pageSize, eMAError);
        this.handleError(eMAError);
        return cursorResult;
    }

    public void asyncFetchChatRoomMembers(final String chatRoomId, final String cursor, final int pageSize, final ValueCallBack<CursorResult<String>> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(ChatRoomManager.this.fetchChatRoomMembers(chatRoomId, cursor, pageSize));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public ChatRoom muteChatRoomMembers(String chatRoomId, List<String> muteMembers, long duration) throws ChatException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.muteChatroomMembers(chatRoomId, muteMembers, duration, eMAError);
        this.handleError(eMAError);
        return new ChatRoom(eMAChatRoom);
    }

    public void asyncMuteChatRoomMembers(final String chatRoomId, final List<String> muteMembers, final long duration, final ValueCallBack<ChatRoom> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(ChatRoomManager.this.muteChatRoomMembers(chatRoomId, muteMembers, duration));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public ChatRoom unMuteChatRoomMembers(String chatRoomId, List<String> members) throws ChatException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.unmuteChatRoomMembers(chatRoomId, members, eMAError);
        this.handleError(eMAError);
        return new ChatRoom(eMAChatRoom);
    }

    public void asyncUnMuteChatRoomMembers(final String chatRoomId, final List<String> members, final ValueCallBack<ChatRoom> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(ChatRoomManager.this.unMuteChatRoomMembers(chatRoomId, members));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public ChatRoom changeOwner(String chatRoomId, String newOwner) throws ChatException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.transferChatroomOwner(chatRoomId, newOwner, eMAError);
        this.handleError(eMAError);
        return new ChatRoom(eMAChatRoom);
    }

    public void asyncChangeOwner(final String chatRoomId, final String newOwner, final ValueCallBack<ChatRoom> callBack) throws ChatException {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(ChatRoomManager.this.changeOwner(chatRoomId, newOwner));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public ChatRoom addChatRoomAdmin(String chatRoomId, String admin) throws ChatException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.addChatroomAdmin(chatRoomId, admin, eMAError);
        this.handleError(eMAError);
        return new ChatRoom(eMAChatRoom);
    }

    public void asyncAddChatRoomAdmin(final String chatRoomId, final String admin, final ValueCallBack<ChatRoom> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(ChatRoomManager.this.addChatRoomAdmin(chatRoomId, admin));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public ChatRoom removeChatRoomAdmin(String chatRoomId, String admin) throws ChatException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.removeChatRoomAdmin(chatRoomId, admin, eMAError);
        this.handleError(eMAError);
        return new ChatRoom(eMAChatRoom);
    }

    public void asyncRemoveChatRoomAdmin(final String chatRoomId, final String admin, final ValueCallBack<ChatRoom> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(ChatRoomManager.this.removeChatRoomAdmin(chatRoomId, admin));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public Map<String, Long> fetchChatRoomMuteList(String chatRoomId, int pageNum, int pageSize) throws ChatException {
        EMAError eMAError = new EMAError();
        Map<String, Long> map = this.emaObject.fetchChatRoomMuteList(chatRoomId, pageNum, pageSize, eMAError);
        this.handleError(eMAError);
        return map;
    }

    public void asyncFetchChatRoomMuteList(final String chatRoomId, final int pageNum, final int pageSize, final ValueCallBack<Map<String, Long>> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(ChatRoomManager.this.fetchChatRoomMuteList(chatRoomId, pageNum, pageSize));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public ChatRoom removeChatRoomMembers(String chatRoomId, List<String> members) throws ChatException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.removeChatRoomMembers(chatRoomId, members, eMAError);
        this.handleError(eMAError);
        return new ChatRoom(eMAChatRoom);
    }

    public void asyncRemoveChatRoomMembers(final String chatRoomId, final List<String> members, final ValueCallBack<ChatRoom> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(ChatRoomManager.this.removeChatRoomMembers(chatRoomId, members));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public ChatRoom blockChatroomMembers(String chatRoomId, List<String> members) throws ChatException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.blockChatroomMembers(chatRoomId, members, eMAError);
        this.handleError(eMAError);
        return new ChatRoom(eMAChatRoom);
    }

    public void asyncBlockChatroomMembers(final String chatRoomId, final List<String> members, final ValueCallBack<ChatRoom> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(ChatRoomManager.this.blockChatroomMembers(chatRoomId, members));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public ChatRoom unblockChatRoomMembers(String chatRoomId, List<String> members) throws ChatException {
        EMAError eMAError = new EMAError();
        EMAChatRoom eMAChatRoom = this.emaObject.unblockChatRoomMembers(chatRoomId, members, eMAError);
        this.handleError(eMAError);
        return new ChatRoom(eMAChatRoom);
    }

    public void asyncUnBlockChatRoomMembers(final String chatRoomId, final List<String> members, final ValueCallBack<ChatRoom> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(ChatRoomManager.this.unblockChatRoomMembers(chatRoomId, members));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public List<String> fetchChatRoomBlackList(String chatRoomId, int pageNum, int pageSize) throws ChatException {
        EMAError eMAError = new EMAError();
        List<String> list = this.emaObject.fetchChatRoomBlackList(chatRoomId, pageNum, pageSize, eMAError);
        this.handleError(eMAError);
        return list;
    }

    public void asyncFetchChatRoomBlackList(final String chatRoomId, final int pageNum, final int pageSize, final ValueCallBack<List<String>> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(ChatRoomManager.this.fetchChatRoomBlackList(chatRoomId, pageNum, pageSize));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void addToChatRoomWhiteList(final String chatRoomId, final List<String> members, final ValueCallBack<ChatRoom> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMAChatRoom eMAChatRoom = ChatRoomManager.this.emaObject.addToWhiteList(chatRoomId, members, eMAError);
                    ChatRoomManager.this.handleError(eMAError);
                    callBack.onSuccess(new ChatRoom(eMAChatRoom));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void removeFromChatRoomWhiteList(final String chatRoomId, final List<String> members, final ValueCallBack<ChatRoom> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMAChatRoom eMAChatRoom = ChatRoomManager.this.emaObject.removeFromWhiteList(chatRoomId, members, eMAError);
                    ChatRoomManager.this.handleError(eMAError);
                    callBack.onSuccess(new ChatRoom(eMAChatRoom));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void checkIfInChatRoomWhiteList(final String chatRoomId, final ValueCallBack<Boolean> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    Boolean bl = ChatRoomManager.this.emaObject.checkIfInWhiteList(chatRoomId, eMAError);
                    ChatRoomManager.this.handleError(eMAError);
                    callBack.onSuccess(bl);
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void asyncCheckIfInMuteList(final String chatRoomId, final ValueCallBack<Boolean> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    Boolean bl = ChatRoomManager.this.emaObject.checkIfBeMuted(chatRoomId, eMAError);
                    ChatRoomManager.this.handleError(eMAError);
                    callBack.onSuccess(bl);
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void fetchChatRoomWhiteList(final String chatRoomId, final ValueCallBack<List<String>> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    List<String> list = ChatRoomManager.this.emaObject.fetchChatRoomWhiteList(chatRoomId, eMAError);
                    ChatRoomManager.this.handleError(eMAError);
                    callBack.onSuccess(list);
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void muteAllMembers(final String chatRoomId, final ValueCallBack<ChatRoom> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMAChatRoom eMAChatRoom = ChatRoomManager.this.emaObject.muteAllMembers(chatRoomId, eMAError);
                    ChatRoomManager.this.handleError(eMAError);
                    callBack.onSuccess(new ChatRoom(eMAChatRoom));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void unmuteAllMembers(final String chatRoomId, final ValueCallBack<ChatRoom> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMAChatRoom eMAChatRoom = ChatRoomManager.this.emaObject.unmuteAllMembers(chatRoomId, eMAError);
                    ChatRoomManager.this.handleError(eMAError);
                    callBack.onSuccess(new ChatRoom(eMAChatRoom));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void updateChatRoomAnnouncement(String chatRoomId, String announcement) throws ChatException {
        EMAError eMAError = new EMAError();
        this.emaObject.updateChatRoomAnnouncement(chatRoomId, announcement, eMAError);
        this.handleError(eMAError);
    }

    public void asyncUpdateChatRoomAnnouncement(final String chatRoomId, final String announcement, final CallBack callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ChatRoomManager.this.updateChatRoomAnnouncement(chatRoomId, announcement);
                    callBack.onSuccess();
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public String fetchChatRoomAnnouncement(String chatRoomId) throws ChatException {
        EMAError eMAError = new EMAError();
        String string = this.emaObject.fetchChatRoomAnnouncement(chatRoomId, eMAError);
        this.handleError(eMAError);
        return string;
    }

    public void asyncFetchChatRoomAnnouncement(final String chatRoomId, final ValueCallBack<String> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(ChatRoomManager.this.fetchChatRoomAnnouncement(chatRoomId));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    private Map<String, Integer> setChatroomAttribute(String chatRoomId, Map<String, String> attributeMap, boolean autoDelete) throws ChatException {
        EMAError eMAError = new EMAError();
        String string = this.emaObject.setChatroomAttributes(chatRoomId, this.toJsonString(attributeMap, autoDelete), false, eMAError);
        this.handlePartialError(eMAError);
        return this.parseCodeJson(string);
    }

    private Map<String, Integer> setChatroomAttributes(String chatRoomId, Map<String, String> attributeMap, boolean autoDelete, EMAError error) {
        String string = this.emaObject.setChatroomAttributes(chatRoomId, this.toJsonString(attributeMap, autoDelete), false, error);
        return this.parseCodeJson(string);
    }

    public void asyncSetChatroomAttributes(final String chatRoomId, final Map<String, String> attributeMap, final boolean autoDelete, final @NonNull ResultCallBack<Map<String, Integer>> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                if (null == attributeMap || attributeMap.size() == 0) {
                    callBack.onResult(110, new HashMap());
                    return;
                }
                EMAError eMAError = new EMAError();
                Map map = ChatRoomManager.this.setChatroomAttributes(chatRoomId, attributeMap, autoDelete, eMAError);
                callBack.onResult(eMAError.errCode(), map);
            }
        });
    }

    public void asyncSetChatroomAttribute(final String chatRoomId, final String key, final String value, final boolean autoDelete, final @NonNull CallBack callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (TextUtils.isEmpty((CharSequence)key)) {
                        callBack.onError(110, "add Attributes key Cannot be an empty string");
                        return;
                    }
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put(key, value);
                    ChatRoomManager.this.setChatroomAttribute(chatRoomId, hashMap, autoDelete);
                    callBack.onSuccess();
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    private Map<String, Integer> setChatroomAttributeForced(String chatRoomId, Map<String, String> attributeMap, boolean autoDelete) throws ChatException {
        EMAError eMAError = new EMAError();
        String string = this.emaObject.setChatroomAttributes(chatRoomId, this.toJsonString(attributeMap, autoDelete), true, eMAError);
        this.handlePartialError(eMAError);
        return this.parseCodeJson(string);
    }

    private Map<String, Integer> setChatroomAttributesForced(String chatRoomId, Map<String, String> attributeMap, boolean autoDelete, EMAError error) {
        String string = this.emaObject.setChatroomAttributes(chatRoomId, this.toJsonString(attributeMap, autoDelete), true, error);
        return this.parseCodeJson(string);
    }

    public void asyncSetChatroomAttributesForced(final String chatRoomId, final Map<String, String> attributeMap, final boolean autoDelete, final @NonNull ResultCallBack<Map<String, Integer>> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                if (null == attributeMap || attributeMap.size() == 0) {
                    callBack.onResult(110, new HashMap());
                    return;
                }
                EMAError eMAError = new EMAError();
                Map map = ChatRoomManager.this.setChatroomAttributesForced(chatRoomId, attributeMap, autoDelete, eMAError);
                callBack.onResult(eMAError.errCode(), map);
            }
        });
    }

    public void asyncSetChatroomAttributeForced(final String chatRoomId, final String key, final String value, final boolean autoDelete, final @NonNull CallBack callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (TextUtils.isEmpty((CharSequence)key)) {
                        callBack.onError(110, "add Attributes key Cannot be an empty string");
                        return;
                    }
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put(key, value);
                    ChatRoomManager.this.setChatroomAttributeForced(chatRoomId, hashMap, autoDelete);
                    callBack.onSuccess();
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    private Map<String, String> fetchChatroomAttributes(String chatRoomId, List<String> keyList) throws ChatException {
        EMAError eMAError = new EMAError();
        String string = this.emaObject.fetchChatroomAttributes(chatRoomId, keyList, eMAError);
        this.handleError(eMAError);
        return this.parseJson(string);
    }

    public void asyncFetchChatroomAttributesFromServer(final String chatRoomId, final List<String> keyList, final @NonNull ValueCallBack<Map<String, String>> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(ChatRoomManager.this.fetchChatroomAttributes(chatRoomId, keyList));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    public void asyncFetchChatRoomAllAttributesFromServer(final String chatRoomId, final @NonNull ValueCallBack<Map<String, String>> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(ChatRoomManager.this.fetchChatroomAttributes(chatRoomId, null));
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    private Map<String, Integer> removeChatroomAttribute(String chatRoomId, List<String> keyList) throws ChatException {
        EMAError eMAError = new EMAError();
        String string = this.emaObject.removeChatroomAttributes(chatRoomId, keyList, false, eMAError);
        this.handlePartialError(eMAError);
        return this.parseCodeJson(string);
    }

    private Map<String, Integer> removeChatroomAttributes(String chatRoomId, List<String> keyList, EMAError error) {
        String string = this.emaObject.removeChatroomAttributes(chatRoomId, keyList, false, error);
        return this.parseCodeJson(string);
    }

    public void asyncRemoveChatRoomAttributesFromServer(final String chatRoomId, final List<String> keyList, final @NonNull ResultCallBack<Map<String, Integer>> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                if (null == keyList || keyList.size() == 0) {
                    callBack.onResult(110, new HashMap());
                    return;
                }
                EMAError eMAError = new EMAError();
                Map map = ChatRoomManager.this.removeChatroomAttributes(chatRoomId, keyList, eMAError);
                callBack.onResult(eMAError.errCode(), map);
            }
        });
    }

    public void asyncRemoveChatRoomAttributeFromServer(final String chatRoomId, final String key, final @NonNull CallBack callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (TextUtils.isEmpty((CharSequence)key)) {
                        callBack.onError(110, "remove Attribute key Cannot be an empty string");
                        return;
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(key);
                    ChatRoomManager.this.removeChatroomAttribute(chatRoomId, arrayList);
                    callBack.onSuccess();
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    private Map<String, Integer> removeChatroomAttributeForced(String chatRoomId, List<String> keyList) throws ChatException {
        EMAError eMAError = new EMAError();
        String string = this.emaObject.removeChatroomAttributes(chatRoomId, keyList, true, eMAError);
        this.handlePartialError(eMAError);
        return this.parseCodeJson(string);
    }

    private Map<String, Integer> removeChatroomAttributesForced(String chatRoomId, List<String> keyList, EMAError error) {
        String string = this.emaObject.removeChatroomAttributes(chatRoomId, keyList, true, error);
        return this.parseCodeJson(string);
    }

    public void asyncRemoveChatRoomAttributesFromServerForced(final String chatRoomId, final List<String> keyList, final @NonNull ResultCallBack<Map<String, Integer>> callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                if (null == keyList || keyList.size() == 0) {
                    callBack.onResult(110, new HashMap());
                    return;
                }
                EMAError eMAError = new EMAError();
                Map map = ChatRoomManager.this.removeChatroomAttributesForced(chatRoomId, keyList, eMAError);
                callBack.onResult(eMAError.errCode(), map);
            }
        });
    }

    public void asyncRemoveChatRoomAttributeFromServerForced(final String chatRoomId, final String key, final @NonNull CallBack callBack) {
        ChatClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (TextUtils.isEmpty((CharSequence)key)) {
                        callBack.onError(110, "remove Attribute key Cannot be an empty string");
                        return;
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(key);
                    ChatRoomManager.this.removeChatroomAttributeForced(chatRoomId, arrayList);
                    callBack.onSuccess();
                }
                catch (ChatException chatException) {
                    callBack.onError(chatException.getErrorCode(), chatException.getDescription());
                }
            }
        });
    }

    private void handleError(EMAError error) throws ChatException {
        if (error.errCode() != 0) {
            throw new ChatException(error);
        }
    }

    private void handlePartialError(EMAError error) throws ChatException {
        if (error.errCode() != 0 && error.errCode() != 7) {
            throw new ChatException(error);
        }
    }

    private Map<String, String> parseJson(String jsonString) throws ChatException {
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            JSONObject jSONObject = new JSONObject(jsonString);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = jSONObject.getString(string);
                hashMap.put(string, string2);
            }
            return hashMap;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            throw new ChatException(303, "Unknown server error");
        }
    }

    private Map<String, Integer> parseCodeJson(String jsonString) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            return hashMap;
        }
        try {
            JSONObject jSONObject = new JSONObject(jsonString);
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                int n = jSONObject.getInt(string);
                hashMap.put(string, n);
            }
        }
        catch (JSONException jSONException) {
            EMLog.e("parseCodeJson", jSONException.getMessage());
        }
        return hashMap;
    }

    private Map<String, String> parseJsonUpdate(String jsonString) {
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            JSONObject jSONObject = new JSONObject(jsonString);
            JSONObject jSONObject2 = jSONObject.getJSONObject("result");
            JSONArray jSONArray = jSONObject2.getJSONArray("successKeys");
            for (int i = 0; i < jSONArray.length(); ++i) {
                arrayList.add(jSONArray.getString(i));
            }
            JSONObject jSONObject3 = jSONObject.getJSONObject("properties");
            Iterator iterator = jSONObject3.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = jSONObject3.getString(string);
                if (!arrayList.contains(string)) continue;
                hashMap.put(string, string2);
            }
            return hashMap;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
    }

    private List<String> parseJsonRemove(String jsonString) {
        if (TextUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            JSONObject jSONObject = new JSONObject(jsonString);
            JSONObject jSONObject2 = jSONObject.getJSONObject("result");
            JSONArray jSONArray = jSONObject2.getJSONArray("successKeys");
            for (int i = 0; i < jSONArray.length(); ++i) {
                arrayList.add(jSONArray.getString(i));
            }
            return arrayList;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
    }

    private String toJsonString(Map<String, String> extJson, boolean autoDelete) {
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject();
            jSONObject.put("metaData", (Object)new JSONObject(extJson));
            if (autoDelete) {
                jSONObject.put("autoDelete", (Object)"DELETE");
            } else {
                jSONObject.put("autoDelete", (Object)"NO_DELETE");
            }
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return "";
        }
    }

    void onLogout() {
    }
}

