/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package io.agora.util;

import android.content.Context;

import java.text.DecimalFormat;

public class TextFormater {


	public static String getDataSize(long bytes) {
		DecimalFormat format = new DecimalFormat("###.00");
		if (bytes < 0) {
			return "error";
		} else if (bytes < 1024) {
			return bytes + "bytes";
		} else if (bytes < 1024 * 1024) {
			return format.format(bytes / 1024f) + "KB";
		} else if (bytes < 1024 * 1024 * 1024) {
			return format.format(bytes / 1024f / 1024f) + "MB";
		} else {
			return format.format(bytes / 1024f / 1024f /1024f) + "GB";
		}
	}
	
	/**
	 * 
	 * @param kb
	 * @return
	 */
	public static String getKBDataSize(long kb) {
		DecimalFormat format = new DecimalFormat("###.00");
		if (kb < 1024) {
			return kb + "KB";
		} else if (kb < 1024 * 1024) {
			return format.format(kb / 1024f) + "MB";
		} else if (kb < 1024 * 1024*1024) {
			return format.format(kb / 1024f/1024f) + "GB";
		} else{
			return "error";
		}
	}
	
	public static String formatStr(Context context ,int resId, String str) {
        String res = context.getText(resId).toString();
        return String.format(res, str);
    }
	
	
	 private static final int GB_SP_DIFF = 160;  
	 private static final int[] secPosvalueList = {  
	       1601, 1637, 1833, 2078, 2274, 2302, 2433, 2594, 2787,  
	       3106, 3212, 3472, 3635, 3722, 3730, 3858, 4027, 4086,  
	       4390, 4558, 4684, 4925, 5249, 5600};  
	 private static final char[] firstLetter = {  
	       'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j',  
	       'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's',  
	       't', 'w', 'x', 'y', 'z'};  
	  
	 /**
	  * get the string first letter
	  * @param oriStr
	  * @return
	  */
	 public static String getFirstLetter(String oriStr) {  
	     String str = oriStr.toLowerCase();  
	     StringBuilder buffer = new StringBuilder();
	     char ch;  
	     char[] temp;  
	     for (int i = 0; i < str.length(); i++) {   
	       ch = str.charAt(i);  
	       temp = new char[] {  
	           ch};  
	       byte[] uniCode = new String(temp).getBytes();  
	       if (uniCode[0] < 128 && uniCode[0] > 0) {  
	         buffer.append(temp);  
	       }  
	       else {  
	         buffer.append(convert(uniCode));  
	       }  
	     }  
	     return buffer.toString().substring(0,1);  
	 }  
	  
	 private static char convert(byte[] bytes) {  
	  
	     char result = '-';  
	     int secPosvalue = 0;  
	     int i;  
	     for (i = 0; i < bytes.length; i++) {  
	       bytes[i] -= GB_SP_DIFF;  
	     }  
	     secPosvalue = bytes[0] * 100 + bytes[1];  
	     for (i = 0; i < 23; i++) {  
	       if (secPosvalue >= secPosvalueList[i] &&  
	           secPosvalue < secPosvalueList[i + 1]) {  
	         result = firstLetter[i];  
	         break;  
	       }  
	     }  
	     return result;  
	 }  
	   
		 
}
