package io.agora.push.platform.vivo;

import android.content.Context;

import io.agora.Error;
import io.agora.push.PushConfig;
import io.agora.push.PushHelper;
import io.agora.push.PushType;
import io.agora.push.PushListener;
import io.agora.push.platform.IPush;
import io.agora.util.EMLog;
import com.vivo.push.IPushActionListener;
import com.vivo.push.PushClient;
import com.vivo.push.util.VivoPushException;

/**
 * Created by zhangsong on 19-2-20
 * <p>
 * 文档地址：https://dev.vivo.com.cn/documentCenter/doc/158
 * <p>
 * 应用安装后默认未打开设置中的通知栏通知权限，需要手动打开。
 */
public class EMVivoPush extends IPush {
    private static final String TAG = "EMVivoPush";

    @Override
    public PushType getPushType() {
        return PushType.VIVOPUSH;
    }

    @Override
    public void onRegister(final Context context, PushConfig config, PushListener pushListener) {
        boolean support = PushClient.getInstance(context).isSupport();
        if (!support) {
            PushHelper.getInstance().onErrorResponse(getPushType(), Error.PUSH_NOT_SUPPORT);
            return;
        }

        try {
            PushClient.getInstance(context).initialize();
            PushClient.getInstance(context).turnOnPush(new IPushActionListener() {
                @Override
                public void onStateChanged(int state) {
                    if (state == 0) {
                        final String regId = PushClient.getInstance(context).getRegId();
                        // send regId to hyphenate server.
                        PushHelper.getInstance().onReceiveToken(getPushType(), regId);
                    } else {
                        // handle register error.
                        PushHelper.getInstance().onErrorResponse(getPushType(), state);
                    }
                }
            });
        } catch (VivoPushException e) {
            EMLog.e(TAG, "Vivo init failed: " + e.getCode() + " " + e.getMessage());
        }
    }

    @Override
    public void onUnregister(Context context) {
    }

    @Override
    public String onGetNotifierName(PushConfig config) {
        return config.getVivoAppId() + "#" + config.getVivoAppKey();
    }
}
