package io.agora.push.platform.oppo;

import android.content.Context;

import com.heytap.msp.push.HeytapPushManager;
import com.heytap.msp.push.callback.ICallBackResultService;
import io.agora.Error;
import io.agora.push.PushConfig;
import io.agora.push.PushHelper;
import io.agora.push.PushType;
import io.agora.push.PushListener;
import io.agora.push.platform.IPush;
import io.agora.util.EMLog;

/**
 * Created by zhangsong on 19-2-20
 * <p>
 * 文档地址：https://open.oppomobile.com/wiki/doc#id=10196
 * <p>
 * 应用安装后默认未打开设置中的通知栏通知权限，需要手动打开。
 * <p>
 * 使用Oppo推送需要先在Oppo应用商店上架，该Demo包名被占用，所以使用了新包名：io.agora.chatuidemo.push.
 * 打包时需要修改app/build.gradle中的applicationId和google-service.json中的包名
 */
public class EMOppoPush extends IPush {
    private static final String TAG = "EMOppoPush";

    @Override
    public PushType getPushType() {
        return PushType.OPPOPUSH;
    }

    @Override
    public void onRegister(Context context, PushConfig config, PushListener pushListener) {
        boolean support = HeytapPushManager.isSupportPush(context);
        if (!support) {
            // handle register error.
            PushHelper.getInstance().onErrorResponse(getPushType(), Error.PUSH_NOT_SUPPORT);
            return;
        }

        HeytapPushManager.register(context, config.getOppoAppKey(), config.getOppoAppSecret(),
                new ICallBackResultService() {
                    @Override
                    public void onRegister(int responseCode, String registerID) {
                        if (responseCode == 0) {
                            PushHelper.getInstance().onReceiveToken(getPushType(), registerID);
                        } else {
                            // handle register error.
                            PushHelper.getInstance().onErrorResponse(getPushType(), responseCode);
                        }
                    }

                    @Override
                    public void onUnRegister(int responseCode) {

                    }

                    @Override
                    public void onSetPushTime(int responseCode, String pushTime) {

                    }

                    @Override
                    public void onGetPushStatus(int responseCode, int status) {

                    }

                    @Override
                    public void onGetNotificationStatus(int responseCode, int status) {

                    }

                    @Override
                    public void onError(int i, String s) {
                        EMLog.e(TAG, "Oppo init failed: " + i + " " + s);
                    }
                });
    }

    @Override
    public void onUnregister(Context context) {
    }

    @Override
    public String onGetNotifierName(PushConfig config) {
        return config.getOppoAppKey();
    }
}
