package io.agora.push.platform.mi;

import android.content.Context;
import android.text.TextUtils;

import io.agora.push.PushConfig;
import io.agora.push.PushHelper;
import io.agora.push.PushType;
import io.agora.push.PushListener;
import io.agora.push.platform.IPush;
import com.xiaomi.mipush.sdk.MiPushClient;

/**
 * Created by zhangsong on 19-2-20
 * <p>
 * 文档地址：https://dev.mi.com/console/doc/detail?pId=41
 */
public class EMMiPush extends IPush {
    private static final String TAG = "EMMiPush";

    @Override
    public PushType getPushType() {
        return PushType.MIPUSH;
    }

    @Override
    public void onRegister(Context context, PushConfig config, PushListener pushListener) {
        String regId = MiPushClient.getRegId(context);
        if (TextUtils.isEmpty(regId)) {
            MiPushClient.registerPush(context, config.getMiAppId(), config.getMiAppKey());
        } else {
            PushHelper.getInstance().onReceiveToken(getPushType(), regId);
        }
    }

    @Override
    public void onUnregister(Context context) {
    }

    @Override
    public String onGetNotifierName(PushConfig config) {
        return config.getMiAppId();
    }
}
